<?php
/*
 * $Horde: imp/identities.php,v 2.15.2.21 2004/03/26 22:43:24 jan Exp $
 *
 * Copyright 2001-2004 Jan Schneider <jan@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('IDENT_EDIT',   1);
define('IDENT_SAVE',   2);
define('IDENT_DELETE', 3);
define('IMP_BASE', dirname(__FILE__));
require_once IMP_BASE . '/lib/base.php';
require_once IMP_BASE . '/lib/Identity/IMP.php';


IMP::checkAuthentication(OP_HALFOPEN);

/* Start to compress pages if requested. */
if ($conf['compress_pages']) {
    ob_start('ob_gzhandler');
}

$identity = new Identity_IMP();
$to_edit = null;

// redirect user if not allowed to change anything
if ($identity->isLocked()) {
    header('Location: ' . Horde::applicationUrl('prefs.php?group=personal', true));
    exit;
}

$actionID = Horde::getFormData('actionID', NO_ACTION);

// handle clients without javascript
if ($actionID == NO_ACTION) {
    if (isset($_POST['edit'])) {
        $actionID = IDENT_EDIT;
    } elseif (isset($_POST['save'])) {
        $actionID = IDENT_SAVE;
    } elseif (isset($_POST['delete'])) {
        $actionID = IDENT_DELETE;
    } elseif (isset($_POST['back'])) {
        header('Location: ' . Horde::applicationUrl('prefs.php?group=personal', true));
        exit;
    }
}

if ($actionID == NO_ACTION && $prefs->isLocked('default_identity')) {
    $actionID = IDENT_EDIT;
    $_POST['identity'] = $identity->getDefault();
}

/* Run through the action handlers */
switch ($actionID) {
 case IDENT_EDIT:
     $to_edit = Horde::getFormData('identity');
     break;

 case IDENT_SAVE:
     $edit_identity = Horde::getFormData('edit_identity');
     if (!isset($edit_identity) || $edit_identity == '') {
         $edit_identity = $identity->add();
     }
     $old_default = $identity->getDefault();
     $identity->setDefault($edit_identity);

     $id = Horde::getFormData('id');
     if (isset($id) && !empty($id)) {
         $identity->setValue('id', $id);
     } else {
         $identity->setValue('id', _("Unnamed"));
         $id = _("Unnamed");
     }

     /* RFC 2822 [3.2.5] does not allow the '\' character to be used in
        the personal portion of an e-mail string. */
     $fullname = Horde::getFormData('fullname');
     if (strpos($fullname, '\\') === false) {
         $identity->setValue('fullname', $fullname);
     } else {
         Horde::raiseMessage(_("You can not have the '\\' character in your full name."), HORDE_WARNING);
         break;
     }

     $identity->setValue('from_addr', Horde::getFormData('from_addr'));
     $identity->setValue('replyto_addr', Horde::getFormData('replyto_addr'));

     $identity->setValue('signature', Horde::getFormData('signature'));
     $identity->setValue('sig_dashes', Horde::getFormData('sig_dashes', 0));
     $identity->setValue('sig_first', Horde::getFormData('sig_first', 0));

     $identity->setValue('save_sent_mail', Horde::getFormData('save_sent_mail', 0));
     $sent_mail_folder = Horde::getFormData('sent_mail');
     $sent_mail_new = IMP::utf7Encode(Horde::getFormData('sent_mail_new'));
     $sent_mail_default = $prefs->getValue('sent_mail_folder');
     if ($conf['user']['allow_folders'] && !$prefs->isLocked('sent_mail_folder')) {
         if (empty($sent_mail_folder) && !empty($sent_mail_new)) {
             $sent_mail_folder = $sent_mail_new;
         } elseif ($sent_mail_folder == '-1' && !empty($sent_mail_default)) {
             $sent_mail_folder = $sent_mail_default;
         }
         $sent_mail_folder = IMP::stripPreambleString($sent_mail_folder);
         if (!empty($sent_mail_folder)) {
             include_once IMP_BASE . '/lib/Folder.php';
             if (!IMP_Folder::exists($imp['stream'], IMP::addPreambleString($sent_mail_folder))) {
                 IMP_Folder::create($imp['stream'], IMP::addPreambleString($sent_mail_folder), $prefs->getValue('subscribe'));
                 unset($imp['imaptree']);
             }
         }
         $identity->setValue('sent_mail_folder', $sent_mail_folder);
     }

     $identity->setValue('private_key', Horde::getFormData('private_key'));
     $identity->setValue('private_key_type', Horde::getFormData('private_key_type'));

     $identity->setDefault($old_default);
     $identity->save();

     if ($prefs->isLocked('default_identity')) {
         $to_edit = Horde::getFormData('identity');
     }

     Horde::raiseMessage(sprintf(_("The identity \"%s\" has been saved."), $id), HORDE_SUCCESS);
     break;

 case IDENT_DELETE:
     $to_delete = Horde::getFormData('identity');
     if ($to_delete != -1) {
         $deleted_identity = $identity->delete($to_delete);
         Horde::raiseMessage(sprintf(_("The identity \"%s\" has been deleted."), $deleted_identity[0]['id']), HORDE_SUCCESS);
     } else {
         Horde::raiseMessage(_("You must select an identity to be deleted."), HORDE_WARNING);
     }
     break;

}

$title = _("Identities");
$js_onLoad = null;
$identities = $identity->getAll('id');

require IMP_TEMPLATES . '/common-header.inc';
require IMP_BASE . '/menu.php';
require IMP_BASE . '/status.php';

require IMP_TEMPLATES . '/identities/javascript.inc';
require IMP_TEMPLATES . '/identities/manage.inc';

$registry->shutdown();

require IMP_TEMPLATES . '/common-footer.inc';

?>
