module Hat.Data.IORefBuiltin (IORef, aIORef, toIORef, fromIORef) where

import qualified Data.IORef
import qualified Prelude
import Hat.Hat as T
import Hat.Prelude
#if __GLASGOW_HASKELL__
import GHC.Base (unsafeCoerce#)
unsafeCoerce = GHC.Base.unsafeCoerce#
#elif __NHC__
import NonStdUnsafeCoerce (unsafeCoerce)
#endif

newtype IORef a = IORef (Data.IORef.IORef (R a))

aIORef :: RefAtom
aIORef = mkAbstract "IORef"

toIORef :: (RefExp->R a->b)
           -> RefExp -> R (IORef a) -> Data.IORef.IORef b
toIORef f h (R (IORef e) _) = fakemap (f h) e

fromIORef :: (RefExp->a->R b)
             -> RefExp -> Data.IORef.IORef a -> R (IORef b)
fromIORef f h e = R (IORef (fakemap (f h) e))
                    (T.mkValueUse h mkNoSrcPos aIORef)

fakemap :: (a -> b) -> c a -> c b
fakemap f e = unsafeCoerce e

