//$Id: font-combo.cc,v 1.4 2003/06/30 14:08:00 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "font-combo.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include <gtk--/menu.h>

using namespace Guikachu::GUI::PropertyEditors;

FontCombo::FontCombo (property_t   &property_,
		      op_factory_t *op_factory_):
    PropertyEditor (this),
    property (property_),
    op_factory (op_factory_),
    update_block (false)
{
    Gtk::Menu *menu_items = new Gtk::Menu;

#define FONT_ITEM(s, num)							\
	menu_items->items ().push_back (					\
	    Gtk::Menu_Helpers::MenuElem (					\
		s, SigC::bind (SigC::slot (this, &FontCombo::menu_cb), num)));

    FONT_ITEM (_("Regular"), 0);
    FONT_ITEM (_("Bold"), 1);
    FONT_ITEM (_("Large"), 2);
    FONT_ITEM (_("Symbol"), 3);
    FONT_ITEM (_("Symbol 11"), 4);
    FONT_ITEM (_("Symbol 7"), 5);
    FONT_ITEM (_("LED"), 6);
    FONT_ITEM (_("Large Bold"), 7);

#undef FONT_ITEM

    menu_items->show_all ();
    set_menu (*manage (menu_items));
    
    property.changed.connect (SigC::slot (this, &FontCombo::update));
    update ();
}


void FontCombo::update ()
{
    int new_font_num = property;

    g_return_if_fail (new_font_num < 8);

    update_block = true;
    set_history (new_font_num);
    update_block = false;
}

void FontCombo::menu_cb (int font_num)
{
    if (update_block)
	return;

    op_factory->push_change (font_num);
}
