//$Id: vsignal.h,v 1.3 2003/12/22 14:05:33 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 *
 * This portion of the code is written by Martin Schulze <MHL.Schulze@t-online.de>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_VSIGNAL_H
#define GUIKACHU_VSIGNAL_H

#include <sigc++/basic_signal.h>

namespace Guikachu
{
    /* This is a SigC::Signal0<void> wrapper that has only one
       difference from the real McCoy: its emit() member function is
       virtual and thus can be overwritten.
       This is done by QueuedSignal to queue up emission requests and
       schedule real signal emissions to when GTK+ is idle
    */
       
    
    class VSignal
    {
    private:
	typedef SigC::Signal0<void>       real_signal_t;
	typedef real_signal_t::InSlotType slot_t;

	real_signal_t real_signal;
	
    public:
	VSignal ()          {};
	virtual ~VSignal () {};

	SigC::Connection connect (const slot_t &s);

	virtual SigC::Slot0<void> slot ();
	virtual void emit ();
	void operator() () { emit (); };
    };
}

#endif /* !GUIKACHU_QUEUED_SIGNAL_H */
