//$Id: main.cc,v 1.23 2003/06/30 14:07:55 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "config.h"
#include <libgnome/libgnome.h>

#include <gnome--/main.h>
#include <glade/glade.h>
#include <fcntl.h>

#ifdef GUIKACHU_USE_WM_ICONS
#include <libgnomeui/gnome-window-icon.h>
#endif

#include "session.h"
#include "ui.h"

namespace {
    enum FileType
    {
	FILETYPE_REGULAR,
	FILETYPE_GLADE,
	FILETYPE_FONT,
	FILETYPE_TARGET_DEF
    };
    
    struct FileEntry
    {
	const char *filename;
	FileType type;
    };
}
    
static bool check_file (FileEntry& file)
{
    bool        success  = true;
    std::string filename = file.filename;

    /* For _REGULAR and _FONT */
    int fd = -1;

    /* For _GLADE */
    GladeXML *gui = 0;
    
    switch (file.type)
    {
    case FILETYPE_REGULAR:
	fd = open (filename.c_str (), 0);
	if (fd == -1)
	    success = false;
	else
	    close (fd);
	break;
	
    case FILETYPE_GLADE:
	filename = std::string (GUIKACHU_GLADEDIR) + "/" + filename;
	gui = glade_xml_new (filename.c_str (), 0);
	if (!gui)
	    success = false;
	else
	    gtk_object_unref (GTK_OBJECT (gui));
	break;
	
    case FILETYPE_FONT:
	filename = std::string (GUIKACHU_FONTDIR) + "/" + filename;
	fd = open (filename.c_str (), 0);
	if (fd == -1)
	    success = false;
	else
	    close (fd);
	break;

    case FILETYPE_TARGET_DEF:
	filename = std::string (GUIKACHU_TARGETDIR) + "/" + filename;
	fd = open (filename.c_str (), 0);
	if (fd == -1)
	    success = false;
	else
	    close (fd);
	break;
    }

    return success;
}

static bool check_files ()
{
    bool success = true;
    
    FileEntry files[] = {
	{ "guikachu.glade",       FILETYPE_GLADE },
	{ "stdfont.txt",          FILETYPE_FONT },
	{ "boldfont.txt",         FILETYPE_FONT },
	{ "bigfont.txt",          FILETYPE_FONT },
        { "symbol.txt",           FILETYPE_FONT },
        { "symbol11.txt",         FILETYPE_FONT },
        { "symbol7.txt",          FILETYPE_FONT },
        { "ledfont.txt",          FILETYPE_FONT },
        { "bigbold.txt",          FILETYPE_FONT },
	{ "palm.guikachu-target", FILETYPE_TARGET_DEF }
    };

    for (unsigned int i = 0;
	 i < (sizeof (files) / sizeof (FileEntry));
	 i++)
    {
	if (!check_file (files[i]))
	{
	    char *buffer = g_strdup_printf (
		_("Opening file `%s' (required by Guikachu) failed.\n"
		  "Check your Guikachu installation"),
		g_basename (files[i].filename));
	    Guikachu::UI::show_error (buffer);
	    g_free (buffer);
	    
	    success = false;
	}
    }

    return success;
}

int main (int argc, char **argv)
{
#ifdef ENABLE_NLS
    bindtextdomain (PACKAGE, GNOME_LOCALEDIR);
    textdomain (PACKAGE);
#endif
    
    Guikachu::Main app (argc, argv);
    
    using namespace Guikachu;
    
    if (!check_files ())
	return -1;

#ifdef GUIKACHU_USE_WM_ICONS
    gnome_window_icon_set_default_from_file (GNOME_ICONDIR "/guikachu.png");
#endif
    
    app.run ();
}
