%define name guidedog
%define version 1.0.0
%define release 1mdk

Summary: Advanced Routing Utility
Name: %{name}
Version: %{version}
Release: %{release}
Source: %{name}-%{version}.tar.gz
Copyright: GPL
Group: Networking/Utilities
URL: http://www.simonzone.com/software/guidedog/
Packager: Simon Edwards
Distribution: Linux-Mandrake
BuildRoot: %{_tmppath}/%{name}-buildroot
Requires: iptables kdebase chkconfig
Prefix: %{_prefix}

%description
Guidedog is an advanced routing/network configuration utility for KDE 2 or 3
running on Linux 2.4 based machines. Using Guidedog you can easily
activate packet routing/forwarding and also more advanced networking such
as IP masquerade.

This RPM is for Mandrake 9.2.

%prep
rm -rf $RPM_BUILD_ROOT

%setup

%build
CXXFLAGS="$RPM_OPT_FLAGS"
./configure --prefix=%{prefix}
make

%install
make install prefix=$RPM_BUILD_ROOT/%{_prefix}

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,0755)
%doc README TODO AUTHORS COPYING ChangeLog
%{prefix}/bin/guidedog
%{prefix}/share/apps/guidedog/*
%{prefix}/share/doc/HTML/en/guidedog/
%{prefix}/share/icons/locolor/32x32/apps/guidedog.png
%{prefix}/share/icons/hicolor/48x48/apps/guidedog.png
%{prefix}/share/icons/hicolor/32x32/apps/guidedog.png
%{prefix}/share/icons/locolor/16x16/apps/guidedog.png
%{prefix}/lib/menu/guidedog
%{prefix}/share/applnk/System/guidedog.desktop
%post

if [ ! -e /etc/rc.guidedog ]; then
  echo "#!/bin/sh" > /etc/rc.guidedog
  echo "# This is just a place holder rc.guidedog file." >> /etc/rc.guidedog
  echo "# It will be over written once the Guidedog configuration utility is used." >> /etc/rc.guidedog
  echo "# --Guidedog, http://www.simonzone.com/software/guidedog/" >> /etc/rc.guidedog
  chmod u+x /etc/rc.guidedog
fi

if [ ! -e /etc/sysconfig/network-scripts/ifup.d/20Guidedog ]; then
  /bin/ln -s /etc/rc.guidedog /etc/sysconfig/network-scripts/ifup.d/20Guidedog
fi
if [ ! -e /etc/sysconfig/network-scripts/ifdown.d/20Guidedog ]; then
  /bin/ln -s /etc/rc.guidedog /etc/sysconfig/network-scripts/ifdown.d/20Guidedog
fi

if [ -x /usr/bin/update-menus ]; then
    /usr/bin/update-menus
fi

%postun

if [ "$1" = 0 ]; then
    if [ -x /usr/bin/update-menus ]; then
        /usr/bin/update-menus
    fi
fi

%changelog
* Tue Nov 11 2003 Simon Edwards <simon@simonzone.com> 1.0.0-1mdk

- Update to 1.0.0 release.

* Mon Sep 29 2003 Simon Edwards <simon@simonzone.com> 0.9.2-1mdk

- Update to 0.9.2 release.
- Fixed a bug in the rpm 'postun' section. Make sure that you
  install this RPM by first removing any old version, and then
  installing this one.

* Thu May 08 2003 Simon Edwards <simon@simonzone.com> 0.9.1-1mdk

- Update to 0.9.1 release.

* Thu Jul 11 2002 Simon Edwards <simon@simonzone.com> 0.9.0-1mdk82k3

- Script no longer uses the 'sysctl' command.
- Added /usr/local/sbin/ to the command search path.
