// Copyright (C) 2000-2003, Luca Padovani <luca.padovani@cs.unibo.it>.
//
// This file is part of GtkMathView, a Gtk widget for MathML.
// 
// GtkMathView is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// GtkMathView is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with GtkMathView; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
// For details, see the GtkMathView World-Wide-Web page,
// http://helm.cs.unibo.it/mml-widget, or send a mail to
// <luca.padovani@cs.unibo.it>

// WARNING: do not edit! This file has been generated automatically


#include <Char.hh>

  
typedef struct TableEntry
{
  Char16 normal;
  Char32 variant;
} TableEntry;

static TableEntry table[] =
{
  { 0x00030, 0x1D7CE }, 
  { 0x00031, 0x1D7CF }, 
  { 0x00032, 0x1D7D0 }, 
  { 0x00033, 0x1D7D1 }, 
  { 0x00034, 0x1D7D2 }, 
  { 0x00035, 0x1D7D3 }, 
  { 0x00036, 0x1D7D4 }, 
  { 0x00037, 0x1D7D5 }, 
  { 0x00038, 0x1D7D6 }, 
  { 0x00039, 0x1D7D7 }, 
  { 0x00041, 0x1D400 }, 
  { 0x00042, 0x1D401 }, 
  { 0x00043, 0x1D402 }, 
  { 0x00044, 0x1D403 }, 
  { 0x00045, 0x1D404 }, 
  { 0x00046, 0x1D405 }, 
  { 0x00047, 0x1D406 }, 
  { 0x00048, 0x1D407 }, 
  { 0x00049, 0x1D408 }, 
  { 0x0004A, 0x1D409 }, 
  { 0x0004B, 0x1D40A }, 
  { 0x0004C, 0x1D40B }, 
  { 0x0004D, 0x1D40C }, 
  { 0x0004E, 0x1D40D }, 
  { 0x0004F, 0x1D40E }, 
  { 0x00050, 0x1D40F }, 
  { 0x00051, 0x1D410 }, 
  { 0x00052, 0x1D411 }, 
  { 0x00053, 0x1D412 }, 
  { 0x00054, 0x1D413 }, 
  { 0x00055, 0x1D414 }, 
  { 0x00056, 0x1D415 }, 
  { 0x00057, 0x1D416 }, 
  { 0x00058, 0x1D417 }, 
  { 0x00059, 0x1D418 }, 
  { 0x0005A, 0x1D419 }, 
  { 0x00061, 0x1D41A }, 
  { 0x00062, 0x1D41B }, 
  { 0x00063, 0x1D41C }, 
  { 0x00064, 0x1D41D }, 
  { 0x00065, 0x1D41E }, 
  { 0x00066, 0x1D41F }, 
  { 0x00067, 0x1D420 }, 
  { 0x00068, 0x1D421 }, 
  { 0x00069, 0x1D422 }, 
  { 0x0006A, 0x1D423 }, 
  { 0x0006B, 0x1D424 }, 
  { 0x0006C, 0x1D425 }, 
  { 0x0006D, 0x1D426 }, 
  { 0x0006E, 0x1D427 }, 
  { 0x0006F, 0x1D428 }, 
  { 0x00070, 0x1D429 }, 
  { 0x00071, 0x1D42A }, 
  { 0x00072, 0x1D42B }, 
  { 0x00073, 0x1D42C }, 
  { 0x00074, 0x1D42D }, 
  { 0x00075, 0x1D42E }, 
  { 0x00076, 0x1D42F }, 
  { 0x00077, 0x1D430 }, 
  { 0x00078, 0x1D431 }, 
  { 0x00079, 0x1D432 }, 
  { 0x0007A, 0x1D433 }, 
  { 0x00391, 0x1D6A8 }, 
  { 0x00392, 0x1D6A9 }, 
  { 0x00393, 0x1D6AA }, 
  { 0x00394, 0x1D6AB }, 
  { 0x00395, 0x1D6AC }, 
  { 0x00396, 0x1D6AD }, 
  { 0x00397, 0x1D6AE }, 
  { 0x00398, 0x1D6AF }, 
  { 0x00399, 0x1D6B0 }, 
  { 0x0039A, 0x1D6B1 }, 
  { 0x0039B, 0x1D6B2 }, 
  { 0x0039C, 0x1D6B3 }, 
  { 0x0039D, 0x1D6B4 }, 
  { 0x0039E, 0x1D6B5 }, 
  { 0x0039F, 0x1D6B6 }, 
  { 0x003A0, 0x1D6B7 }, 
  { 0x003A1, 0x1D6B8 }, 
  { 0x003A3, 0x1D6BA }, 
  { 0x003A4, 0x1D6BB }, 
  { 0x003A5, 0x1D6BC }, 
  { 0x003A6, 0x1D6BD }, 
  { 0x003A7, 0x1D6BE }, 
  { 0x003A8, 0x1D6BF }, 
  { 0x003A9, 0x1D6C0 }, 
  { 0x003B1, 0x1D6C2 }, 
  { 0x003B2, 0x1D6C3 }, 
  { 0x003B3, 0x1D6C4 }, 
  { 0x003B4, 0x1D6C5 }, 
  { 0x003B5, 0x1D6C6 }, 
  { 0x003B6, 0x1D6C7 }, 
  { 0x003B7, 0x1D6C8 }, 
  { 0x003B8, 0x1D6C9 }, 
  { 0x003B9, 0x1D6CA }, 
  { 0x003BA, 0x1D6CB }, 
  { 0x003BB, 0x1D6CC }, 
  { 0x003BC, 0x1D6CD }, 
  { 0x003BD, 0x1D6CE }, 
  { 0x003BE, 0x1D6CF }, 
  { 0x003BF, 0x1D6D0 }, 
  { 0x003C0, 0x1D6D1 }, 
  { 0x003C1, 0x1D6D2 }, 
  { 0x003C2, 0x1D6D3 }, 
  { 0x003C3, 0x1D6D4 }, 
  { 0x003C4, 0x1D6D5 }, 
  { 0x003C5, 0x1D6D6 }, 
  { 0x003C6, 0x1D6D7 }, 
  { 0x003C7, 0x1D6D8 }, 
  { 0x003C8, 0x1D6D9 }, 
  { 0x003C9, 0x1D6DA }, 
  { 0x003D1, 0x1D6DD }, 
  { 0x003D5, 0x1D6DF }, 
  { 0x003D6, 0x1D6E1 }, 
  { 0x003F0, 0x1D6DE }, 
  { 0x003F1, 0x1D6E0 }, 
  { 0x003F4, 0x1D6B9 }, 
  { 0x02202, 0x1D6DB }, 
  { 0x02207, 0x1D6C1 }, 
  { 0x0220A, 0x1D6DC }, 
  { 0, 0 }
};

Char32 
map_variant_bold
(Char32 ch)
{
  if (ch >= 0x0030 and ch < 0x0039) return table[ch - 0x0030].variant;
  if (ch >= 0x0041 and ch < 0x005A) return table[ch - 0x0037].variant;
  if (ch >= 0x0061 and ch < 0x007A) return table[ch - 0x003D].variant;
  if (ch >= 0x0391 and ch < 0x03A1) return table[ch - 0x0353].variant;
  if (ch >= 0x03A3 and ch < 0x03A9) return table[ch - 0x0354].variant;
  if (ch >= 0x03B1 and ch < 0x03C9) return table[ch - 0x035B].variant;
  if (ch == 0x03D1) return 0x1D6DD;
  if (ch >= 0x03D5 and ch < 0x03D6) return table[ch - 0x0365].variant;
  if (ch >= 0x03F0 and ch < 0x03F1) return table[ch - 0x037E].variant;
  if (ch == 0x03F4) return 0x1D6B9;
  if (ch == 0x2202) return 0x1D6DB;
  if (ch == 0x2207) return 0x1D6C1;
  if (ch == 0x220A) return 0x1D6DC;
  return ch;
}
