/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_GQL_OBJECT_H)
#define __INC_GQL_OBJECT_H

#include <string>

#include <sigc++/object.h>

#include <gql++/exception.h>

namespace GQL
{

class SQLType
{
  public:
    enum TypeCode
    {
      VOID,
      BOOLEAN, BOOL = BOOLEAN,
      DATE,
      DECIMAL, NUMERIC = DECIMAL,
      FLOAT,
      SMALLINT,
      INTEGER, INT = INTEGER,
      INTERVAL,
      TIME,
      TIME_WITH_TZ,
      TIMESTAMP_WITH_TZ,
      CHARACTER, CHAR = CHARACTER,
      CHARACTER_VARYING, VARCHAR = CHARACTER_VARYING,
      BLOB,
      
      MAX_TYPE
    };

    SQLType();
    SQLType(TypeCode type, ...);
    SQLType(const std::string& str);

    std::string as_string() const;
    
    TypeCode typecode() const { return(type_); }
    int length() const { return(length_); }
    int decimals() const { return(decimals_); }
  private:
    TypeCode type_;
    int length_;
    int decimals_;
};

class Blob : public SigC::Object
{
  public:
    virtual ~Blob();

    enum openmode
    { 
      in = 0x01, 
      out = 0x02
    };
    enum seek_dir { beg, cur, end };
    
    virtual void open(openmode om = in) = 0;
    virtual bool is_open() = 0;
    virtual void close() = 0;
    
    virtual int write(const void *data, int len) = 0;
    virtual int read(void *data, int len) = 0;
    virtual int seek(int offset, seek_dir whence) = 0;
    virtual int tell() const = 0;
  protected:
    Blob() { }
};

class SQLObject : public SigC::Object
{
  public:
    SQLObject() { 
      is_null_ = true; 
    }
    virtual ~SQLObject() { }
    
    void set_null() { is_null_ = true; }
    bool is_null() const { return is_null_; }
    
    virtual std::string output() const = 0;
    virtual bool input(const std::string& s) = 0;

    virtual std::string to_string() const = 0;
    virtual long to_int() const = 0;
    virtual double to_real() const = 0;
    virtual bool to_boolean() const = 0;
    virtual Blob *to_blob() const = 0;
    virtual SQLType to_type() const = 0;
    
    virtual void from_string(const std::string& s) = 0;
    virtual void from_int(long l) = 0;
    virtual void from_real(double d) = 0;
    virtual void from_boolean(bool b) = 0;
    virtual void from_type(const SQLType& type) = 0;
    /// if blob is 0, create a new BLOB instance
    virtual void from_blob(const Blob *blob) = 0;
  protected:    
    void set_null(bool null) { is_null_ = null; }
  private:
    bool is_null_;
};

class BasicSQLObject : public SQLObject
{
  public:
    BasicSQLObject();
    virtual ~BasicSQLObject();
    
    virtual std::string output() const;
    virtual bool input(const std::string& s);

    virtual std::string to_string() const;
    virtual long to_int() const;
    virtual double to_real() const;
    virtual bool to_boolean() const;
    virtual Blob *to_blob() const;
    virtual SQLType to_type() const;
    
    virtual void from_string(const std::string& s);
    virtual void from_int(long l);
    virtual void from_real(double d);
    virtual void from_boolean(bool b);
    virtual void from_type(const SQLType& type);
    virtual void from_blob(const Blob *blob = 0);
  protected:
    enum Type { VOID, STRING, INT, FLOAT, TYPE };

    Type type() const { return type_; }
  private:
    Type type_;
    std::string value_;
};

}

    
#endif
