/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_PG_CONNECTION_H)
#define __INC_PG_CONNECTION_H


#include "driver.h"

#include <libpq-fe.h>

#include "gql++/connection.h"

namespace GQL
{

class ResultSet;

namespace PG
{

class PGDatabaseMetaData;

class PGConnection : public Connection
{
  public:
    PGConnection(PGDriver *driver, 
                 const std::map<std::string, std::string>& props);
    virtual ~PGConnection();

    // Methods inherited from Connection
    virtual Statement *create_statement();
    virtual PreparedStatement *prepare_statement(const std::string& sql);
    virtual CallableStatement *prepare_call(const std::string& sql);

    virtual void commit();
    virtual bool get_auto_commit() const { return(auto_commit_); }
    virtual void set_auto_commit(bool auto_commit = true);
    virtual void rollback();
    virtual std::string get_catalog() const;
    
    virtual std::string native_sql(const std::string& sql) const;
    
    virtual DatabaseMetaData *get_meta_data();

    virtual void set_read_only(bool read_only = true) {
      read_only_ = read_only;
    }
    virtual bool is_read_only() const {
      return(read_only_);
    }
    
    virtual SQLObject *create_object();
    
    virtual SQLObject *create_blob();
    virtual void destroy_blob(SQLObject *blob);

    // Additional methods
    PGresult *exec_sql(const std::string& sql);
  private:
    PGDriver *driver_;
    PGconn *conn_;
    PGDatabaseMetaData *metadata_;
    bool read_only_;
    bool auto_commit_;
    map<string, string> info_;
};


}
}

#endif
