/*
 * GPG Keys 
 * cdlgabout.cpp
 * (c) 2001 Peter Mathiasson <peter@mathiasson.nu>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation
 */

#include <qdialog.h>
#include <qlistview.h>
#include <qtextview.h>
#include <qfile.h>
#include "cdlgabout.h"
#include "functions.h"
#include "config.h"

/* --------------------------------------------------------------------------------- */

#ifndef VERSION
    #define VERSION "UNKNOWN"
#endif

/* --------------------------------------------------------------------------------- */

CDlgAbout::CDlgAbout( QWidget *parent ) : CDlgAboutUI( parent, 0, TRUE )
{

    /* Set Fonts */
    setFont( readConfigFont( "stdfont", STD_FONT ) );
    QFont fixedFont = readConfigFont( "fixedfont", FIX_FONT );
    tvCopyright->setFont( fixedFont );
    lvAuthors->setFont( fixedFont );
    tvLicense->setFont( fixedFont );

    /* Set Copyright Information */
    tvCopyright->setWordWrap( QTextView::NoWrap );
    tvCopyright->setText( "GPG Keys v" VERSION "\n"
                          "(c) 2001 Peter Mathiasson <peter@mathiasson.nu>\n\n"
                          "This program is free software; you can redistribute it\n"
                          "and/or modify it under the terms of the GNU General Public\n"
                          "License version 2, as published by the Free Software\n"
                          "Foundation" );

    /* Set Authors Information */
    lvAuthors->setSorting( -1 );
    QListViewItem *tmpItem = NULL;
    QString line;
    QFile authFile( AUTHORSFILE );
    if ( authFile.open( IO_ReadOnly ) ) {
        QTextStream tsAuth( &authFile );
        while( line = tsAuth.readLine() ) {
            QStringList author = QStringList::split( '\t', line );
            tmpItem = new QListViewItem( lvAuthors, tmpItem );
            for ( unsigned int i = 0; i < author.size(); i++ ) {
                tmpItem->setText( i, author[i] + " " );
            }
        }
    } else {
        tmpItem = new QListViewItem( lvAuthors );
        tmpItem->setText( 0, tr( "Authors file not found!" ) );
    }

    
    /* Set License */
    tvLicense->setWordWrap( QTextView::NoWrap );
    QFile licFile( LICENSEFILE );
    if ( licFile.open( IO_ReadOnly ) ) {
        QTextStream tsLic( &licFile );
        tvLicense->setText( tsLic.read() );
    } else {
        tvLicense->setText( tr( "License file not found!" ) );
    }
                          
}

/* --------------------------------------------------------------------------------- */

