/* 
   GSNibTemplates.h

   Copyright (C) 1997, 1999 Free Software Foundation, Inc.

   Author:  Gregory John Casamento <greg_casamento@yahoo.com>
   Date: 2002
   
   This file is part of the GNUstep GUI Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/ 

#ifndef _GNUstep_H_GSNibTemplates
#define _GNUstep_H_GSNibTemplates

#include <Foundation/NSObject.h>
#include <AppKit/NSWindow.h>
#include <AppKit/NSMenu.h>
#include <AppKit/NSView.h>
#include <AppKit/NSText.h>
#include <AppKit/NSTextView.h>
#include <AppKit/NSControl.h>

// versions of the nib container and the templates.
#define GNUSTEP_NIB_VERSION 1
#define GSSWAPPER_VERSION   0
#define GSWINDOWT_VERSION   0
#define GSVIEWT_VERSION     0
#define GSCONTROLT_VERSION  0
#define GSTEXTT_VERSION     0
#define GSTEXTVIEWT_VERSION 0
#define GSMENUT_VERSION     0
#define GSOBJECTT_VERSION   0

@class	NSString;
@class	NSDictionary;
@class	NSMutableDictionary;
@class  NSMutableSet;

/*
 * This is the class that holds objects within a nib.
 */
@interface GSNibContainer : NSObject <NSCoding>
{
  NSMutableDictionary	*nameTable;
  NSMutableArray	*connections;
  NSMutableSet          *topLevelObjects;
  BOOL			isAwake;
}
- (void) awakeWithContext: (NSDictionary *)context;
- (NSMutableDictionary*) nameTable;
- (NSMutableArray*) connections;
- (NSMutableSet*) topLevelObjects;
@end

/*
 * Template classes
 */
@protocol GSTemplate
- (id) initWithObject: (id)object className: (NSString *)className superClassName: (NSString *)superClassName;
- (void) setClassName: (NSString *)className;
- (NSString *)className;
@end

@interface GSClassSwapper : NSObject <GSTemplate, NSCoding>
{
  id                   _object;
  NSString            *_className;
  Class                _superClass;
}
- (BOOL) shouldSwapClass;
@end

@interface GSNibItem : NSObject <NSCoding> 
{
  NSString		*theClass;
  NSRect		theFrame;
  unsigned int          autoresizingMask;
}
@end

@interface GSCustomView : GSNibItem <NSCoding>  
{
}
@end

@interface GSWindowTemplate : GSClassSwapper
{
  BOOL                 _deferFlag;
}
- (void) setDeferFlag: (BOOL)flag;
- (BOOL) deferFlag;
@end

@interface GSViewTemplate : GSClassSwapper
@end

@interface GSTextTemplate : GSClassSwapper
@end

@interface GSTextViewTemplate : GSClassSwapper 
@end

@interface GSMenuTemplate : GSClassSwapper
@end

@interface GSControlTemplate : GSClassSwapper
@end

@interface GSObjectTemplate : GSClassSwapper
@end

@interface GSTemplateFactory : NSObject
+ (id) templateForObject: (id) object 
	   withClassName: (NSString *)className
      withSuperClassName: (NSString *)superClassName;
@end
#endif /* _GNUstep_H_GSNibTemplates */
