#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# GFObjects.py
#
# DESCRIPTION:
"""
Implements logical scrollbar support
"""
# NOTES:
#

from GFObj import GFObj

#
# GFScrollBar
#
class GFScrollBar(GFObj):
  def __init__(self, parent=None):
    GFObj.__init__(self, parent)
    self._type = "GFScrollBar"
    self.label = ""
    self.rows = 1

    # Runtime Variables
    self._inits = [self.initialize]

  def initialize(self):
    self._form = self.findParentOfType('GFForm')

    # ...Block
    try:
      self._block = block = self._form._logic._blockMap[self.block]
    except KeyError:
      raise "Entry references non-existent block '%s'" % self.block



