/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  rc.inl - Gtk::RC and Gtk::RcStyle inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*  Gtk::RC
 */

inline void
GFC::Gtk::RC::add_default_file(const char *filename)
{
	gtk_rc_add_default_file(filename);
}

inline void
GFC::Gtk::RC::parse(const char *filename)
{
	gtk_rc_parse(filename);
}

inline void
GFC::Gtk::RC::parse_string(const char *rc_string)
{
	gtk_rc_parse_string(rc_string);
}

inline bool
GFC::Gtk::RC::reparse_all()
{
	return gtk_rc_reparse_all();
}

/*  Gtk::RcStyle
 */

inline GtkRcStyle*
GFC::Gtk::RcStyle::gtk_rc_style() const
{
	return reinterpret_cast<GtkRcStyle*>(instance_);
}

inline GFC::Gtk::RcStyle::operator GtkRcStyle* () const
{
	return this ? gtk_rc_style() : 0;
}

