/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  hypertextsignals.cc - Atk::Hypertext virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "hypertext.hh"
#include "hypertextsignals.hh"
#include "private/hypertextiface.hh"
#include <gfc/glib/object.hh>
#include <gfc/glib/objectsignals.hh>

using namespace GFC;

/*  Atk::HypertextSignals
 */

Atk::HypertextSignals::HypertextSignals(Hypertext *hypertext)
{
	Atk::HypertextIface::init(ATK_HYPERTEXT_GET_IFACE(hypertext->atk_hypertext()));
}
	
Atk::HypertextSignals::~HypertextSignals()
{
}
	
void
Atk::HypertextSignals::on_link_selected(int link_index)
{
	AtkHypertextIface *g_iface = HypertextIface::get_parent_iface(instance_);
	if (g_iface->link_selected)
		g_iface->link_selected((AtkHypertext*)instance_, link_index);
}

/*  Atk::HypertextIface
 */

void
Atk::HypertextIface::init(AtkHypertextIface *g_iface)
{
	g_iface->link_selected = &link_selected_proxy;
}

AtkHypertextIface*
Atk::HypertextIface::get_parent_iface(void *instance)
{
	void *ptr = g_type_interface_peek_parent(ATK_HYPERTEXT_GET_IFACE(instance));
	return static_cast<AtkHypertextIface*>(ptr);
}

void
Atk::HypertextIface::link_selected_proxy(AtkHypertext *hypertext, gint link_index)
{
	void *ptr = g_object_get_qdata((GObject*)hypertext, G::ObjectSignals::quark());
	if (ptr)
	{
		G::Object *object = static_cast<G::Object*>(ptr);
		dynamic_cast<HypertextSignals*>(object)->on_link_selected(link_index);
	}
	else
	{
		AtkHypertextIface *g_iface = HypertextIface::get_parent_iface(hypertext);
		if (g_iface->link_selected)
			g_iface->link_selected(hypertext, link_index);
	}
}

