#
# Module for holding runtime settings.
#

import getopt
import sys

from main import _


translucent = False


#
# parsing command line arguments.
#

__OPTIONS = ("sm-client-id=", "sm-config-prefix=", "sm-disable",
             "translucent")


#
# Parses the given list of command line arguments. This is usually
# sys.argv[1:].
#

try:
    opts, rest = getopt.getopt(sys.argv[1:], "nop:v", __OPTIONS)
except getopt.GetoptError:
    __usage()
    sys.exit(2)

for o, a in opts:

    if (o == "--translucent"):
        translucent = True
    elif (o in ("--sm-client-id", "--sm-config-prefix",
                "--sm-disable")):
        pass
#end for
