/* 

                          Firewall Builder

                 Copyright (C) 2004 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: pfAdvancedDialog.cpp,v 1.13 2004/09/28 05:21:00 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "global.h"
#include "platforms.h"

#include "pfAdvancedDialog.h"

#include "fwbuilder/Firewall.h"
#include "fwbuilder/Management.h"

#include <qcheckbox.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qwidgetstack.h>
#include <qregexp.h>


using namespace std;
using namespace libfwbuilder;


pfAdvancedDialog::pfAdvancedDialog(QWidget *parent,FWObject *o)
    : pfAdvancedDialog_q(parent)
{
    obj=o;

    FWOptions *fwopt=(Firewall::cast(obj))->getOptionsObject();
    assert(fwopt!=NULL);

    Management *mgmt=(Firewall::cast(obj))->getManagementObject();
    assert(mgmt!=NULL);

    data.registerOption( pf_log_prefix          ,fwopt, "log_prefix"          );
    data.registerOption( pf_fallback_log        ,fwopt, "fallback_log"        );
    data.registerOption( pf_do_timeout_interval ,fwopt, "pf_do_timeout_interval" );
    data.registerOption( pf_timeout_interval    ,fwopt, "pf_timeout_interval" );
    data.registerOption( pf_do_timeout_frag     ,fwopt, "pf_do_timeout_frag"     );
    data.registerOption( pf_timeout_frag        ,fwopt, "pf_timeout_frag"     );
    data.registerOption( pf_do_limit_frags      ,fwopt, "pf_do_limit_frags"      );
    data.registerOption( pf_limit_frags         ,fwopt, "pf_limit_frags"      );
    data.registerOption( pf_do_limit_states     ,fwopt, "pf_do_limit_states"     );
    data.registerOption( pf_limit_states        ,fwopt, "pf_limit_states"     );
    data.registerOption( pf_optimization        ,fwopt, "pf_optimization"     );
    data.registerOption( pf_check_shadowing     ,fwopt, "check_shading"       );
    data.registerOption( pf_pass_all_out        ,fwopt, "pass_all_out"        );
    data.registerOption( pf_in_out_code         ,fwopt, "in_out_code"         );
    data.registerOption( pf_ignore_empty_groups ,fwopt, "ignore_empty_groups" );
//    data.registerOption( pf_use_tables ,         fwopt, "use_tables" );
    data.registerOption( pf_accept_new_tcp_with_no_syn ,fwopt, "accept_new_tcp_with_no_syn");
    data.registerOption( pf_modulate_state      ,fwopt, "modulate_state"      );
    data.registerOption( pf_scrub_random_id     ,fwopt, "pf_scrub_random_id"  );

    data.registerOption( pf_do_scrub            ,fwopt, "pf_do_scrub"         );

// radio buttons
    data.registerOption( pf_scrub_reassemble    ,fwopt, "pf_scrub_reassemble" );
    data.registerOption( pf_scrub_fragm_crop    ,fwopt, "pf_scrub_fragm_crop" );
    data.registerOption( pf_scrub_fragm_drop_ovl,fwopt, "pf_scrub_fragm_drop_ovl" );


    data.registerOption( pf_scrub_use_minttl    ,fwopt, "pf_scrub_use_minttl" );
    data.registerOption( pf_scrub_use_maxmss    ,fwopt, "pf_scrub_use_maxmss" );
    data.registerOption( pf_scrub_maxmss        ,fwopt, "pf_scrub_maxmss" );
    data.registerOption( pf_scrub_minttl        ,fwopt, "pf_scrub_minttl" );
    data.registerOption( pf_scrub_no_df         ,fwopt, "pf_scrub_no_df"  );
    data.registerOption( pf_fw_dir              ,fwopt, "firewall_dir"    );
    data.registerOption( pf_user                ,fwopt, "admUser"         );
    data.registerOption( altAddress             ,fwopt, "altAddress"      );
    data.registerOption( activationCmd          ,fwopt, "activationCmd"   );

    data.registerOption( pf_manage_virtual_addr ,fwopt, "manage_virtual_addr" );
    data.registerOption( pf_configure_interfaces,fwopt, "configure_interfaces");
    data.registerOption( pf_debug               ,fwopt, "debug"               );

    data.registerOption( compiler               ,fwopt, "compiler" );
    data.registerOption( compilerArgs           ,fwopt, "cmdline"  );
    data.registerOption( outputFileName       , fwopt,  "output_file"  );

    data.registerOption( mgmt_ssh               ,fwopt, "mgmt_ssh"  );
    data.registerOption( mgmt_addr              ,fwopt, "mgmt_addr" );

    data.registerOption( pf_set_tcp_first       ,fwopt, "pf_set_tcp_first" );
    data.registerOption( pf_tcp_first           ,fwopt, "pf_tcp_first" );
    data.registerOption( pf_set_tcp_opening     ,fwopt, "pf_set_tcp_opening" );
    data.registerOption( pf_tcp_opening         ,fwopt, "pf_tcp_opening" );
    data.registerOption( pf_set_tcp_established ,fwopt, "pf_set_tcp_established" );
    data.registerOption( pf_tcp_established     ,fwopt, "pf_tcp_established" );
    data.registerOption( pf_set_tcp_closing     ,fwopt, "pf_set_tcp_closing" );
    data.registerOption( pf_tcp_closing         ,fwopt, "pf_tcp_closing" );
    data.registerOption( pf_set_tcp_finwait     ,fwopt, "pf_set_tcp_finwait" );
    data.registerOption( pf_tcp_finwait         ,fwopt, "pf_tcp_finwait" );
    data.registerOption( pf_set_tcp_closed      ,fwopt, "pf_set_tcp_closed" );
    data.registerOption( pf_tcp_closed          ,fwopt, "pf_tcp_closed" );
    data.registerOption( pf_set_udp_first       ,fwopt, "pf_set_udp_first" );
    data.registerOption( pf_udp_first           ,fwopt, "pf_udp_first" );
    data.registerOption( pf_set_udp_single      ,fwopt, "pf_set_udp_single" );
    data.registerOption( pf_udp_single          ,fwopt, "pf_udp_single" );
    data.registerOption( pf_set_udp_multiple    ,fwopt, "pf_set_udp_multiple" );
    data.registerOption( pf_udp_multiple        ,fwopt, "pf_udp_multiple" );
    data.registerOption( pf_set_icmp_first      ,fwopt, "pf_set_icmp_first" );
    data.registerOption( pf_icmp_first          ,fwopt, "pf_icmp_first" );
    data.registerOption( pf_set_icmp_error      ,fwopt, "pf_set_icmp_error" );
    data.registerOption( pf_icmp_error          ,fwopt, "pf_icmp_error" );
    data.registerOption( pf_set_other_first     ,fwopt, "pf_set_other_first" );
    data.registerOption( pf_other_first         ,fwopt, "pf_other_first" );
    data.registerOption( pf_set_other_single    ,fwopt, "pf_set_other_single" );
    data.registerOption( pf_other_single        ,fwopt, "pf_other_single" );
    data.registerOption( pf_set_other_multiple  ,fwopt, "pf_set_other_multiple" );
    data.registerOption( pf_other_multiple      ,fwopt, "pf_other_multiple" );

    data.registerOption( pf_set_adaptive        ,fwopt, "pf_set_adaptive" );
    data.registerOption( pf_adaptive_start      ,fwopt, "pf_adaptive_start" );
    data.registerOption( pf_adaptive_end        ,fwopt, "pf_adaptive_end" );

    PolicyInstallScript *pis   = mgmt->getPolicyInstallScript();

    installScript->setText(     pis->getCommand().c_str() );
    installScriptArgs->setText( pis->getArguments().c_str() );

    data.loadAll();

    doScrubToggled();
    ltToggled();
}

void pfAdvancedDialog::doScrubToggled()
{
    bool f=pf_do_scrub->isChecked();

    pf_scrub_reassemble->setEnabled(f);
    pf_scrub_fragm_crop->setEnabled(f);
    pf_scrub_fragm_drop_ovl->setEnabled(f);

    if (!pf_scrub_reassemble->isChecked() &&
        !pf_scrub_fragm_crop->isChecked() &&
        !pf_scrub_fragm_drop_ovl->isChecked()) pf_scrub_reassemble->setChecked(true);
}

void pfAdvancedDialog::ltToggled()
{
    pf_limit_frags->setEnabled( pf_do_limit_frags->isChecked() );
    pf_limit_states->setEnabled( pf_do_limit_states->isChecked() );
    pf_timeout_interval->setEnabled( pf_do_timeout_interval->isChecked() );
    pf_timeout_frag->setEnabled( pf_do_timeout_frag->isChecked() );

    pf_tcp_first->setEnabled( pf_set_tcp_first->isChecked() );       
    pf_tcp_opening->setEnabled( pf_set_tcp_opening->isChecked() );     
    pf_tcp_established->setEnabled( pf_set_tcp_established->isChecked() ); 
    pf_tcp_closing->setEnabled( pf_set_tcp_closing->isChecked() );     
    pf_tcp_finwait->setEnabled( pf_set_tcp_finwait->isChecked() );     
    pf_tcp_closed->setEnabled( pf_set_tcp_closed->isChecked() );      
    pf_udp_first->setEnabled( pf_set_udp_first->isChecked() );       
    pf_udp_single->setEnabled( pf_set_udp_single->isChecked() );      
    pf_udp_multiple->setEnabled( pf_set_udp_multiple->isChecked() );    
    pf_icmp_first->setEnabled( pf_set_icmp_first->isChecked() );      
    pf_icmp_error->setEnabled( pf_set_icmp_error->isChecked() );      
    pf_other_first->setEnabled( pf_set_other_first->isChecked() );     
    pf_other_single->setEnabled( pf_set_other_single->isChecked() );    
    pf_other_multiple->setEnabled( pf_set_other_multiple->isChecked() );  

    pf_adaptive_start->setEnabled( pf_set_adaptive->isChecked() );       
    pf_adaptive_end->setEnabled( pf_set_adaptive->isChecked() );       
}

/*
 * store all data in the object
 */
void pfAdvancedDialog::accept()
{
    FWOptions *fwopt=(Firewall::cast(obj))->getOptionsObject();
    assert(fwopt!=NULL);

    Management *mgmt=(Firewall::cast(obj))->getManagementObject();
    assert(mgmt!=NULL);

    data.saveAll();

    PolicyInstallScript *pis   = mgmt->getPolicyInstallScript();
    pis->setCommand( installScript->text().latin1() );
    pis->setArguments( installScriptArgs->text().latin1() );

    pfAdvancedDialog_q::accept();
}

void pfAdvancedDialog::reject()
{
    pfAdvancedDialog_q::reject();
}


