class FitsImgPlotSel {
    inherit itk::Toplevel
    
    private common range 
    private common typeSelection
    private common cbCurrgn

    private variable id
    private variable numRows
    private variable numCols
    private variable entryWidth 15
    
    private method doneCmd {}
    private method cancelCmd {}
    private method helpCmd {}
    private method parseRange {} 
    private method selType {}
    

    constructor {args} {
	global activeBgColor
	global checkBBgColor
	global globalBgColor

	set id [lindex $args 0]
	set numCols [lindex $args 1]
	set numRows [lindex $args 2]

	set [scope typeSelection] row
	# labels
	itk_component add title {
	    message $itk_interior.mssg -text "Image Size: $numCols X $numRows" \
		-width 300 -relief ridge -borderwidth 4
	}	
	
	itk_component add selRow {
	    radiobutton $itk_interior.selrow -text "Plot Rows" \
		-variable [scope typeSelection] -value row \
		-selectcolor $fvPref::checkBBgColor  \
		-activeforeground black -activebackground $fvPref::globalBgColor \
		-command [code $this selType]
	    
	} 
	itk_component add selCol {
	    radiobutton $itk_interior.selcol -text "Plot Columns" \
		-variable [scope typeSelection] -value col \
		-selectcolor $fvPref::checkBBgColor  \
		-activeforeground black -activebackground $fvPref::globalBgColor \
		-command [code $this selType]
	} 
	
	itk_component add  rangeLabel {
	    label $itk_interior.rangel -text "Range of rows to plot" \
	    -width 25
	}

	itk_component add  rangeEntry {
	    entry $itk_interior.rangee  -textvariable [scope range($id)] \
		-width $entryWidth 
	}
	bind $itk_component(rangeEntry) <Return> [code $this doneCmd]

	itk_component add sep {
	    frame $itk_interior.sep -height 4 -borderwidth 2 -relief raised
	}	
	itk_component add sep1 {
	    frame $itk_interior.sep1 -height 4 -borderwidth 2 -relief raised
	}	

	set cbCurrgn 0
	itk_component add cbCurrgn {
	   checkbutton $itk_interior.cbCurrgn -variable [scope cbCurrgn] \
		 -text "Add curve to current graph" \
		 -selectcolor $fvPref::checkBBgColor  \
		 -activeforeground black \
		 -activebackground $fvPref::globalBgColor
	} {
	   usual
	   ignore -selectcolor -activeforeground -activebackground
	}

	itk_component add  Button {
	    iwidgets::buttonbox $itk_interior.bb 
	} 
	$itk_component(Button) add make -text "Plot" \
	    -command [code $this doneCmd]
	$itk_component(Button) add cancel -text Cancel \
	    -command [code $this cancelCmd]
	$itk_component(Button) add help  -text Help \
	    -command [code $this helpCmd]

	grid configure $itk_component(title) -column 0 -row 0 \
	    -rowspan 2 -sticky "snew"
	grid configure $itk_component(selRow) -column 1 -row 0 \
	     -sticky "sw"
	grid configure $itk_component(selCol) -column 1 -row 1 \
	     -sticky "sw"
	grid configure $itk_component(sep1) -column 0 -row 2 \
	     -columnspan 4 -sticky "snew"
	grid configure $itk_component(rangeLabel) -column 0 -row 3 \
	     -sticky "snew" -pady 5
	grid configure $itk_component(rangeEntry) -column 1 -row 3 \
	     -sticky "snew" -pady 5
	grid configure $itk_component(sep) -column 0 -row 4 \
	     -columnspan 2 -sticky "snew"
	grid configure $itk_component(cbCurrgn) -column 0 -row 5 \
	     -columnspan 2 -sticky "snew"
	grid configure $itk_component(Button) -column 0 -row 6 \
	     -columnspan 2 -sticky "snew"
    }

    destructor {
    }
}

body FitsImgPlotSel::doneCmd {} {
    global GL


    if { $range($id) == " " | $range($id) == ""} {
	error "Please enter the range to plot"
	return
    }
    if { $typeSelection == "row" } {
	set rangeList [parseRange]
        set start [lindex $rangeList 0]
        set end   [lindex $rangeList 1]
        if { $start<1 || $start>$numRows || $end<1 || $end>$numRows } {
           error "Row range is out of range"
           return
        }
	lappend paramList "row"
    } else {
	set rangeList [parseRange]
        set start [lindex $rangeList 0]
        set end   [lindex $rangeList 1]
        if { $start<1 || $start>$numCols || $end<1 || $end>$numCols } {
           error "Column range is out of range"
           return
        }
	lappend paramList "column"
    }
    lappend paramList $start
    lappend paramList $end
    lappend paramList $cbCurrgn
    
    set GL($id,plotImg) [join $paramList]

    delete object $this
}

body FitsImgPlotSel::cancelCmd {} {
    global GL

    set GL($id,plotImg) ""
    delete object $this
}

body FitsImgPlotSel::helpCmd {} {
    hhelp imagePlot
}

body FitsImgPlotSel::parseRange {} {

    regsub -all " " $range($id) "" tmprange

    if { $tmprange == "" } {
	if { $typeSelection == "row" } {
	    return [list 1 $numCols]
	} else {
	    return [list 1 $numRows]
	}
    }
    
    set start 1
    set end 1
    set rangeCount [scan $tmprange "%d-%d" start end]
    if { $rangeCount == 1 } {
	set end $start
    } elseif { $rangeCount == 2} {
	;
    } else {
	error "Parse error: range"
	return
    }
    return [list $start $end]
}

body FitsImgPlotSel::selType {} {
    if { $typeSelection == "row" } {
	$itk_component(rangeLabel) configure -text "Range of rows to plot"
    } else {
	$itk_component(rangeLabel) configure -text "Range of columns to plot"
    }
}
