/* FIGARO'S PASSWORD MANAGER (FPM)
 * Copyright (C) 2000 John Conneely
 *
 * FPM is open source / free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * FPM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * fpm_pref.c
 */

#include <gnome.h>

#include "fpm.h"
#include "fpm_gpw.h"
#include "passfile.h"
#include "fpm_crypt.h"
#include "callbacks.h"
#include "interface.h"
#include "support.h"


fpm_launcher* current_launcher;

void fpm_prefs_select_launcher(fpm_launcher* launcher);
void fpm_prefs_load_for_edit(void);
void fpm_prefs_del_launcher(void);
void fpm_prefs_new_launcher(void);
void fpm_prefs_get_launcher(void);

void fpm_prefs_get_launcher()
{
  GtkOptionMenu* option_menu;
  GtkWidget* menu;
  GtkWidget* menu_item;
  GList* list;
  fpm_launcher* launcher;
  GtkWidget* widget;

  option_menu = GTK_OPTION_MENU(lookup_widget(glb_win_misc, "optionmenu_launcher"));

  gtk_option_menu_remove_menu(option_menu);
  menu=gtk_menu_new();
  gtk_option_menu_set_menu(option_menu, menu);

  menu_item=gtk_menu_item_new_with_label("<Choose a launcher>");
  gtk_menu_append(GTK_MENU(menu), menu_item);
  gtk_widget_show(menu_item);
    gtk_signal_connect_object(GTK_OBJECT(menu_item), "activate",
	GTK_SIGNAL_FUNC(fpm_prefs_select_launcher), NULL);
  

  list=g_list_first(glb_launcher_list);
  while(list!=NULL)
  {
    launcher=list->data;

    menu_item = gtk_menu_item_new_with_label(launcher->title);
    gtk_menu_append(GTK_MENU(menu), menu_item);
    gtk_widget_show(menu_item);
    gtk_signal_connect_object(GTK_OBJECT(menu_item), "activate",
	GTK_SIGNAL_FUNC(fpm_prefs_select_launcher), (gpointer) launcher);
    
    list=g_list_next(list);
  }
  
  widget=lookup_widget(glb_win_misc, "frame_edit_launcher");
  gtk_widget_hide(widget);
  widget=lookup_widget(glb_win_misc, "label_instructions");
  gtk_widget_hide(widget);
  widget=lookup_widget(glb_win_misc, "hbox_get_launcher");
  gtk_widget_show(widget);

  gtk_option_menu_set_history(option_menu, 0);
  current_launcher=NULL;
}

void fpm_prefs_init()
{
  GtkWidget* widget;
 
  gtk_widget_set_sensitive(glb_win_app, FALSE);
  glb_win_misc=create_dialog_prefs();
 

  widget=lookup_widget(glb_win_misc, "button_edit_launcher");
  gtk_signal_connect_object(GTK_OBJECT(widget), "clicked",
	GTK_SIGNAL_FUNC(fpm_prefs_load_for_edit), NULL);

  widget=lookup_widget(glb_win_misc, "button_new_launcher");
  gtk_signal_connect_object(GTK_OBJECT(widget), "clicked",
	GTK_SIGNAL_FUNC(fpm_prefs_new_launcher), NULL);

  widget=lookup_widget(glb_win_misc, "button_delete_launcher");
  gtk_signal_connect_object(GTK_OBJECT(widget), "clicked",
	GTK_SIGNAL_FUNC(fpm_prefs_del_launcher), NULL);

  fpm_prefs_get_launcher();
  gtk_widget_show(glb_win_misc);

}

void fpm_prefs_select_launcher(fpm_launcher* launcher)
{
  current_launcher=launcher;
}

void fpm_prefs_load_for_edit()
{
  GtkWidget* widget;

  if (current_launcher==NULL)
  {
    gnome_warning_dialog("Please select which launcher you wish to edit.");
  }
  else
  {
    widget=lookup_widget(glb_win_misc, "entry_launcher");
    gtk_entry_set_text(GTK_ENTRY(widget), current_launcher->title);
    widget=lookup_widget(glb_win_misc, "entry_launcher_cmd");
    gtk_entry_set_text(GTK_ENTRY(widget), current_launcher->cmdline);

    if (current_launcher->copy_user==2) widget=lookup_widget(glb_win_misc, "radiobutton_user_clip");
    else
    {
      if (current_launcher->copy_user==1) widget=lookup_widget(glb_win_misc, "radiobutton_user_pri");
      else widget=lookup_widget(glb_win_misc, "radiobutton_user_none");
    }

    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    
    
    if (current_launcher->copy_password==2) widget=lookup_widget(glb_win_misc, "radiobutton_pass_clip");
    else
    {
      if (current_launcher->copy_password==1) widget=lookup_widget(glb_win_misc, "radiobutton_pass_pri");
      else widget=lookup_widget(glb_win_misc, "radiobutton_pass_none");
    }

    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);



    /* Make them visible */
    widget=lookup_widget(glb_win_misc, "frame_edit_launcher");
    gtk_widget_show(widget);
    widget=lookup_widget(glb_win_misc, "label_instructions");
    gtk_widget_show(widget);
    widget=lookup_widget(glb_win_misc, "hbox_get_launcher");
    gtk_widget_hide(widget);
  }
}

void fpm_prefs_save_launcher()
{
  GtkWidget* widget;

  widget=lookup_widget(glb_win_misc, "frame_edit_launcher");
  if (GTK_WIDGET_VISIBLE(widget))
  {
    widget=lookup_widget(glb_win_misc, "entry_launcher");
    g_free(current_launcher->title);
    current_launcher->title=g_strdup(gtk_entry_get_text(GTK_ENTRY(widget)));
    widget=lookup_widget(glb_win_misc, "entry_launcher_cmd");
    g_free(current_launcher->cmdline);
    current_launcher->cmdline=g_strdup(gtk_entry_get_text(GTK_ENTRY(widget)));

    current_launcher->copy_user=0;
    if (GTK_TOGGLE_BUTTON(lookup_widget(glb_win_misc, "radiobutton_user_clip"))->active)
	current_launcher->copy_user=2;
    if (GTK_TOGGLE_BUTTON(lookup_widget(glb_win_misc, "radiobutton_user_pri"))->active)
	current_launcher->copy_user=1;

    current_launcher->copy_password=0;
    if (GTK_TOGGLE_BUTTON(lookup_widget(glb_win_misc, "radiobutton_pass_clip"))->active)
	current_launcher->copy_password=2;
    if (GTK_TOGGLE_BUTTON(lookup_widget(glb_win_misc, "radiobutton_pass_pri"))->active)
	current_launcher->copy_password=1;

    fpm_create_launcher_string_list();
    fpm_prefs_get_launcher();
    glb_dirty=TRUE;
  }
  else
  {
    gtk_widget_destroy(glb_win_misc);
  }
}

void fpm_prefs_new_launcher()
{
  current_launcher=g_malloc0(sizeof(fpm_launcher));
  glb_launcher_list=g_list_append(glb_launcher_list, current_launcher);
  fpm_prefs_load_for_edit();
}

void fpm_prefs_del_launcher()
{
  if (current_launcher==NULL)
  {
    gnome_warning_dialog("Please select which launcher you wish to delete.");
  }
  else
  {
    glb_launcher_list=g_list_remove(glb_launcher_list, current_launcher);
    fpm_create_launcher_string_list();
    fpm_prefs_get_launcher();
  }
}
