#ifndef FLOPPYDEFINES
#define FLOPPYDEFINES

#define VERSION "v1.2a"

/**/
#define DEFAULT_DEVICE "/dev/fd0"

/* These should not exist :-) The file is deleted when not needed. */
/* Indeed, they need not now :) matthew@debian.org */
/* #define TEMP_FILE "/tmp/____floppybackup_TempMuzh" */
/* #define TEMP_DATA "/tmp/____floppybackup_TempData" */

/* See archive_header */
#define MAGICBYTES "FdBackup"				/* Saved as first bytes to disk. */

/* Buffsize must be > sizeof(struct archive_header) */
#define BUFFSIZE  8192          /* Is 2^13 .... any meaning ?      */
/* Max number of retries if a read/write error occurs.*/
#define MAX_RETRIES 3

#define MORE      1
#define NOMORE    0

/* The numbers are saved in ascii format for easy portability.
 * Strings are 0-terminated */
struct archive_header {
	unsigned char magicbytes[9];			/* "FdBackup" */
	unsigned char version[8];				/* Version string of proggie that created the floppy */
	unsigned char name[128];				/* Name. No need for longer names */
	unsigned char fd_number[9];			/* 99999999 floppies are enough */
	unsigned char fd_length[32];			/* Enough :-) */
	unsigned char fd_more;					/* 0 for nope, nonzero for yes. */
	unsigned char fd_total[9];				/* -1 for "not defined", -2 for "check disk 1" */
	unsigned char fd_total_length[32];	/* Set after creating the archive. */
	unsigned char creation_time[13];		/* ddmmyyyyhhmm\0 */
	unsigned char reserved[271];			/* Add extensions here. */
};
/* size: 512 bytes */

#endif
