/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Jul  5 21:43:16 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homee/stevenj/cvs/fftw3.0.1/genfft/gen_twiddle_c -simd -compact -variables 4 -n 6 -name t1fv_6 -include t1f.h */

/*
 * This function contains 23 FP additions, 14 FP multiplications,
 * (or, 21 additions, 12 multiplications, 2 fused multiply/add),
 * 19 stack variables, and 12 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_twiddle_c.ml,v 1.7 2003/04/16 19:51:27 athena Exp $
 */

#include "t1f.h"

static const R *t1fv_6(R *ri, R *ii, const R *W, stride ios, int m, int dist)
{
     DVK(KP500000000, +0.500000000000000000000000000000000000000000000);
     DVK(KP866025403, +0.866025403784438646763723170752936183471402627);
     int i;
     R *x;
     x = ri;
     BEGIN_SIMD();
     for (i = m; i > 0; i = i - VL, x = x + (VL * dist), W = W + (TWVL * 10)) {
	  V T4, Ti, Te, Tk, T9, Tj, T1, T3, T2;
	  T1 = LD(&(x[0]), dist, &(x[0]));
	  T2 = LD(&(x[WS(ios, 3)]), dist, &(x[WS(ios, 1)]));
	  T3 = BYTWJ(&(W[TWVL * 4]), T2);
	  T4 = VSUB(T1, T3);
	  Ti = VADD(T1, T3);
	  {
	       V Tb, Td, Ta, Tc;
	       Ta = LD(&(x[WS(ios, 4)]), dist, &(x[0]));
	       Tb = BYTWJ(&(W[TWVL * 6]), Ta);
	       Tc = LD(&(x[WS(ios, 1)]), dist, &(x[WS(ios, 1)]));
	       Td = BYTWJ(&(W[0]), Tc);
	       Te = VSUB(Tb, Td);
	       Tk = VADD(Tb, Td);
	  }
	  {
	       V T6, T8, T5, T7;
	       T5 = LD(&(x[WS(ios, 2)]), dist, &(x[0]));
	       T6 = BYTWJ(&(W[TWVL * 2]), T5);
	       T7 = LD(&(x[WS(ios, 5)]), dist, &(x[WS(ios, 1)]));
	       T8 = BYTWJ(&(W[TWVL * 8]), T7);
	       T9 = VSUB(T6, T8);
	       Tj = VADD(T6, T8);
	  }
	  {
	       V Th, Tf, Tg, Tn, Tl, Tm;
	       Th = VBYI(VMUL(LDK(KP866025403), VSUB(Te, T9)));
	       Tf = VADD(T9, Te);
	       Tg = VFNMS(LDK(KP500000000), Tf, T4);
	       ST(&(x[WS(ios, 3)]), VADD(T4, Tf), dist, &(x[WS(ios, 1)]));
	       ST(&(x[WS(ios, 1)]), VADD(Tg, Th), dist, &(x[WS(ios, 1)]));
	       ST(&(x[WS(ios, 5)]), VSUB(Tg, Th), dist, &(x[WS(ios, 1)]));
	       Tn = VBYI(VMUL(LDK(KP866025403), VSUB(Tk, Tj)));
	       Tl = VADD(Tj, Tk);
	       Tm = VFNMS(LDK(KP500000000), Tl, Ti);
	       ST(&(x[0]), VADD(Ti, Tl), dist, &(x[0]));
	       ST(&(x[WS(ios, 4)]), VADD(Tm, Tn), dist, &(x[0]));
	       ST(&(x[WS(ios, 2)]), VSUB(Tm, Tn), dist, &(x[0]));
	  }
     }
     END_SIMD();
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     VTW(2),
     VTW(3),
     VTW(4),
     VTW(5),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 6, "t1fv_6", twinstr, {21, 12, 2, 0}, &GENUS, 0, 0, 0 };

void X(codelet_t1fv_6) (planner *p) {
     X(kdft_dit_register) (p, t1fv_6, &desc);
}
