/*
 * fbgetty : a getty for framebuffer 
 * Copyright (C) 2001 Yann Droneaud <ydroneaud@meuh.eu.org>. 
 *
 * fbgetty is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * fbgetty is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 */

#ifndef _FBGETTY_KBD_H_
#define _FBGETTY_KBD_H_

#ifdef __linux__
#include <linux/kd.h>
#define FBGETTY_LEDS_CAPS 0x04 /* K_CAPSLOCK or LED_CAP */
#define FBGETTY_LEDS_NUM 0x02 /* K_NUMLOCK  or LED_NUM */
#endif /* __linux__ */

#ifndef FBGETTY_LEDS_CAPS
#define FBGETTY_LEDS_CAPS 0x01
#endif

#ifndef FBGETTY_LEDS_NUM
#define FBGETTY_LEDS_NUM 0x02
#endif

/* parse a list of led separated by comma, ex "num,caps,a,n,c,z,..." */
int leds_parse(const char *opt, unsigned int *mask);

#define FBGETTY_KBD_SET   0x01  /* set flags */
#define FBGETTY_KBD_UNSET 0x02  /* unset flags */

int kbd_opt(int MODE, unsigned int mask);

int init_kbd(void);

#endif /* _FBGETTY_KBD_H_ */
