/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libdrivelink.so
 *
 *   File: dl_missing_child.h
 */

#ifndef _DL_MISSING_CHILD_HEADER_
#define _DL_MISSING_CHILD_HEADER_ 1


int     dl_build_missing_child( storage_object_t  *drivelink, int  index  );
int     dl_replace_missing_child( storage_object_t *drivelink, 
                                  storage_object_t *missing_child,
                                  storage_object_t *new_child );
int     dl_validate_missing_child_replace_target( storage_object_t *missing_child,
                                                  storage_object_t *new_child );
boolean dl_can_replace_missing_child( storage_object_t *missing_child );


static inline void dl_free_missing_child_object(storage_object_t  *child)
{
        if (child!=NULL) {
                if (child->feature_header) free(child->feature_header);
                if (child->private_data ) free(child->private_data);
                child->private_data = NULL;
                child->feature_header = NULL;
                EngFncs->free_evms_object(child);
        }
}


static inline boolean dl_isa_missing_child(storage_object_t *child)
{
        if ( child != NULL && 
             child->private_data != NULL && 
             child->plugin == dl_plugin_record &&
             ((drivelink_private_data_t *)child->private_data)->signature==MISSING_CHILD_SIGNATURE) {

                return TRUE;

        }
        return FALSE;
}

#endif
