/***************************************************************************
                          game.cpp  -  description
                             -------------------
    begin                : Tue Aug 28 2001
    copyright            : (C) 2001 by Giuseppe D'Aqu
    email                : kumber@tiscalinet.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "dephine.h"
#include "sprite.h"
#include <vector>
#include <cmath>
#include <fstream>
#include "entity_type.h"
#include "entity.h"
#include "entity_player.h"
#include "game.h"
#include "menu.h"
#include "level.h"
#include "game_timer.h"
#include <stdlib.h>
#include <string.h>
#include "sfx.h"



bool Game::main_loop()
{
	unsigned int current_frame_time=0;
	
	bool exit_state=false;
	
	m_time.set_total_time(m_level->get_max_time());

	m_time.start();

	m_screen.set_window_center(m_level->get_player().get_position_x()*k_sprite_size,m_level->get_player().get_position_y()*k_sprite_size);


	while((m_level->get_player().is_alive())||
				(!CL_Keyboard::get_keycode(CL_KEY_SPACE))
				
				)
	{
		if((CL_Keyboard::get_keycode(CL_KEY_PAUSE))||(CL_Keyboard::get_keycode(CL_KEY_P)))
		{
			CL_System::sleep(200);
			CL_System::keep_alive();
			while(!((CL_Keyboard::get_keycode(CL_KEY_PAUSE))||(CL_Keyboard::get_keycode(CL_KEY_P))))
			{
				CL_System::keep_alive();
			}
		}
		
		if(m_level->get_player().is_alive())
		{
			m_time.update();
			if(m_time.get_time()<10)
			{
				
				m_sampleset.get_sample(SFX_GAME_TIMEALARM)->play();
			}
			if(m_time.is_zero())
			{
				m_level->explode(m_level->get_player().get_position_x(),m_level->get_player().get_position_y());
			}

		}
		



		current_frame_time=CL_System::get_time();
		
		//m_level->get_player().set_direction(STOP);
		
		get_keys();
		
		move_all();
		
		draw();
		
		CL_System::keep_alive();

	}
	
	exit_state=m_level->get_player().is_exited();	
	
	return exit_state;
	
}

void Game::get_keys()
{

	
	//direzione iniziale
	CL_System::keep_alive();
	
	Direction direction/*=STOP*/;
	
	if((CL_Keyboard::get_keycode(CL_KEY_ESCAPE))&&(m_level->get_player().is_alive()))
	{
			
		m_level->explode(m_level->get_player().get_position_x(),m_level->get_player().get_position_y());
		return;
				
	}
	
  //questi if settano la direzione a seconda del tasto premuto
	if(CL_Keyboard::get_keycode(CL_KEY_UP))
	{
			
		direction=UP;
				
	}
	else if(CL_Keyboard::get_keycode(CL_KEY_DOWN))
	{
			
		direction=DOWN;
		
	}
	else if(CL_Keyboard::get_keycode(CL_KEY_RIGHT))
	{
	
		direction=RIGHT;
		
	}
	else if(CL_Keyboard::get_keycode(CL_KEY_LEFT))
	{
	
		direction=LEFT;
		
	}
	if((direction>=UP)&&(direction<=LEFT))
	{
		m_level->get_player().set_direction(direction);
		//DEBOUT("Setting direction: "<<direction<<"\n");
	}
	
	if(CL_Keyboard::get_keycode(CL_KEY_SPACE))
	{
		m_level->get_player().set_snap(true);
	}
	else
	{
		m_level->get_player().set_snap(false);
	}
	

	
}

void Game::move_all()
{
	
	std::vector<Ntt_pointer>& list=m_level->get_entities_list();
	std::vector< std::vector<int> >& matrix=m_level->get_entities_matrix();

	m_level->get_player().set_speed(1);

	unsigned int i,x,y;
	for(x=0;x<k_level_size_x;x++)
	{
		for(y=0;y<k_level_size_y;y++)
		{
			matrix[x][y]=0;
		}
	}
	
	for(i=1; i<list.size(); i++)
	{	
		if((list[i].is_referenced())&&(list[i]->exists()))
		{
			list[i]->set_checked(false);
			matrix[list[i]->get_position_x()][list[i]->get_position_y()]=list[i]->get_id();
		}
	}
	
	
	for(i=1; i<list.size(); i++)
	{
		if((list[i].is_referenced())&&(list[i]->exists()))
		{
			if(list[i]->get_type()!=PLAYER)
				list[i]->check_and_do();
		}
	}
	
	if(m_level->get_player().exists())
	{
		m_level->get_player().check_and_do();
	}
	
	
}

void Game::draw()
{
//	Sprite* curr_sprite;
	std::vector<Ntt_pointer>& list=m_level->get_entities_list();
	Ntt_pointer curr_ntt;
	unsigned int current_frame_time=0;
	unsigned int speed=0;
	unsigned int last_frame=0;
	for(unsigned int j=0;j<k_max_anim_drawn;j++)
	{
		current_frame_time=CL_System::get_time();
		CL_Display::clear_display(0.0, 0.0, 0.0, 1.0);

		//centering screen on player
		m_screen.set_window_center(m_level->get_player().get_sprite().get_pos_x(),m_level->get_player().get_sprite().get_pos_y());

		//drawing player
		if(m_level->get_player().exists())
		{
			m_level->get_player().get_sprite().set_curr_frame(j*(k_sprite_size/k_max_anim_drawn)/4);
			m_level->get_player().get_sprite().move(k_sprite_size/k_max_anim_drawn);
			m_screen.put(m_level->get_player().get_sprite());
		}

//draw other entities
		for(unsigned int i=1; i<list.size(); i++)
		{
			curr_ntt=list[i];
			if((curr_ntt.is_referenced())&&(curr_ntt->exists())&&(curr_ntt->get_type()!=PLAYER))
			{
				curr_ntt->get_sprite().set_curr_frame(j*(k_sprite_size/k_max_anim_drawn)/4);
				curr_ntt->get_sprite().move(k_sprite_size/k_max_anim_drawn);
				m_screen.put(curr_ntt->get_sprite());
			}
		}
		
		draw_score();
		CL_Display::flip_display(true);
		if(j==k_max_anim_drawn/2)
		{
			get_keys();
		}

		while(CL_System::get_time()-current_frame_time<k_msec_per_frame);
		//	CL_System::sleep(10);
		CL_System::keep_alive();
	}
		
	CL_System::keep_alive();
	
}




void Game::draw_score()
{

	CL_Display::fill_rect(0, k_game_size_y-k_score_size_y, k_game_size_x, k_game_size_y,0,0,0,1.0);
		
	m_game_font->print_left(4,k_game_size_y-k_score_size_y+5, CL_String("Score:   ")+CL_String((int)m_level->get_player().get_score()));

	// find how many score to complete level
	int remaining=(int)(m_level->get_min_score()-m_level->get_player().get_score());

	if(remaining>0)
	{

		m_game_font->print_left(200,k_game_size_y-k_score_size_y+5, CL_String("Remaining:   ")+CL_String(remaining));

	}
	else
	{
    if(m_level->get_player().is_exited())
		{
			m_game_font->print_left(200,k_game_size_y-k_score_size_y+5, CL_String("Well done!"));
		}
		else
		{
			m_game_font->print_left(200,k_game_size_y-k_score_size_y+5, CL_String("Find Exit"));
		}

	}

	//draw_time
	CL_String time_string=m_time.get_time_string();
	m_time_font->print_left(k_game_size_x-k_sprite_size*2,k_game_size_y-k_sprite_size, time_string);

	
	if(!m_level->get_player().is_alive())
	{
		m_game_font->print_left(380,k_game_size_y-k_score_size_y+5, CL_String("Press Space"));
	}
	
	
	if(m_level->get_acquired_keys()&1)
		m_spriteset.get_sprite(KEY)->put_screen(k_game_size_x-k_sprite_size/2,k_game_size_y-k_sprite_size/2, k_sprite_size/2,k_sprite_size/2,0);
	
	if(m_level->get_acquired_keys()&2)
		m_spriteset.get_sprite(KEY)->put_screen(k_game_size_x-k_sprite_size,k_game_size_y-k_sprite_size/2, k_sprite_size/2,k_sprite_size/2,8);

	if(m_level->get_acquired_keys()&4)
		m_spriteset.get_sprite(KEY)->put_screen(k_game_size_x-(k_sprite_size+k_sprite_size/2),k_game_size_y-k_sprite_size/2, k_sprite_size/2,k_sprite_size/2,16);

	if(m_level->get_acquired_keys()&8)
		m_spriteset.get_sprite(KEY)->put_screen(k_game_size_x-2*k_sprite_size,k_game_size_y-k_sprite_size/2, k_sprite_size/2,k_sprite_size/2,24);

	CL_Display::draw_rect(0, k_game_size_y-k_score_size_y, k_game_size_x, k_game_size_y,1,0.5,0,1.0);

}

void Game::go()
{

//	DEBOUT("Entering Game::go()...\n");
	
//	DEBOUT("Entering main loop...\n");
	Menu menu(this, m_max_num_of_levels,m_unsolved_level);

	int play=menu.go();
	
  while(play!=3)
  {
  	if(play==0)
  	{
  		m_level=new Level(m_spriteset, m_sampleset);
  		
  		CL_String current_level_path(m_resource_path);
  		
  		current_level_path=current_level_path+"/maps/level";
  	


  		current_level_path=current_level_path+((const int)menu.get_current_level());
  		
  		current_level_path+=".map";
  	
     	try
  		{
  			m_level->load_map(current_level_path);
  								
  		}
  		catch(Common_Ex e)
  		{
  			std::cout<<e.get_message();
  			return;
  		}
  	
  		bool result=main_loop();
  	
  		CL_System::sleep(500);
    	
  		CL_System::keep_alive();	
  		//HACKSOMETHINGHERE
  		//Might add some Hiscores here...
  		delete m_level;
  		
  		switch(result)
  		{
   		case false:
  			DEBOUT("Game_over!...");
  			play=menu.go();
  			break;
  		case true:
  			DEBOUT("Winner! ;)");
  			
       if((menu.get_unsolved_level()==menu.get_current_level())&&(menu.increase_unsolved_level()))
       {

           ofstream update_config(m_ini_path);
           update_config<<menu.get_unsolved_level();
           menu.set_current_level(menu.get_unsolved_level());
           play=0;
       }
       else
       {
         //do nothing.. maybe a congratulation screen
         play=menu.go();
       }
  			
  			break;
  		}		
  	}
  	else if(play==2)
  	{
  		show_credits();
  		play=menu.go();
	  }	
  	
  }
}
	

Game::Game()
{

	DEBOUT("Entering Game ctor...\n");
	//portability "quick hack" :)
	#ifdef _WIN32
	m_resource_path=".";
	#else
	m_resource_path= RESOURCE_PATH;
	#endif
	DEBOUT("Resource_path: "<<m_resource_path<<"\n");
	
	
	
	#ifdef _WIN32
	m_ini_path="./epiphany.ini";
	#else
	CL_String user_home=getenv("HOME");
	if(user_home=="")
	{
		throw Common_Ex("Unable to find HOME environment variable");
	}
	else
	{
		m_ini_path=user_home+"/.epiphany";
	}
	#endif
	
	DEBOUT("Using "<<(m_resource_path+"/sprites.scr")<<" as resource script.\n");
	try
	{
		m_res_manag=new CL_ResourceManager(m_resource_path+"/sprites.scr", false);
	}
	catch(CL_Error ex)
	{
		std::cout<<ex.message;
	}

	DEBOUT("Loading config...\n");
	load_config();	
	DEBOUT("Loading fonts...\n");
	try
	{
		load_fonts();
	}
	catch(CL_Error ex)
	{
		std::cout<<ex.message;
	}
	
	m_spriteset=Spriteset(this, "SPT");
	DEBOUT("Loading sprites...\n");
	try
	{
		m_spriteset.load_sprites();
	}
	catch(CL_Error ex)
	{
		std::cout<<ex.message;
	}
	DEBOUT("Loading samples...\n");
	
	m_sampleset=Sampleset(this);
	try
	{
		m_sampleset.load_samples();
	}
	catch(CL_Error ex)
	{
		std::cout<<ex.message;
	}
	

	DEBOUT("Initing Screen...\n");
	m_screen.init(k_game_size_x,k_game_size_y,k_level_size_x, k_level_size_y, k_sprite_size);
	
	//DEBOUT("Exiting Game ctor... \n");
	
}

void Game::load_config()
{
	std::ifstream config(m_ini_path);
	
	if(!config)
	{
		DEBOUT("No "<<m_ini_path<<"; Creating...\n");
		std::ofstream new_config(m_ini_path);
		if(!new_config)
			throw Common_Ex("Unable to write config file!...\n");
		m_unsolved_level=0;
		new_config<<m_unsolved_level;
		return;
	}
	config>>m_unsolved_level;
	//find max_num_of_levels
	CL_DirectoryScanner dirscan;
	unsigned int i=0;
	if(dirscan.scan(m_resource_path+"/maps", "level*.map"))
	{
		//;
		while(dirscan.next()==true)
		{
			i++;
		}
	}
	m_max_num_of_levels=i;
}
	

void Game::load_fonts()
{
	DEBOUT("Loading fonts... ");
	m_game_font=CL_Font::load("Fonts/FNT_Game", m_res_manag);

	m_time_font=CL_Font::load("Fonts/FNT_Time", m_res_manag);

	m_credits_font=CL_Font::load("Fonts/FNT_Credits", m_res_manag);
	DEBOUT("done.\n");

}

Game::~Game()
{

	delete m_game_font;

	delete m_credits_font;

}


void Game::show_credits()
{
	int current_frame_time=0;
	vector<CL_String> credits;
	credits.push_back("Epiphany");
	credits.push_back(" ");
	credits.push_back("Coding:");
	credits.push_back("Giuseppe D'Aqu");
	credits.push_back("Giuseppe Martino");
	credits.push_back(" ");
	credits.push_back("Level Designing:");
	credits.push_back("Giuseppe D'Aqu");
	credits.push_back("Giuseppe Martino");
	credits.push_back(" ");
	credits.push_back("Graphics:");
	credits.push_back("Giuseppe D'Aqu");
	credits.push_back("Antonio Malara");
	credits.push_back(" ");
	credits.push_back("Epiphany Map Definition Language:");
	credits.push_back("Giuseppe Martino");
	credits.push_back(" ");
	credits.push_back("Thanks to:");
	credits.push_back("Antonio Malara");
	credits.push_back("Giuseppe Martino");
	credits.push_back("Kenneth Gangstoe");
	credits.push_back("Joerg Jaspert");
	credits.push_back("All ClanLib developers");
	
	//alpha blending too slow
	//CL_Surface* srf_top = new CL_Surface("Surfaces/MNU_Top", m_res_manag);
	//CL_Surface* srf_bottom = new CL_Surface("Surfaces/MNU_Bottom", m_res_manag);

	int draw_pos=k_game_size_y;

//standard method: text scrolling
	
	unsigned int i;
	
	while(!CL_Keyboard::get_keycode(CL_KEY_ESCAPE))
	{
		current_frame_time=CL_System::get_time();
		CL_Display::clear_display(0,0,0,1);
		for(i=0; i<credits.size(); i++)
		{
			m_credits_font->print_center(k_game_size_x/2,draw_pos+50*i,credits[i]);
			
			//m_credits_font->print_center((k_game_size_x/2)-20*sin(M_PI*20*draw_pos/k_game_size_y+(i%4)*M_PI/4),draw_pos+50*i,credits[i]);
		
		}
		
    if(draw_pos+50*credits.size()>0)
		{
			draw_pos-=(int)(((CL_System::get_time()-current_frame_time)/20)+1);
		}
		else
		{
			draw_pos=k_game_size_y;
		}

  //alpha blending too slow
//		srf_top->put_screen(0,0);
//		srf_bottom->put_screen(0,k_game_size_y-100);

		while(CL_System::get_time()-current_frame_time<20);
		CL_Display::flip_display(true);
		

		CL_System::keep_alive();
	}

}


CL_ResourceManager* Game::get_resource_manager()
{
	return m_res_manag;
}





