#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>

#include "entity.h"
#include "init.h"

/*** Define the EIO functions for the rendgtk mainloop. ***/

typedef struct {
    EIOFunc func;		/* Thier callback function. */
    void *data;			/* Thier data for the callback. */
    gint gtag;			/* My gdk input tag. */
} RendGtkIO;

gint
rendgtk_io_cond_met (RendGtkIO * data, gint fd, GdkInputCondition gcond)
{
    EIOCond cond = 0;

    /* Init the condition so that we don't confuse the user code. */
    if (gcond & GDK_INPUT_READ)
	cond = EIO_READ;
    else if (gcond & GDK_INPUT_WRITE)
	cond = EIO_WRITE;
    else if (gcond & GDK_INPUT_EXCEPTION)
	cond = EIO_ERROR;

    if (gcond & GDK_INPUT_READ) {
	cond |= EIO_READ;
    }
    if (gcond & GDK_INPUT_WRITE) {
	cond |= EIO_WRITE;
    }
    if (gcond & GDK_INPUT_EXCEPTION) {
	cond |= EIO_ERROR;
    }

    /* Pass thru. */
    return data->func (fd, cond, data->data);
}

void *
rendgtk_eio_add (int fd, EIOCond cond, EIOFunc func, void *data)
{
    GdkInputCondition gcond = 0;
    RendGtkIO *ioptr;

    ioptr = g_new0 (RendGtkIO, 1);
    ioptr->func = func;
    ioptr->data = data;

    /* Init the condition so that we arn't watchin a read when * we only care 
     * about write. */
    if (cond & EIO_READ)
	gcond = GDK_INPUT_READ;
    else if (cond & EIO_WRITE)
	gcond = GDK_INPUT_WRITE;
    else if (cond & EIO_ERROR)
	gcond = GDK_INPUT_EXCEPTION;


    /* Now we can or together the conditions because we have an initial *
     * condition set. */
    if (cond & EIO_READ)
	gcond |= GDK_INPUT_READ;
    if (cond & EIO_WRITE)
	gcond |= GDK_INPUT_WRITE;
    if (cond & EIO_ERROR)
	gcond |= GDK_INPUT_EXCEPTION;


    ioptr->gtag = gdk_input_add (fd, gcond,
				 (GdkInputFunction) rendgtk_io_cond_met, ioptr);

    return ioptr;		/* This becomes the tag for the
				 * EIORemoveFunc's. */
}

void
rendgtk_eio_remove (void *tag)
{
    RendGtkIO *ioptr = (RendGtkIO *) tag;

    gdk_input_remove (ioptr->gtag);
    g_free (ioptr);
}

/* Wrap this so we can have a symbol to handle it by. */
void
rendgtk_main (void)
{
    gtk_main ();
}

/*** Init code for the renderers and mainloop init code. ***/

#ifdef STATIC_GTK
void
rendgtk_init (RendererFlags flags)
#else
void
renderer_init (RendererFlags flags)
#endif
{
    int entity_argc;
    gchar **entity_argv;

    if (flags & RENDERER_INIT) {
	EDEBUG (("gtk-common", "initializing gtk+"));
	entity_argc = entity_get_argc ();
	entity_argv = entity_get_argv ();

	gtk_set_locale();

	/* entity_get_argv gives a pointer to the pointer to the argv array. */
	gtk_init (&entity_argc, &entity_argv);
	
	/* We only register the object in the INIT part, because only
	 * after we have seen some other GTK tag do we want to let
	 * entity know that gtk can render objects. */
	object_renderer_register ();
    }

    if (flags & RENDERER_REGISTER) {
	/* Slight hack to make these registers work */
	gtk_type_init ();

	mainloop_register ("rendgtk_main",
			   rendgtk_main, rendgtk_eio_add, rendgtk_eio_remove);

	align_renderer_register ();
	arrow_renderer_register ();
	button_renderer_register ();
	checkbox_renderer_register ();
	ctree_renderer_register ();
	dropdown_renderer_register ();
	entry_renderer_register ();
	filesel_renderer_register ();
	fixed_renderer_register ();
	frame_renderer_register ();
	label_renderer_register ();
	list_renderer_register ();
	menu_renderer_register ();
	notebook_renderer_register ();
	pane_renderer_register ();
	progress_renderer_register ();
	radio_renderer_register ();
	scrollwindow_renderer_register ();
	separator_renderer_register ();
	slider_renderer_register ();
	spinner_renderer_register ();
	text_renderer_register ();
	timer_renderer_register ();
	toggle_button_renderer_register ();
	tree_renderer_register ();
	window_renderer_register ();
	wizard_renderer_register ();
        gtkmain_renderer_register ();
    }

    /* In extras now.
     * databox_renderer_register ();
     * image_renderer_register (); 
     * wrapalign_renderer_register ();
     * ebox_renderer_register (); */

#ifdef STATIC_GTK
    /* Load the extras right away, if static. */
    rendgtk_extra_init (flags);
#endif				/* STATIC_GTK */

}
