/*
 * Copyright (C) 2002,2003 Daniel Heck
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: cache.hh,v 1.2 2003/01/12 19:33:16 dheck Exp $
 */
#ifndef PX_CACHE_HH
#define PX_CACHE_HH

#include "dict.hh"
#include <string>

namespace px
{
    template <class T, class Alloc>
    class Cache {
    public:
        Cache() {}
        Cache(const Alloc &a) :alloc(a), cache(1223) {}
        ~Cache() { clear(); }
        void clear() {
            for (iterator i=cache.begin(); i!=cache.end(); ++i) 
                alloc.release(i->second);
            cache.clear();
        }

        T get(const std::string &key) {
            iterator i=cache.find(key);
            if (i!=cache.end())
                return i->second;
            else {
                T p = alloc.acquire(key);
                cache.insert(key, p); //[key] = p;
                return p;
            }
        }
        unsigned size() const { return cache.size(); }
    private:
        typedef px::Dict<T> Map;
        typedef typename Map::iterator iterator;
//         typedef typename Map::const_iterator const_iterator;

        Alloc alloc;
        Map cache;
    };
}

#endif
