/*
		       Configuration Items & Lists
 */

#ifndef CFG_H
#define CFG_H

#include <glib.h>

/*
 *	Cfg Item Types:
 */
typedef enum {
	CFG_ITEM_TYPE_NONE,
	CFG_ITEM_TYPE_INT8,
	CFG_ITEM_TYPE_UINT8,
	CFG_ITEM_TYPE_INT16,
	CFG_ITEM_TYPE_UINT16,
	CFG_ITEM_TYPE_INT32,
	CFG_ITEM_TYPE_UINT32,
	CFG_ITEM_TYPE_INT64,
	CFG_ITEM_TYPE_UINT64,
	CFG_ITEM_TYPE_FLOAT,
	CFG_ITEM_TYPE_DOUBLE,
	CFG_ITEM_TYPE_STRING,
	CFG_ITEM_TYPE_INTLIST,
	CFG_ITEM_TYPE_COLOR,
	CFG_ITEM_TYPE_ACCELKEY_LIST,
	CFG_ITEM_TYPE_STYLE
} cfg_type;


/*
 *	Cfg Item:
 */
typedef struct _cfg_item_struct		cfg_item_struct;
struct _cfg_item_struct {
	cfg_type	type;		/* One of CFG_ITEM_TYPE_* */
	gchar		*parameter;	/* Parameter */
	gpointer	value;		/* Value (determined by type) */
};
#define CFG_ITEM(p)	((cfg_item_struct *)(p))

/*
 *	Integer List:
 */
typedef struct _cfg_intlist_struct	cfg_intlist_struct;
struct _cfg_intlist_struct {                 
	GList		*list;
};
#define CFG_INTLIST(p)		((cfg_intlist_struct *)(p))

/*
 *	Color:
 */
typedef struct _cfg_color_struct	cfg_color_struct;
struct _cfg_color_struct {
	gfloat		r, g, b, a;	/* 0.0 to 1.0 */
};
#define CFG_COLOR(p)		((cfg_color_struct *)(p))

/*
 *	Accelkey:
 */
typedef struct _cfg_accelkey_struct		cfg_accelkey_struct;
struct _cfg_accelkey_struct {
	gint		opid;
	guint		key,
			modifiers;
};
#define CFG_ACCELKEY(p)		((cfg_accelkey_struct *)(p))

/*
 *	Accelkey List:
 */
typedef struct _cfg_accelkey_list_struct	cfg_accelkey_list_struct;
struct _cfg_accelkey_list_struct {
	GList		*list;
};
#define CFG_ACCELKEY_LIST(p)	((cfg_accelkey_list_struct *)(p))                    


/*
 *	Style Flags:
 */
typedef enum {
	CFG_STYLE_FG			= (1 << 0),
	CFG_STYLE_BG			= (1 << 1),
	CFG_STYLE_TEXT			= (1 << 2),
	CFG_STYLE_BASE			= (1 << 3)
} cfg_style_flags;

/*
 *	Style:
 *
 *	Mimics the GtkRcStyle structure.
 */
typedef struct _cfg_style_struct	cfg_style_struct;
struct _cfg_style_struct {
#define CFG_STYLE_STATES	5
	gchar		*font_name;
	cfg_style_flags	color_flags[CFG_STYLE_STATES];
	cfg_color_struct	fg[CFG_STYLE_STATES],
				bg[CFG_STYLE_STATES],
				text[CFG_STYLE_STATES],                      
				base[CFG_STYLE_STATES];
	gchar		*bg_pixmap_name[CFG_STYLE_STATES];
};
#define CFG_STYLE(p)            ((cfg_style_struct *)(p))


/* Item Types */
extern cfg_intlist_struct *CFGIntListNew(GList *glist);
extern void CFGIntListDelete(cfg_intlist_struct *intlist);

extern cfg_color_struct *CFGColorNew(
	gfloat r, gfloat g, gfloat b, gfloat a
);
extern void CFGColorDelete(cfg_color_struct *color);

extern cfg_accelkey_struct *CFGAccelkeyNew(
	gint opid, guint key, guint modifiers
);
extern void CFGAccelkeyDelete(cfg_accelkey_struct *accelkey);
extern cfg_accelkey_list_struct *CFGAccelkeyListNew(GList *list);
extern void CFGAccelkeyListDelete(cfg_accelkey_list_struct *accelkey_list);

extern cfg_style_struct *CFGStyleNew(void);
extern void CFGStyleDelete(cfg_style_struct *style);


/* Cfg Item */
extern cfg_item_struct *CFGItemNew(
	cfg_type type, const gchar *parameter
);
extern gpointer CFGItemGetValue(
	const cfg_item_struct *ci, cfg_type *type_rtn
);
extern void CFGItemSetValue(cfg_item_struct *ci, gconstpointer value);
extern void CFGItemResetValue(cfg_item_struct *ci);
extern void CFGItemReset(cfg_item_struct *ci);
extern void CFGItemDelete(cfg_item_struct *ci);


/* Cfg List Utilities */
extern cfg_item_struct *CFGItemListCopyList(
	const cfg_item_struct *list
);
extern void CFGItemListDeleteList(cfg_item_struct *list);
extern gint CFGItemListMatchParameter(
	const cfg_item_struct *list, const gchar *parameter
);

/* Cfg Item Value fetching */
extern gpointer CFGItemListMatchGetValue(
	const cfg_item_struct *list, const gchar *parameter,
	cfg_type *type_rtn
);
extern gint CFGItemListGetValueI(
	const cfg_item_struct *list, const gchar *parameter
);
extern glong CFGItemListGetValueL(
	const cfg_item_struct *list, const gchar *parameter
);
extern gulong CFGItemListGetValueUL(
	const cfg_item_struct *list, const gchar *parameter
);
extern gfloat CFGItemListGetValueF(
	const cfg_item_struct *list, const gchar *parameter
);
extern gdouble CFGItemListGetValueD(
	const cfg_item_struct *list, const gchar *parameter
);
extern gchar *CFGItemListGetValueS(
	const cfg_item_struct *list, const gchar *parameter
);
extern cfg_color_struct *CFGItemListGetValueColor(
	const cfg_item_struct *list, const gchar *parameter
);
extern cfg_intlist_struct *CFGItemListGetValueIntList(
	const cfg_item_struct *list, const gchar *parameter
);
extern cfg_accelkey_list_struct *CFGItemListGetValueAccelkeyList(
	const cfg_item_struct *list, const gchar *parameter
);
extern cfg_style_struct *CFGItemListGetValueStyle(
	const cfg_item_struct *list, const gchar *parameter
);

/* Cfg Item Value setting */
extern void CFGItemListSetValue(
	cfg_item_struct *list, const gchar *parameter,
	gconstpointer value, gboolean create_as_needed
);
extern void CFGItemListSetValueI(
	cfg_item_struct *list, const gchar *parameter,
	gint value, gboolean create_as_needed
);
extern void CFGItemListSetValueL(
	cfg_item_struct *list, const gchar *parameter,
	glong value, gboolean create_as_needed
);
extern void CFGItemListSetValueUL(
	cfg_item_struct *list, const gchar *parameter,
	gulong value, gboolean create_as_needed
);
extern void CFGItemListSetValueF(
	cfg_item_struct *list, const gchar *parameter,
	gfloat value, gboolean create_as_needed
);
extern void CFGItemListSetValueD(
	cfg_item_struct *list, const gchar *parameter,
	gdouble value, gboolean create_as_needed
);
extern void CFGItemListSetValueS(
	cfg_item_struct *list, const gchar *parameter,
	const gchar *value, gboolean create_as_needed
);
extern void CFGItemListSetValueColor(
	cfg_item_struct *list, const gchar *parameter,
	const cfg_color_struct *value, gboolean create_as_needed
);
extern void CFGItemListSetValueIntList(
	cfg_item_struct *list, const gchar *parameter,
	const cfg_intlist_struct *value, gboolean create_as_needed
);
extern void CFGItemListSetValueAccelkeyList(
        cfg_item_struct *list, const gchar *parameter,
        const cfg_accelkey_list_struct *value, gboolean create_as_needed
);
extern void CFGItemListSetValueStyle(
	cfg_item_struct *list, const gchar *parameter,
	const cfg_style_struct *value, gboolean create_as_needed
);


#endif	/* CFG_H */
