/*
 * Undo the UTF graphics of messages on 163.35 MHz
 *
 * I may help to know that maybe the data really is valid, at
 * least emwin got a matching checksum before we got here...
 *
 * Or, error free files came from the NWS ftp site...
 * http://iwin.nws.noaa.gov/pub/data/graphics/
 * ftp://iwin.nws.noaa.gov/g:\www\pub\data\graphics
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include <netinet/in.h>
#include "utf.h"
#include "version.h"

int ps_utf_preamble(FILE *fp);
int ps_utf_trailer(FILE *fp);

#ifdef STANDALONE
int currX, currY;
#else
extern int currX, currY;
#endif
FILE *psfp;

typedef struct {
  char filename[512];
  char *product;
  int filesize;
  unsigned char *data;
} UTFrecord;

int
UTFunstuff(UTFrecord *utf)
{
  int i;
  unsigned char *rp, *wp;

  /* UTF files have been stuffed 0203 -> 020 014 (and 020 -> 020 020). */
  wp = rp = utf->data; /* Start read and write pointers at 1st data item */
  for (i=0;i<utf->filesize;i++) {
    if (*rp == 0x10) {
      rp++; i++;
      switch (*rp) {
      case 0x10:
	*wp = 0x10; break;
      case 0x0C:
	*wp = 0x83; break;
      default:
	fprintf(stderr,"Error unstuffing UTF file.\n");
	return(1);
      }
    } else { /* No need to unstuff, but everything may get shifted. */
      *wp = *rp;
    }
    rp++; wp++;
  }
  while (wp<rp) {*wp=0; wp++;} /* Null out past end of unstuffed file */
  return(0);
}

int
UTFparse(UTFrecord *utf)
{
  unsigned char *up;  /* up: unsigned pointer */
  unsigned char *end;

  end = &(utf->data[utf->filesize]);
  up=utf->data;
  while(*up) up++; /* Pass over initial string */
  up++; /* And its null termination */

  while(up < end)
  switch(*up) {
  case 0: /* Done, normal completion */
    return(0);
    break;
  case 0xC1: /* Graphics Product Description */
    up = gpd1parse(up);
    break;
  case 0xC2: /* Device Command */
    up = dc2parse(up);
    break;
  case 0xC3: /* Relative Vectors */
    up = rv3parse(up);
    break;
  case 0xC4: /* Absolute Vectors */
    up = av4parse(up);
    break;
  case 0xC5: /* Alphanumeric (ASCII) Characters */
    up = ac5parse(up);
    break;
  case 0xC6: /* Variable Exception Vector (VEC) */
    up = vec6parse(up);
    break;
  case 0xC7: /* Compact Pen Command (CPC) Vectors */
    up = cpc7parse(up);
    break;
  case 0xC8: /* Offset Alphanumeric Characters */
    up = oac8parse(up);
    break;
  case 0xDf: /* Gridded Data Field */
    up = gdf31parse(up);
    break;
  default: /* Done, error */
    printf("Unknown type: %X\n",*up); return(*up);
    break;
  }

  return(0); /* Can't get here */
}

/*
 * For now, give it a complete valid file. Maybe later it can put
 * together its own valid file from the pieces emwin delivers.
 */
#ifdef STANDALONE
int
main(int argc,char *argv[])
#else
int
utf(int argc,char *argv[])
#endif
{
  FILE *fp;
  struct stat stats;
  UTFrecord *utf;
  char plotfile[512];

  if (argc<2) {
    printf("Try: %s GPHfile\n\twhere GPHfile is a valid UTF file\n",
	   argv[0]);
    return(1);
  }
  utf = (UTFrecord *) malloc(sizeof(UTFrecord));

#ifdef STANDALONE
  psfp = fopen("utfout.ps","w");
  ps_utf_preamble(psfp);
  fprintf(psfp,"100 100 moveto\n(%s) show\n",argv[1]);
  fprintf(psfp,"150 400 translate\n0.02 0.02 scale\n");
#endif
  sprintf(utf->filename,"%s",argv[1]);
  fflush(stdout);
  stat(argv[1],&stats);
  utf->filesize = stats.st_size;
  utf->data = (unsigned char *)malloc(utf->filesize);
  fp = fopen(argv[1],"r");
  fread(utf->data,utf->filesize,1,fp);
  fclose(fp);
  if (UTFunstuff(utf)) return(1);
  utf->product=(char *)utf->data; /* Seems the first bit is null terminated. */

  sprintf(plotfile,"%s.plot",utf->data);

  UTFparse(utf);
  printf("Processed a %d byte file of %s.\n",utf->filesize,utf->product);

  free(utf);
#ifdef STANDALONE
  ps_utf_trailer(psfp);
  fclose(psfp);
#endif
  return(0);
}

unsigned char *
gpd1parse(unsigned char *up)
{
  ProductDefinition *pd;

  printf("Graphics Product Definition:\n");

  pd = (ProductDefinition *)up;
  printf("PI: %u\n",pd->PI);
  printf("GS: %u\n",ntohs(pd->GS));
  printf("IMAX: %u\n",ntohs(pd->IMAX));
  printf("JMAX: %u\n",ntohs(pd->JMAX));
#ifdef __linux__
  printf("DAY: %d\n",pd->DAY);
  printf("MONTH: %d\n",pd->MONTH);
  printf("YEAR: %d\n",pd->YEAR);
#else
  printf("DMY: %4X\n",pd->DMY);
#endif
  printf("TIME: %u\n",ntohs(pd->TIME));

  printf("PI=%d\n",*(++up)); ++up;
  ++up; ++up; /* Word 2 */
  ++up; ++up;
  ++up; ++up;
  ++up; ++up;
  ++up; ++up; /* Word 6 */
  return(up);
}

unsigned char *
dc2parse(unsigned char *up)
{
  int i, wordcount;
  unsigned short *wp; /* wp: word pointer */

  wp = (unsigned short *)up;
  ++wp;
  wordcount = *wp;
  printf("Device Control (%d words):\n",wordcount);
  for (i=0;i<wordcount;i++) {
    wp++; up++; up++;
    printf("%6d: %04X\n",i,*wp);
  }
  return(up);
}

unsigned char *
rv3parse(unsigned char *up)
{
  int X,Y,draw,i,wordcount;
  unsigned short *wp; /* wp: word pointer */
  RelativeVectors *vp;

  printf("Relative Vectors:\n");

  vp = (RelativeVectors *) up;
  up++; up++;
  up++; up++;
  up++; up++;
  /* if (*wp==0x8000) *wp=82; Huh? */
  wordcount = ntohs(vp->nwords);
  printf("%d words of data.\n",wordcount); up++; up++;
  printf("Starting at (%u,%u)\n",ntohs(vp->STARTI),ntohs(vp->STARTJ));
  moveto(ntohs(vp->STARTI),ntohs(vp->STARTJ));
  wp = &(vp->data);
  for(i=0;i<wordcount;i++) {
    *wp = ntohs(*wp);
    if (*wp & 0x8000) {
      if (*wp & 0x0080) {
	printf("moverel "); draw=0;
      } else {
	printf("drawrel "); draw=1;
      }
      if (*wp & 0x4000) printf("-");
      printf("%u, ",X=(*wp&0x3F00)>>8);
      if (*wp & 0x4000) X = -X;
      if (*wp & 0x0070) printf("-");
      printf("%u\n",Y=*wp&0x007F);
      if (*wp & 0x0070) Y = -Y;
      if (draw) drawrel(X,Y); else moverel(X,Y);
    } else {
      if (ntohs(wp[1])&0x0400) {
	printf("Moverel "); draw=0;
      } else {
	printf("Drawrel "); draw=1;
      }
      if (*wp & 0x1000) printf("-");
      printf("%u, ",X=*wp&0x0FFF);
      if (*wp & 0x1000) X=-X;
      wp++; up++; up++; i++;
      *wp = ntohs(*wp);
      if (*wp & 0x1000) printf("-");
      printf("%u\n",Y=*wp&0x0FFF);
      if (*wp & 0x1000) Y=-Y;
      if (draw) drawrel(X,Y); else moverel(X,Y);
    }
    wp++; up++; up++;
  }
  return(up);
}

unsigned char *
av4parse(unsigned char *up)
{
  int i, wordcount, X, Y;
  unsigned short *wp; /* wp: word pointer */

  printf("Absolute Vectors\n");
  wp = (unsigned short *)up;
  printf("ZT = %d\n",(*wp&0x0018)>>2);
  printf("ZF = %d\n",*wp&0x0007);
  wp++;
  printf("Start at (%d, %d)\n",*wp++,*wp++);
  wordcount = *wp; wp++;
  for (i=0;i<wordcount/2;i++) {
    X = *wp++;
    Y = *wp++;
    if (Y&0x8000) {
      printf("moveto "); moveto(X&0x7FFF,Y&0x7FFF);
    } else {
      printf("drawto "); drawto(X&0x7FFF,Y&0x7FFF);
    }
    printf("(%d, %d)\n",X&0x7FFF,Y&0x7FFF);
  }
  return(up);
}

unsigned char *
ac5parse(unsigned char *up)
{
  int G, B, RB, ZT, ZF, CS, X, Y, i, wordcount;
  unsigned short *wp; /* wp: word pointer */

  printf("Alphanumeric Characters\n");
  wp = (unsigned short *)up;
  wp++;
  printf("At (%d, %d)\n",X=0x3FFF&ntohs(*wp++),Y=ntohs(*wp));
  wp++;
  up = (unsigned char *) wp;
  while (3 != ((*up&0xC0)>>6)) { printf("%c",*up); up++; }
  printf("\n");
  return(up);
}

unsigned char *
vec6parse(unsigned char *up)
{
  printf("Variable Exception Vectors (VEV)\n");
  return(up);
}

unsigned char *
cpc7parse(unsigned char *up)
{
  printf("Compact Pen Command (CPC) vectors\n");
  return(up);
}

unsigned char *
oac8parse(unsigned char *up)
{
  int G, B, RB, ZT, ZF, CS, X, Y, i, wordcount;
  unsigned short *wp; /* wp: word pointer */
  
  printf("Offset alphanumeric characters\n");
  wp = (unsigned short *)up;
  wp++;
  printf("At (%d, %d)\n",X=0x7FFF&ntohs(*wp++),Y=ntohs(*wp));
  wp++; wp++;
  up = (unsigned char *) wp;
  while (3 != ((*up&0xC0)>>6)) { printf("%c",*up); up++; }
  printf("\n");
  return(up);
}

unsigned char *
gdf31parse(unsigned char *up)
{
  printf("Gridded Data Format\n");
  return(up);
}

#ifdef STANDALONE
int moveto(int x, int y)
{
  fprintf(psfp,"%d %d moveto\n",x,y);
  printf("%d %d moveto\n",x,y);
  currX=x; currY=y;
  return(0);
}
int drawto(int x, int y)
{
  fprintf(psfp,"%d %d lineto\n",x,y);
  printf("%d %d lineto\n",x,y);
  currX=x; currY=y;
  return(0);
}
int moverel(int x, int y)
{
  currX+=x; currY+=y;
  fprintf(psfp,"%d %d moveto\n",currX,currY);
  printf("%d %d moveto\n",currX,currY);
  return(0);
}
int drawrel(int x, int y)
{
  fprintf(psfp,"%d %d moveto\n",currX,currY);
  currX+=x; currY+=y;
  fprintf(psfp,"%d %d lineto\n",currX,currY);
  printf("%d %d lineto\n",currX,currY);
  return(0);
}
#endif

int
ps_utf_preamble(FILE *fp)
{
  fprintf(fp,"%%!PS-Adobe-2.0 EPSF-1.2\n");
  fprintf(fp,"%%%%Creator: A. Maitland Botoms\n");
  fprintf(fp,"%%%%Title: hand drawn postscript\n");
  fprintf(fp,"%%%%CreationDate: Thu Nov 14 15:15:15 1996\n");
  fprintf(fp,"%%%%Pages: 1\n");
  fprintf(fp,"%%%%PageOrder: Ascend\n");
  fprintf(fp,"%%%%BoundingBox: 0 0 2048 2048\n");
  fprintf(fp,"%%%%DocumentFonts: Times-Roman Times-Bold Times-Italic\n");
  fprintf(fp,"%%%%EndComments\n");
  fprintf(fp,"%%%%EndProlog\n");
  fprintf(fp,"/Times-Roman findfont 24.00 scalefont setfont\n");
  fprintf(fp,"10 /linewidth\n");
  fprintf(fp,"1024 1024 moveto\n");
  return(0);
}

int
ps_utf_trailer(FILE *fp)
{
  fprintf(fp,"stroke\n");
  fprintf(fp,"%%%%PageTrailer\n");
  fprintf(fp,"%%%%showpage\n");
  fprintf(fp,"%%%%Trailer\n");
  fprintf(fp,"%%%%EOF\n");
  return(0);
}
