#ifndef __INTERFACE_H__
#define __INTERFACE_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include "ecurses.h"

/****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

extern void interface_free_resources (void);
extern void interface_setup (void);
extern void interface_post_setup (void);

extern void interface_focus (int i);
/*+
  Redraw the whole window.  Very useful, when one of other
  application corrupts your console.
  +*/
/** redraw the whole screen */
extern void interface_redraw (void);
/*+
  Bring next window to front.  It may cause some unexpected
  behaviour if windows overlap.  Sometimes it is better to
  close the window.
  +*/
/** switch to the next window */
extern void interface_next_window (void);
/** switch to the previous window */
extern void interface_prev_window (void);
/*+
  Check what key was pressed as last.  If it was a digit, then
  switch to the window with that number.  This function is mapped
  to \M-d (for all digits d) as default.
  +*/
/** switch to particular window */
extern void interface_num_window (void);

extern WINDOW *window_create (char *name, int height, int width, int left,
                              int top, int focus);
extern void window_set_functions (WINDOW *win, void (*show)(void),
                                  void (*draw)(void), void (*set_focus)(void),
                                  void (*unset_focus)(void));
extern void window_show (WINDOW *win);
extern void window_hide (WINDOW *win);

extern int window_addch (WINDOW *win, chtype c);
extern int window_addnstr (WINDOW *win, const char *str, int n);
extern int window_addnast (WINDOW *win, const char *str, int n);
extern int window_addchnstr (WINDOW *win, const chtype *str, int n);

#define window_mvaddch(win,y,x,c)       (wmove (win, y, x) == ERR ? ERR : window_addch (win, c))
#define window_addstr(win,s)            (window_addnstr (win, s, -1))
#define window_mvaddnstr(win,y,x,s,n)   (wmove (win, y, x) == ERR ? 0 : window_addnstr (win, s, n))
#define window_mvaddstr(win,y,x,s)      (wmove (win, y, x) == ERR ? 0 : window_addstr (win, s))
#define window_addchstr(win,s)          (window_addchnstr (win, s, -1))
#define window_mvaddchnstr(win,y,x,s,n) (wmove (win, y, x) == ERR ? 0 : window_addchnstr (win, s, n))
#define window_mvaddchstr(win,y,x,s)    (wmove (win, y, x) == ERR ? 0 : window_addchstr (win, s))

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER interface.h
 *
 ****************************************************************************/
#endif
