/*  $Header: /cvsroot/dvipdfmx/src/pdffont.h,v 1.3 2004/03/11 11:50:23 hirata Exp $

    This is dvipdfmx, an eXtended version of dvipdfm by Mark A. Wicks.

    Copyright (C) 2002 by Jin-Hwan Cho and Shunsaku Hirata,
    the dvipdfmx project team <dvipdfmx@project.ktug.or.kr>
    
    Copyright (C) 1998, 1999 by Mark A. Wicks <mwicks@kettering.edu>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
*/

#ifndef _PDFFONT_H_
#define _PDFFONT_H_

#define PDFFONT_FONTTYPE_TYPE1    0
#define PDFFONT_FONTTYPE_TYPE1C   1
#define PDFFONT_FONTTYPE_TYPE3    2
#define PDFFONT_FONTTYPE_TRUETYPE 3

/*
 * PDF_NAME_LEN_MAX: see, Appendix C of PDF Ref. v1.3, 2nd. ed.
 * This is Acrobat implementation limit.
 */
#ifndef PDF_NAME_LEN_MAX
#define PDF_NAME_LEN_MAX 127
#endif

extern void pdf_font_set_verbose (void);
extern int  pdf_font_get_verbose (void);

extern void pdf_font_set_dpi (int font_dpi);

typedef struct pdf_font
{
  char    *ident;
  int      subtype;

  /* 3 ASCII character for #XX */
  char     fontname[3*PDF_NAME_LEN_MAX+1];
  char     uniqueID[7];
  int      encoding_id;

  char    *filename;
  int      embedding;

  double   font_scale;
  double   design_size;
  /*
   * PDF font resource objects
   */
  pdf_obj *indirect;
  pdf_obj *fontdict;
  pdf_obj *descriptor;

  /*
   * Font format specific data
   */
  int      flags;
  char    *used_chars;

} pdf_font;

extern void pdf_font_make_tag (char *tag);

extern void pdf_font_init  (void);
extern void pdf_font_close (void);

extern int      pdf_font_findfont (const char *font_name, int encoding_id,
				   double font_scale, double design_size, int embedding);

extern int      pdf_font_get_fonttype (int font_id);
extern pdf_obj *pdf_font_get_resource (int font_id);
extern char    *pdf_font_get_usedchar (int font_id);

/* Font name with pseudo unique tag */
extern char    *pdf_font_get_fontname (int font_id);

#endif /* _PDFFONT_H_ */
