import java.io.File;
import java.util.*;
import java.io.IOException;


/**
 *
 * Scans directories on the local filesystem for files to index.
 * 
 * <br><br>$Id: DirScanner.java,v 1.13 2002/09/07 15:44:59 howama Exp $
 */
class DirScanner extends FileListBuilder {
    /**
     * Constructor
     * @param logObj The object ot use for logging
     * @param parserChooser The parser to use for extracting info from files
     * @param incFilters Include filters
     * @param excFilters Exclude filters
     * @param targetList Object to build FileList in
     */
    DirScanner(IGLog logObj, ParserChooser parserChooser, String[] incFilters,
	    String[] excFilters, FileList targetList) {
        super(logObj, parserChooser, incFilters, excFilters, targetList);
        log.add(9, "DIRScanner initialised");
    }

    /**
     * Scans a single directory for files and other directories to be indexed. 
     * @param directory the direcotyr to be scanned.
     */
    public void scan(String directory) throws java.io.IOException,
	    IllegalVariableException {
        log.add(6, "Scanning Directory " + directory);
        /*
         * Test Exclude filters.
         */
        if (! filePassesFilters(directory))
            return;

        File dir = new File(directory);

		if (!dir.exists()){
			log.addWarning(120, "DIR_NOT_EXIST", new Object[] {directory});
			return;
		}
		if (!dir.isDirectory()){
			log.addWarning(121, "DIR_NOT_DIR", new Object[] {directory});
			return;
		}
		
        File[] dirFiles = dir.listFiles();
        log.add(9, "Examining  directory contents. Number found: "
		+ dirFiles.length);
        for (int i = 0; i < dirFiles.length; i++) {
            if (dirFiles[i].toString().equals(".")
		    || dirFiles[i].equals("..")) {
                continue;
            }

            if (dirFiles[i].isDirectory()) {
                scan(dirFiles[i].toString());
				// TODO: Check for synlinks, possible recursion.
//            } else if (dirFiles[i].isSymLink()){
			}else{
                if (filePassesFilters(directory+dirFiles[i].toString())) {
                    IGFile file = new IGFile(dirFiles[i].toString());
                    try {
                        parser.parse(file);
                        addFile(file);
                        log.add(12, "Adding File: " + file.getLocation()
				+ file.getString(IGKey.TITLE));
                    } catch(IOException e) {
                        log.addError(101, "NO_PARSER", new Object[] {file.getLocation()} );
                    }
                }
            }
        }
    }
}

/*
 * $Log: DirScanner.java,v $
 * Revision 1.13  2002/09/07 15:44:59  howama
 * bug fix. now detects invalid directories
 *
 * Revision 1.12  2002/09/06 13:58:13  howama
 * added debian file parser
 *
 * Revision 1.11  2002/09/04 20:08:48  howama
 * user interface work
 *
 * Revision 1.10  2002/09/01 22:52:46  blsecres
 * Created unit test for Project class.
 * Fixed bugs uncovered by testing.
 *
 * Revision 1.9  2002/08/31 15:27:56  howama
 * various changes
 *
 * Revision 1.8  2002/08/27 13:32:07  blsecres
 * Renamed ParserFactory to ParserChooser.
 *
 * Revision 1.7  2002/08/22 19:47:13  blsecres
 * Switched code to use IGKey values.
 *
 * Revision 1.6  2002/08/22 18:50:04  blsecres
 * Modified FileListBuilder base class and implementing classes to take a
 * ParserFactory as a constructor argument.
 *
 * Revision 1.5  2002/08/22 13:42:38  howama
 * more work
 *
 * Revision 1.4  2002/08/21 15:13:12  howama
 * more work
 *
 * Revision 1.3  2002/08/19 17:01:53  blsecres
 * Converted DirScanner to be an extension of FileListBuilder.
 *
 * Revision 1.2  2002/08/16 10:24:08  howama
 * New IGFile
 *
 * Revision 1.1  2002/08/08 15:33:07  howama
 * initial work
 *
 */
