/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * gui_layout.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: gui_layout.c,v 1.2 2004/01/17 07:57:15 ericprev Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gconf/gconf-client.h>

#include "gui_layout.h"
#include "misc_gtk.h"
#include "main.h"

static char *current_wprefix="Geometry/";

#define is_nonempty_string(x)		((x!=NULL)&&(strlen(x)!=0))


/* restore widget geometry according to geometry save into widget name (key) */
static void gui_restore_window_size (GtkWidget* widget, const gchar* key)
{
   gint x, y, w, h;
   GString * buf;
   gint screen_w = gdk_screen_width ();
   gint screen_h = gdk_screen_height ();
   const gint fuzz = 10;

   /* sanity clause */
   g_return_if_fail (GTK_IS_WIDGET(widget));
   g_return_if_fail (!GTK_WIDGET_REALIZED(widget));
   g_return_if_fail (is_nonempty_string(key));

   /* get the dimensions */
   buf = g_string_new (NULL);
   g_string_sprintf (buf, "/apps/" PROGNAME "/%s%s_x", current_wprefix,key);
   x = gconf_client_get_int(gconf_engine,buf->str,NULL);
   g_string_sprintf (buf, "/apps/" PROGNAME "/%s%s_y", current_wprefix,key);
   y = gconf_client_get_int(gconf_engine,buf->str,NULL);
   g_string_sprintf (buf, "/apps/" PROGNAME "/%s%s_width", current_wprefix,key);
   w = gconf_client_get_int(gconf_engine,buf->str,NULL);
   g_string_sprintf (buf, "/apps/" PROGNAME "/%s%s_height", current_wprefix,key);
   h = gconf_client_get_int(gconf_engine,buf->str,NULL);

   /* move & resize */
   if ((0<x && x<screen_w-fuzz) && (0<y && y<screen_h-fuzz))
      gtk_widget_set_uposition (widget, x, y);
   if (w>0 && h>0)
      gtk_window_set_default_size (GTK_WINDOW(widget), w, h);

   /* cleanup */
   g_string_free (buf, TRUE);
}

/* save widget geometry into widget name (key) */
static void gui_save_window_size (GtkWidget* widget, const gchar* key)
{
   GString * buf;
   gint x, y, w, h;

   /* sanity clause */
   g_return_if_fail (GTK_IS_WIDGET(widget));
   g_return_if_fail (widget->window!=NULL);
   g_return_if_fail (is_nonempty_string(key));

   buf = g_string_new (NULL);
   gdk_window_get_position (widget->window, &x, &y);
   gdk_window_get_size (widget->window, &w, &h);

   g_string_sprintf (buf, "/apps/" PROGNAME "/%s%s_x", current_wprefix,key);
   gconf_client_set_int(gconf_engine,buf->str, x,NULL);
   g_string_sprintf (buf, "/apps/" PROGNAME "/%s%s_y", current_wprefix,key);
   gconf_client_set_int(gconf_engine,buf->str, y,NULL);
   g_string_sprintf (buf, "/apps/" PROGNAME "/%s%s_width", current_wprefix,key);
   gconf_client_set_int(gconf_engine,buf->str, w,NULL);
   g_string_sprintf (buf, "/apps/" PROGNAME "/%s%s_height", current_wprefix,key);
   gconf_client_set_int(gconf_engine,buf->str, h,NULL);

   g_string_free (buf, TRUE);
}

/* restore separator position according to geometry save into widget name (key) */
static void gui_restore_hvpaned_separator_position (GtkWidget* widget, const gchar* key)
{
   gint w;
   GString * buf;

   /* sanity clause */
   g_return_if_fail (GTK_IS_WIDGET(widget));
   g_return_if_fail (!GTK_WIDGET_REALIZED(widget));
   g_return_if_fail (is_nonempty_string(key));

   /* get the dimensions */
   buf = g_string_new (NULL);
   g_string_sprintf (buf, "/apps/" PROGNAME "/%s%s_sep_pos", current_wprefix,key);
   w = gconf_client_get_int(gconf_engine,buf->str,NULL);

	if(w>0)
		gtk_paned_set_position(GTK_PANED(widget),w);

   /* cleanup */
   g_string_free (buf, TRUE);
}

/* save separator position into widget name (key) */
static void gui_save_hvpaned_separator_position (GtkWidget* widget, const gchar* key)
{
   GString * buf;
   gint w;

   /* sanity clause */
   g_return_if_fail (GTK_IS_WIDGET(widget));
   g_return_if_fail (is_nonempty_string(key));

   buf = g_string_new (NULL);
	w=gtk_paned_get_position(GTK_PANED(widget));

   g_string_sprintf (buf, "/apps/" PROGNAME "/%s%s_sep_pos", current_wprefix,key);
   gconf_client_set_int(gconf_engine,buf->str, w,NULL);

   g_string_free (buf, TRUE);
}

/* save gtk_entry content into widget name (key) */
static void gui_save_entry_content (GtkWidget* widget, const gchar* key)
{
	const gchar *cnt;

	cnt=gtk_entry_get_text(GTK_ENTRY(widget));
	if(cnt!=NULL)
	{
   	GString * buf;
   	buf = g_string_new (NULL);
   	g_string_sprintf (buf, "/apps/" PROGNAME "/%s%s_ent_cnt", current_wprefix,key);
   	gconf_client_set_string(gconf_engine,buf->str, cnt,NULL);
   	g_string_free (buf, TRUE);
	}
}

static void gui_restore_entry_content(GtkWidget* widget, const gchar* key)
{
	GString * buf;
	gchar *cnt;

  	buf = g_string_new (NULL);
  	g_string_sprintf (buf, "/apps/" PROGNAME "/%s%s_ent_cnt", current_wprefix,key);
	cnt=gconf_client_get_string(gconf_engine,buf->str,NULL);

	if(cnt)
	{
		gtk_entry_set_text(GTK_ENTRY(widget),cnt);
		g_free(cnt);
	}
}

/* restore scale value according to geometry save into widget name (key) */
static void gui_restore_scale_value (GtkWidget* widget, const gchar* key)
{
   gfloat w;
   GString * buf;

   /* sanity clause */
   g_return_if_fail (GTK_IS_WIDGET(widget));
#if 0
   g_return_if_fail (!GTK_WIDGET_REALIZED(widget));
#endif
   g_return_if_fail (is_nonempty_string(key));

   /* get the dimensions */
   buf = g_string_new (NULL);
   g_string_sprintf (buf, "/apps/" PROGNAME "/%s%s_scale_val", current_wprefix,key);
   w = gconf_client_get_float(gconf_engine,buf->str,NULL);

	gtk_adjustment_set_value(gtk_range_get_adjustment(GTK_RANGE(widget)),w);

   /* cleanup */
   g_string_free (buf, TRUE);
}

/* save scale value into widget name (key) */
static void gui_save_scale_value (GtkWidget* widget, const gchar* key)
{
   GString * buf;
	gfloat val;

   /* sanity clause */
   g_return_if_fail (GTK_IS_WIDGET(widget));
   g_return_if_fail (is_nonempty_string(key));

   buf = g_string_new (NULL);
	val=gtk_range_get_adjustment(GTK_RANGE(widget))->value;

   g_string_sprintf (buf, "/apps/" PROGNAME "/%s%s_scale_val", current_wprefix,key);
   gconf_client_set_float(gconf_engine,buf->str, val,NULL);

   g_string_free (buf, TRUE);
}

/* restore scale value according to geometry save into widget name (key) */
static void gui_restore_toggle_button (GtkWidget* widget, const gchar* key)
{
   gfloat w;
   GString * buf;

   /* sanity clause */
   g_return_if_fail (GTK_IS_WIDGET(widget));
#if 0
   g_return_if_fail (!GTK_WIDGET_REALIZED(widget));
#endif
   g_return_if_fail (is_nonempty_string(key));

   /* get the dimensions */
   buf = g_string_new (NULL);
   g_string_sprintf (buf, "/apps/" PROGNAME "/%s%s_toggle_val", current_wprefix,key);
   w = gconf_client_get_int(gconf_engine,buf->str,NULL);

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),w);

   /* cleanup */
   g_string_free (buf, TRUE);
}

/* save scale value into widget name (key) */
static void gui_save_toggle_button (GtkWidget* widget, const gchar* key)
{
   GString * buf;
	int val;

   /* sanity clause */
   g_return_if_fail (GTK_IS_WIDGET(widget));
   g_return_if_fail (is_nonempty_string(key));

   buf = g_string_new (NULL);
	val=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));

   g_string_sprintf (buf, "/apps/" PROGNAME "/%s%s_toggle_val",current_wprefix, key);
   gconf_client_set_int(gconf_engine,buf->str, val,NULL);

   g_string_free (buf, TRUE);
}

/* restore spin button value according to geometry save into widget name (key) */
static void gui_restore_spin_button (GtkWidget* widget, const gchar* key)
{
   gfloat w;
   GString * buf;

   /* sanity clause */
   g_return_if_fail (GTK_IS_WIDGET(widget));
   g_return_if_fail (is_nonempty_string(key));

   /* get the dimensions */
   buf = g_string_new (NULL);
   g_string_sprintf (buf, "/apps/" PROGNAME "/%s%s_spin_val", current_wprefix,key);
   w = gconf_client_get_float(gconf_engine,buf->str,NULL);

	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget),w);

   /* cleanup */
   g_string_free (buf, TRUE);
}

/* save spin button value into widget name (key) */
static void gui_save_spin_button (GtkWidget* widget, const gchar* key)
{
   GString * buf;
	gfloat val;

   /* sanity clause */
   g_return_if_fail (GTK_IS_WIDGET(widget));
   g_return_if_fail (is_nonempty_string(key));

   buf = g_string_new (NULL);
	val=gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget));

   g_string_sprintf (buf, "/apps/" PROGNAME "/%s%s_spin_val",current_wprefix, key);
   gconf_client_set_float(gconf_engine,buf->str, val,NULL);

   g_string_free (buf, TRUE);
}

static void gui_save_tree_view(GtkWidget* widget, const gchar* key)
{
	GList *col_lst;
	GtkTreeView *gtv;
	GtkTreeModel *gtm;
  	GString * buf;
	gint val;
	GtkSortType sort_order;

   g_return_if_fail (GTK_IS_WIDGET(widget));
   g_return_if_fail (is_nonempty_string(key));

  	buf = g_string_new (NULL);

	/* first save column sizes */
	col_lst=gtk_tree_view_get_columns(gtv=GTK_TREE_VIEW(widget));
	if(col_lst!=NULL)
	{
		int nb;
		int num_columns=0;

		nb=g_list_length(col_lst);
		while(num_columns<nb)
		{
			GtkTreeViewColumn *gtvc;

			gtvc=g_list_nth_data(col_lst,num_columns);
			val=gtk_tree_view_column_get_width(gtvc);
   		g_string_sprintf (buf, "/apps/" PROGNAME "/%s%s_col%d_width",current_wprefix, key,num_columns);
   		gconf_client_set_int(gconf_engine,buf->str, val,NULL);

			num_columns++;
		}
		
		g_list_free(col_lst);
	}

	/* then, sort column and sort order */
	gtm=gtk_tree_view_get_model(gtv);
	if(gtk_tree_sortable_get_sort_column_id(GTK_TREE_SORTABLE(gtm),&val,&sort_order)==TRUE)
	{
  		g_string_sprintf (buf, "/apps/" PROGNAME "/%s%s_sort_col",current_wprefix, key);
  		gconf_client_set_int(gconf_engine,buf->str, val,NULL);
  		g_string_sprintf (buf, "/apps/" PROGNAME "/%s%s_sort_order",current_wprefix, key);
  		gconf_client_set_int(gconf_engine,buf->str, sort_order,NULL);
	}
  	g_string_free (buf, TRUE);
}

static void gui_restore_tree_view(GtkWidget* widget, const gchar* key)
{
	GList *col_lst;
	GtkTreeView *gtv;
	GtkTreeModel *gtm;
  	GString * buf;
	gint val;
	GtkSortType sort_order;

   g_return_if_fail (GTK_IS_WIDGET(widget));
   g_return_if_fail (is_nonempty_string(key));

  	buf = g_string_new (NULL);

	/* first restore column sizes */
	col_lst=gtk_tree_view_get_columns(gtv=GTK_TREE_VIEW(widget));
	if(col_lst!=NULL)
	{
		int nb;
		int num_columns=0;

		nb=g_list_length(col_lst);
		while(num_columns<nb)
		{
			GtkTreeViewColumn *gtvc;

			gtvc=g_list_nth_data(col_lst,num_columns);
   		g_string_sprintf (buf, "/apps/" PROGNAME "/%s%s_col%d_width",current_wprefix, key,num_columns);
   		val=gconf_client_get_int(gconf_engine,buf->str,NULL);
			if(val!=0)
			{
				gtk_tree_view_column_set_sizing(gtvc,GTK_TREE_VIEW_COLUMN_FIXED);
				gtk_tree_view_column_set_fixed_width(gtvc,val);
			}

			num_columns++;
		}
		g_list_free(col_lst);
	}

  	/* then, sort column and sort order */
	gtm=gtk_tree_view_get_model(gtv);
 	g_string_sprintf (buf, "/apps/" PROGNAME "/%s%s_sort_col",current_wprefix, key);
  	val=gconf_client_get_int(gconf_engine,buf->str,NULL);
  	g_string_sprintf (buf, "/apps/" PROGNAME "/%s%s_sort_order",current_wprefix, key);
  	sort_order=gconf_client_get_int(gconf_engine,buf->str,NULL);
	gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(gtm),val,sort_order);

	g_string_free (buf, TRUE);
}


static void recursive_gui_restore(GtkWidget *widget, gpointer dummy)
{
	const gchar *name=NULL;

	if(GTK_IS_WINDOW(widget))
	{
		name=get_name_of_a_widget(widget);
		if(name!=NULL)
			gui_restore_window_size(widget,name);
	}
	else if(GTK_IS_VPANED(widget)||(GTK_IS_HPANED(widget)))
	{
		name=get_name_of_a_widget(widget);
		if(name!=NULL)
			gui_restore_hvpaned_separator_position(widget,name);
	}
	else if(GTK_IS_SPIN_BUTTON(widget))	/* this test must be before the GTK_IS_ENTRY one */
	{
		name=get_name_of_a_widget(widget);
		if(name!=NULL)
			gui_restore_spin_button(widget,name);
	}
	else if(GTK_IS_ENTRY(widget))
	{
		name=get_name_of_a_widget(widget);
		if(name!=NULL)
			gui_restore_entry_content(widget,name);
	}
	else if(GTK_IS_SCALE(widget))
	{
		name=get_name_of_a_widget(widget);
		if(name!=NULL)
			gui_restore_scale_value(widget,name);
	}
	else if(
				(GTK_IS_RADIO_BUTTON(widget))||
				(GTK_IS_CHECK_BUTTON(widget))||
				(GTK_IS_TOGGLE_BUTTON(widget)) )
	{
		name=get_name_of_a_widget(widget);
		if(name!=NULL)
			gui_restore_toggle_button(widget,name);
	}
	else if(GTK_IS_TREE_VIEW(widget))
	{
		name=get_name_of_a_widget(widget);
		if(name!=NULL)
			gui_restore_tree_view(widget,name);
	}
	
	if(!GTK_IS_ENTRY(widget)&&
		!GTK_IS_LABEL(widget)&&
		!GTK_IS_PROGRESS_BAR(widget)&&
		!GTK_IS_HSEPARATOR(widget)&&
#if 0
		!GTK_IS_TEXT(widget)&&
		!GNOME_IS_STOCK(widget)&&
#endif
		!GTK_IS_SPIN_BUTTON(widget)&&
		!GTK_IS_IMAGE(widget)&&
		!GTK_IS_DRAWING_AREA(widget)&&
		!GTK_IS_TREE_VIEW(widget)&&
		!BONOBO_IS_DOCK_ITEM(widget)&&
		!GTK_IS_HSCALE(widget)&&
		!GTK_IS_PIXMAP(widget)&&
		!GTK_IS_ARROW(widget))
		gtk_container_foreach(GTK_CONTAINER(widget),recursive_gui_restore,NULL);
}

/*************************************************************************/
/* the following functions save/restore the geometry of the given widget */
/* and all its childs                                                    */
/*************************************************************************/
void gui_full_restore(GtkWidget *widget, char *prefix)
{
	if(prefix==NULL)
		current_wprefix="Geometry/";
	else
		current_wprefix=prefix;

	recursive_gui_restore(widget,NULL);
}

static void recursive_gui_save(GtkWidget *widget, gpointer dummy)
{
	const gchar *name=NULL;

	if(GTK_IS_WINDOW(widget))
	{
		name=get_name_of_a_widget(widget);
		if(name!=NULL)
			gui_save_window_size(widget,name);
	}
	else if(GTK_IS_VPANED(widget)||(GTK_IS_HPANED(widget)))
	{
		name=get_name_of_a_widget(widget);
		if(name!=NULL)
			gui_save_hvpaned_separator_position(widget,name);
	}
	else if(GTK_IS_SPIN_BUTTON(widget))	/* this test must be before the GTK_IS_ENTRY one */
	{
		name=get_name_of_a_widget(widget);
		if(name!=NULL)
			gui_save_spin_button(widget,name);
	}
	else if(GTK_IS_ENTRY(widget))
	{
		name=get_name_of_a_widget(widget);
		if(name!=NULL)
			gui_save_entry_content(widget,name);
	}
	else if(GTK_IS_SCALE(widget))
	{
		name=get_name_of_a_widget(widget);
		if(name!=NULL)
			gui_save_scale_value(widget,name);
	}
	else if(
				(GTK_IS_RADIO_BUTTON(widget))||
				(GTK_IS_CHECK_BUTTON(widget))||
				(GTK_IS_TOGGLE_BUTTON(widget)) )
	{
		name=get_name_of_a_widget(widget);
		if(name!=NULL)
			gui_save_toggle_button(widget,name);
	}
	else if(GTK_IS_TREE_VIEW(widget))
	{
		name=get_name_of_a_widget(widget);
		if(name!=NULL)
			gui_save_tree_view(widget,name);
	}
		
	
	if(!GTK_IS_ENTRY(widget)&&
		!GTK_IS_LABEL(widget)&&
		!GTK_IS_PROGRESS_BAR(widget)&&
		!GTK_IS_HSEPARATOR(widget)&&
#if 0
		!GTK_IS_TEXT(widget)&&
		!GNOME_IS_STOCK(widget)&&
#endif
		!GTK_IS_SPIN_BUTTON(widget)&&
		!GTK_IS_IMAGE(widget)&&
		!GTK_IS_DRAWING_AREA(widget)&&
		!GTK_IS_TREE_VIEW(widget)&&
		!BONOBO_IS_DOCK_ITEM(widget)&&
		!GTK_IS_HSCALE(widget)&&
		!GTK_IS_PIXMAP(widget)&&
		!GTK_IS_ARROW(widget))
		gtk_container_foreach(GTK_CONTAINER(widget),recursive_gui_save,NULL);
}

/***********************************************************************************************************/
/* the following functions save/restore the geometry of the given widget                                   */
/* and all its childs                                                                                      */
/* the prefix can be NULL (main geometry ="Geometry/") or "Profile/xxxxx/" (where xxxxx is a profile name) */
/***********************************************************************************************************/
void gui_full_save(GtkWidget *widget,char *prefix)
{
	if(prefix==NULL)
		current_wprefix="Geometry/";
	else
		current_wprefix=prefix;

	recursive_gui_save(widget,NULL);
}

