/*  
    lpc_import.c

    Copyright (C) 1995 John ffitch

    This file is part of Csound.

    Csound is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Csound is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Csound; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/* ***************************************************************** */
/* ******** Program to import lpanal files from tabular format. **** */
/* ***************************************************************** */

/* ***************************************************************** */
/* John ffitch 1996 Dec 27                                           */
/* ***************************************************************** */
     
#include <stdio.h>
#include <stdlib.h>
#include "lpc.h"

void usage(void);

float getnum(FILE* inf, char *term)
{
    char buff[100];
    int  cc;
    int p = 0;
    while ((cc=getc(inf))!=',' && cc!='\n') buff[p++] = cc;
    buff[p]='\0';
    *term = cc;
    return (float)atof(buff);
}

int main(int argc, char **argv)
{
    FILE *infd;
    FILE *outf;
    LPHEADER hdr;
    int i,j;

    if (argc!= 3)
	usage();

    infd = fopen(argv[1], "r");
    if (infd == NULL) {
	fprintf(stderr, "Cannot open input comma file%s\n", argv[1]);
	exit(1);
    }
    outf = fopen(argv[2], "w");
    if (infd == NULL) {
	fprintf(stderr, "Cannot open output lpanal file %s\n", argv[2]);
	exit(1);
    }

    fscanf(infd, "%ld,%ld,%ld,%ld,%f,%f,%f",
	    &hdr.headersize, &hdr.lpmagic, &hdr.npoles, &hdr.nvals,
	    &hdr.framrate, &hdr.srate, &hdr.duration);
    for (i=0; i<hdr.headersize-sizeof(LPHEADER)+4; i++)
      hdr.text[i]=getc(infd);
    fwrite(&hdr, sizeof(LPHEADER), 1, outf);
    while (getc(infd)!= '\n');

    for (i = 0; i<hdr.nvals; i++) {
      for (j=0; j<hdr.npoles; j++) {
	char term;
	float coef = getnum(infd, &term);
	fwrite(&coef, 1, sizeof(float), outf);
	if (term!=',' && term!='\n') fprintf(stderr, "Sync error\n");
      }
    }
    fclose(outf);
    fclose(infd);
}

void usage(void)
{
    fprintf(stderr, "Usage: lpc_import commafile lpanalfile\n");
    exit(1);
}

