/* common.transpostions.rectangular.h - common rectangular tranpositions header file
 * 
 * This program is part of Crank, a cryptanalysis tool
 * Copyright (C) 2000 Matthew Russell
 *
 * This program is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License (LICENSE) for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

#ifndef H_COMMON_TRANSPOSITIONS_RECTANGULAR
#define H_COMMON_TRANSPOSITIONS_RECTANGULAR

#define NULL_CHARACTER '#'

typedef char* Grid;

typedef int gridpath;

#define HORIZONTALS_STRAIGHT_TL     1
#define HORIZONTALS_STRAIGHT_BL     2
#define HORIZONTALS_REVERSE_TR      3
#define HORIZONTALS_REVERSE_BR      4
#define	HORIZONTALS_ALTERNATE_TL    5
#define	HORIZONTALS_ALTERNATE_TR    6
#define	HORIZONTALS_ALTERNATE_BR    7
#define	HORIZONTALS_ALTERNATE_BL    8

#define	VERTICALS_DESCENDING_TL     9
#define	VERTICALS_DESCENDING_TR     10
#define	VERTICALS_ASCENDING_BL      11
#define	VERTICALS_ASCENDING_BR      12
#define	VERTICALS_ALTERNATE_TL      13
#define	VERTICALS_ALTERNATE_TR      14
#define	VERTICALS_ALTERNATE_BR      15
#define	VERTICALS_ALTERNATE_BL      16

#define SPIRAL_CLOCKWISE_IN_TL      17
#define SPIRAL_CLOCKWISE_IN_TR      18
#define SPIRAL_CLOCKWISE_IN_BR      19
#define SPIRAL_CLOCKWISE_IN_BL      20

#define SPIRAL_ANTICLOCKWISE_IN_TL  21
#define SPIRAL_ANTICLOCKWISE_IN_TR  22
#define SPIRAL_ANTICLOCKWISE_IN_BR  23
#define SPIRAL_ANTICLOCKWISE_IN_BL  24

#define SPIRAL_CLOCKWISE_OUT_TL     25
#define SPIRAL_CLOCKWISE_OUT_TR     26
#define SPIRAL_CLOCKWISE_OUT_BR     27
#define SPIRAL_CLOCKWISE_OUT_BL     28

#define SPIRAL_ANTICLOCKWISE_OUT_TL 29
#define SPIRAL_ANTICLOCKWISE_OUT_TR 30
#define SPIRAL_ANTICLOCKWISE_OUT_BR 31
#define SPIRAL_ANTICLOCKWISE_OUT_BL 32

#define MAX_GRIDPATH                32 /* Should be last number from above */
#define MAX_GRIDPATH_ARRAY          33 /* Should be one more than MAX_GRIDPATH */

extern const char *grid_path_names[MAX_GRIDPATH_ARRAY];

Grid make_new_grid(int rows, int cols, char *text, gridpath path); /* Makes a new grid - text must contain rows * cols text */
char *extract_from_grid(Grid grid, int rows, int cols, gridpath path);
void free_grid(Grid grid);
char *transform_with_grid(int rows, int cols, char *text, gridpath writepath, gridpath readpath);

#endif
