use Language::INTERCAL;
use Language::INTERCAL::Runtime::Library;

my $prog = '
@z@L`@{@@{
@z@L`@{@@{
@@z@L`@{
@@@z
@@@z
@@@z
@z@L`@{@@{
@@@z
@z@L`@z
@@@z
@z@L`@z
@@@z
M]@@K@L`@zJ{{J{
@@@K
@@
';

print "1..54\n";

fiddle Language::INTERCAL 'bug=0', 'ubug=0';

my @foo;

compile Language::INTERCAL 'prog', $prog;
@foo= ();
eval { prog(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 1\n";
print @foo == 7 ? "" : "not ", "ok 2\n";
print "VII\n" eq (shift @foo) ? "" : "not ", "ok 3\n";
print "XV\n" eq (shift @foo) ? "" : "not ", "ok 4\n";
print "xxxiiiXXIII\n" eq (shift @foo) ? "" : "not ", "ok 5\n";
print "CCLV\n" eq (shift @foo) ? "" : "not ", "ok 6\n";
print "\\M\\M\\C\\X\\L\\V\\I\\IcdlxxxiiiCMIII\n" eq (shift @foo)
	? "" : "not ", "ok 7\n";
print "\\M\\M\\M\\C\\C\\X\\X\\IccxxvDCCXXVII\n" eq (shift @foo)
	? "" : "not ", "ok 8\n";
print "MXXIII\n" eq (shift @foo) ? "" : "not ", "ok 9\n";

compile Language::INTERCAL 'prog_o', $prog, 'opt';
@foo= ();
eval { prog_o(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 10\n";
print @foo == 7 ? "" : "not ", "ok 11\n";
print "VII\n" eq (shift @foo) ? "" : "not ", "ok 12\n";
print "XV\n" eq (shift @foo) ? "" : "not ", "ok 13\n";
print "xxxiiiXXIII\n" eq (shift @foo) ? "" : "not ", "ok 14\n";
print "CCLV\n" eq (shift @foo) ? "" : "not ", "ok 15\n";
print "\\M\\M\\C\\X\\L\\V\\I\\IcdlxxxiiiCMIII\n" eq (shift @foo)
	? "" : "not ", "ok 16\n";
print "\\M\\M\\M\\C\\C\\X\\X\\IccxxvDCCXXVII\n" eq (shift @foo)
	? "" : "not ", "ok 17\n";
print "MXXIII\n" eq (shift @foo) ? "" : "not ", "ok 18\n";

compile Language::INTERCAL 'prog_q', $prog, 'quantum';
@foo= ();
eval { prog_q(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 19\n";
print @foo == 7 ? "" : "not ", "ok 20\n";
print "VII\n" eq (shift @foo) ? "" : "not ", "ok 21\n";
print "XV\n" eq (shift @foo) ? "" : "not ", "ok 22\n";
print "xxxiiiXXIII\n" eq (shift @foo) ? "" : "not ", "ok 23\n";
print "CCLV\n" eq (shift @foo) ? "" : "not ", "ok 24\n";
print "\\M\\M\\C\\X\\L\\V\\I\\IcdlxxxiiiCMIII\n" eq (shift @foo)
	? "" : "not ", "ok 25\n";
print "\\M\\M\\M\\C\\C\\X\\X\\IccxxvDCCXXVII\n" eq (shift @foo)
	? "" : "not ", "ok 26\n";
print "MXXIII\n" eq (shift @foo) ? "" : "not ", "ok 27\n";

compile Language::INTERCAL 'prog_p', $prog, 'post';
@foo= ();
eval { prog_p(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 28\n";
print @foo == 7 ? "" : "not ", "ok 29\n";
print "VII\n" eq (shift @foo) ? "" : "not ", "ok 30\n";
print "XV\n" eq (shift @foo) ? "" : "not ", "ok 31\n";
print "xxxiiiXXIII\n" eq (shift @foo) ? "" : "not ", "ok 32\n";
print "CCLV\n" eq (shift @foo) ? "" : "not ", "ok 33\n";
print "\\M\\M\\C\\X\\L\\V\\I\\IcdlxxxiiiCMIII\n" eq (shift @foo)
	? "" : "not ", "ok 34\n";
print "\\M\\M\\M\\C\\C\\X\\X\\IccxxvDCCXXVII\n" eq (shift @foo)
	? "" : "not ", "ok 35\n";
print "MXXIII\n" eq (shift @foo) ? "" : "not ", "ok 36\n";

compile Language::INTERCAL 'prog_qp', $prog, 'quantum', 'post';
@foo= ();
eval { prog_qp(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 37\n";
print @foo == 7 ? "" : "not ", "ok 38\n";
print "VII\n" eq (shift @foo) ? "" : "not ", "ok 39\n";
print "XV\n" eq (shift @foo) ? "" : "not ", "ok 40\n";
print "xxxiiiXXIII\n" eq (shift @foo) ? "" : "not ", "ok 41\n";
print "CCLV\n" eq (shift @foo) ? "" : "not ", "ok 42\n";
print "\\M\\M\\C\\X\\L\\V\\I\\IcdlxxxiiiCMIII\n" eq (shift @foo)
	? "" : "not ", "ok 43\n";
print "\\M\\M\\M\\C\\C\\X\\X\\IccxxvDCCXXVII\n" eq (shift @foo)
	? "" : "not ", "ok 44\n";
print "MXXIII\n" eq (shift @foo) ? "" : "not ", "ok 45\n";

compile Language::INTERCAL 'prog_d', $prog, 'dbhook';
@foo = ();
_run_db(prog_d(0, \&foo));
print STDERR $@;
print $@ ? "not " : "", "ok 46\n";
print @foo == 7 ? "" : "not ", "ok 47\n";
print "VII\n" eq (shift @foo) ? "" : "not ", "ok 48\n";
print "XV\n" eq (shift @foo) ? "" : "not ", "ok 49\n";
print "xxxiiiXXIII\n" eq (shift @foo) ? "" : "not ", "ok 50\n";
print "CCLV\n" eq (shift @foo) ? "" : "not ", "ok 51\n";
print "\\M\\M\\C\\X\\L\\V\\I\\IcdlxxxiiiCMIII\n" eq (shift @foo)
	? "" : "not ", "ok 52\n";
print "\\M\\M\\M\\C\\C\\X\\X\\IccxxvDCCXXVII\n" eq (shift @foo)
	? "" : "not ", "ok 53\n";
print "MXXIII\n" eq (shift @foo) ? "" : "not ", "ok 54\n";

sub foo {
    push @foo, join('', @_);
}

