;;;; test-infrastructure.scm - Test-macros and support code
;;;; Copyright (c) Peter K. Keller 2002
;;;; Written by Peter K. Keller (psilord@cs.wisc.edu) for use with the CHICKEN
;;;; scheme compiler and whoever else wants to use it. Just please include this
;;;; little paragraph in any source code derived from the original. This
;;;; source code is free to use for any purpose, but no warranty or guarantee 
;;;; to its stability or robustness is implied in any way. You may not hold me 
;;;; or anyone else liable for any use of this source code. Please try to keep 
;;;; this source code as close to R5RS(or later) scheme as possible. Thank you.

;; This file is strictly a loader file that loads the common testing
;; infrastructure code plus any local definition specific to the implementation.
;; For chicken, this cond-expands on hygienic macros and loads either the
;; R5RS compliant version, or the low level define-macro version depending
;; on how the interpreter/compiler was invoked.

;; This uses srfi-0 and chicken's specific file loading 'include' function.
(cond-expand 
	
	(hygienic-macros
		;; load the hygienic common/base feature set of the test infrastructure.
		(include "test-infrastructure-hygienic.scm")

		;; load any specific test infrastructure macros this specific
		;; implementation requires.
		(include "test-infrastructure-hygienic-local.scm"))

	(else
		;; load the lowlevel common/base feature set of the test infrastructure.
		;; (include "test-infrastructure-lowlevel.scm")

		;; load any specific test infrastructure macros this specific
		;; implementation requires.
		;; (include "test-infrastructure-lowlevel-local.scm")

		(print "Low level macro implementation of the test infrastructure")
		(print "is not available yet! Please use -hygienic to enable use")
		(print "of this testing infrastructure. Thank you!")))
