;;;; srfi-13-syntax.scm - Macro definitions for SRFI-13

;;; This macro parses optional start/end arguments from arg lists, defaulting
;;; them to 0/(string-length s), and checks them for correctness.


(cond-expand [(and hygienic-macros srfi-8)

(define-syntax let-string-start+end
  (syntax-rules ()
    ((let-string-start+end (start end) proc s-exp args-exp body ...)
     (receive (start end) (string-parse-final-start+end proc s-exp args-exp)
       body ...))
    ((let-string-start+end (start end rest) proc s-exp args-exp body ...)
     (receive (rest start end) (string-parse-start+end proc s-exp args-exp)
       body ...))))

][srfi-8

(eval-when (compile eval)
  (define-macro (let-string-start+end s-e-r proc s-exp args-exp . body)
    (if (pair? (cddr s-e-r))
	`(receive (,(caddr s-e-r) ,(car s-e-r) ,(cadr s-e-r))
	     (string-parse-start+end ,proc ,s-exp ,args-exp)
	   ,@body)
	`(receive ,s-e-r
	     (string-parse-final-start+end ,proc ,s-exp ,args-exp)
	   ,@body) ) ) )

])
