#!/bin/sh

echo 
echo -----------------------------------------------------------
echo 
echo Make sure that you are in a Cygwin bash shell, and that you
echo have defined the PATH so that the MinGW binaries come before
echo the Cygwin binaries.
echo
echo You won\'t need to update the PATH if you installed MinGW in
echo its default location "("which is C:\\MinGW")".  If you 
echo installed MinGW into, say, C:\\Some\\Other\\Dir, then you 
echo must type
echo \ \ export PATH=/cygdrive/c/Some/Other/Dir/bin:\$PATH
echo after starting Cygwin.
echo 
echo Run this command again if you haven\'t done the above!
echo
echo -----------------------------------------------------------
echo 

TOPDIR=$(cygpath -au $(dirname $0)/..)
cd $TOPDIR

PATH=/cygdrive/c/MinGW/bin:$PATH
export PATH

aclocal
autoheader
libtoolize --force --copy
automake --foreign --add-missing --copy
autoconf
