/* undo.h
 * 
 * This program is distributed under the GNU General Public License.
 * Copyright (C) 2000 Eugene Osintsev <gene@linuxave.net>
 */

#ifndef _UNDO_H_
#define _UNDO_H_

/* Undo initialization. */
int init_undo(struct CFE_FONT *font);

/* Free memory allocated for undo operations. */
void free_undo();

/* Restores glyph rows and cursor coordinates.
 * Returns 0 if nothing to undo.
 */
int get_undo(struct CFE_GLYPH *glyph);

/* Store glyph rows and cursor coordinates.
 */
void put_undo(struct CFE_GLYPH *glyph);

/* Returns non-zero if the file is modified. */
int file_modified();

/* Called after the file has been saved. */
void clear_file_modified();

/* Returns non-zero if the glyph is modified. */
int glyph_modified(int glyph_num);


#endif  /* _UNDO_H_ */


/* EOF */
