/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2001-2002 The Caudium Group
 * Copyright  2001 Davies, Inc
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: skimmer.pike,v 1.1.2.1 2002/07/08 23:43:12 kiwi Exp $
 */
#include <module.h>

inherit "module";
inherit "caudiumlib";

//! module: Skimmer Module
//!  This module will take a configurable percentage of the incoming requests
//!  for an .html doc and redirect them to a different URL.<br />Based on 
//!  Chris Davies <a href="http://www.daviesinc.com/modules/">module.</a>
//! type: MODULE_FIRST
//! inherits: module
//! inherits: caudiumlib
//! cvs_version: $Id: skimmer.pike,v 1.1.2.1 2002/07/08 23:43:12 kiwi Exp $

constant module_type = MODULE_FIRST;
constant module_name = "Skimmer Module";
constant module_doc  = "This module will take a configurable percentage "
                       "of the incoming requests for an .html doc and "
                       "redirect them to a different URL.<br /> Based on "
                       "Chris Davies <a href=\"http://www.daviesinc.com/"
                       "modules/\">module.</a>";
constant module_unique = 1;
constant thread_safe = 1;
constant cvs_version = "$Id: skimmer.pike,v 1.1.2.1 2002/07/08 23:43:12 kiwi Exp $";

object incl=0,excl=0;
int redirected=0,passed=0;

void create() {
  defvar("skim", 5, "Skim %", TYPE_INT,
         "This will take x% of the incoming requests for an .html doc and redirect them to a different URL");
  defvar("topdir", 0, "Skim Top Directory?", TYPE_FLAG,
         "Do you want to skim traffic from the top directory?");
  defvar("redirecturl", "NONE/", "Where are we sending the traffic?", TYPE_STRING,
         "");
  defvar("regexpinclude", "\.(htm|html|shtml|rxml)$|/$",
         "Regexp Include Specification", TYPE_STRING,
         "An expression here will include processing for anything that matches this Pike Syntax Regexp<br>"
         "For Example:<br>.*<br>will include processing for all files.  id->not_query is automatically "
         "lowercased."
         "<br>"
         "\\.(htm|html|shtml|rxml)$|/$");
  defvar("regexpexclude", "\.(jpg|jpeg|gif|png)$|^/_internal",
         "Regexp Exclude Specification", TYPE_STRING,
         "An expression here will exclude processing for anything that matches this Pike Syntax Regexp<br>"
         "For Example:<br>\\.(jpg|jpeg|gif|png)$|^/_internal <br>will exclude processing for jpg, gif and png files "
         "id->not_query is automatically lowercased");
}

void start(int num, object conf) {
  catch {
    if (strlen(query("regexpinclude")))
      incl = Regexp(query("regexpinclude"));
    if (strlen(query("regexpexclude")))
      excl = Regexp(query("regexpexclude"));
  };
}


string status() {
  return (sprintf("%d redirected, %d passed. %3.2f%% of the traffic is being redirected",
                  redirected,passed,(passed>0)?(float)redirected/((float)passed+(float)redirected)*100.0:0.0));
}

mapping first_try(object id) {

  if (QUERY(topdir)==0 && String.count(id->not_query,"/")<2)
    return 0;

//perror("match: "+id->not_query+" "+incl->match(lower_case(id->not_query))+"\n");
//perror("exclude: "+excl->match(lower_case(id->not_query))+"\n");
  if (id->not_query && (incl && !incl->match(lower_case(id->not_query))) ||
      (excl &&  excl->match(lower_case(id->not_query))))
    return(0);

  if (random(100) < QUERY(skim)) {
    redirected++;
    return http_redirect(QUERY(redirecturl));
  }

  passed++;
  return 0;
}

/* START AUTOGENERATED DEFVAR DOCS */

//! defvar: skim
//! This will take x% of the incoming requests for an .html doc and redirect them to a different URL
//!  type: TYPE_INT
//!  name: Skim %
//
//! defvar: topdir
//! Do you want to skim traffic from the top directory?
//!  type: TYPE_FLAG
//!  name: Skim Top Directory?
//
//! defvar: redirecturl
//!  type: TYPE_STRING
//!  name: Where are we sending the traffic?
//
//! defvar: regexpinclude
//! An expression here will include processing for anything that matches this Pike Syntax Regexp<br />For Example:<br />.*<br />will include processing for all files.  id->not_query is automatically lowercased.<br />\.(htm|html|shtml|rxml)$|/$
//!  type: TYPE_STRING
//!  name: Regexp Include Specification
//
//! defvar: regexpexclude
//! An expression here will exclude processing for anything that matches this Pike Syntax Regexp<br />For Example:<br />\.(jpg|jpeg|gif|png)$|^/_internal <br />will exclude processing for jpg, gif and png files id->not_query is automatically lowercased
//!  type: TYPE_STRING
//!  name: Regexp Exclude Specification
//
