type concrstx =
    RawStr of string
  | IStr of string
  | Var of string
  | Block of concrstx list
  | Valign of concrstx list
  | Halign of concrstx list
  | Indent of concrstx

val sqlquote : string -> string

val pp_concr : int -> (string, string) Hashtbl.t option -> concrstx -> string

val make_pp_query : Sqlstx.query -> concrstx
val make_pp_ordering : Sqlstx.ordering -> concrstx
val make_pp_column : Sqlstx.column -> concrstx
val make_pp_query_exp : Sqlstx.query_exp -> concrstx
val make_pp_select : Sqlstx.select -> concrstx
val make_pp_selection : Sqlstx.selection -> concrstx
val make_pp_from : Sqlstx.from -> concrstx
val make_pp_groupby : Sqlstx.group_by -> concrstx
val make_pp_condition : Sqlstx.where -> concrstx
val make_pp_pred : Sqlstx.predicate -> concrstx
val make_pp_comp : Sqlstx.comparison -> concrstx
val make_pp_exp : Sqlstx.exp -> concrstx
val make_pp_atom : Sqlstx.atom -> concrstx
val make_pp_functioncall : Sqlstx.functioncall -> concrstx
val make_pp_function_label : Sqlstx.function_label -> concrstx
val make_pp_parameter : Sqlstx.parameter -> concrstx

val make_pp_full_select : Sqlstx.select * Sqlstx.ordering list -> concrstx
