type token =
    IDENT of ( string )
  | STRING of ( string )
  | INTNUM of ( [`int of int | `inttoomuch of string] )
  | FLOATNUM of ( [`float of int * int * float | `floattoomuch of string] )
  | COMPARISON of ( Sqlstx.comparison )
  | ALL
  | ANY
  | AS
  | ASC
  | AUTHORIZATION
  | BETWEEN
  | BY
  | CHARACTER
  | CHECK
  | CLOSE
  | COMMIT
  | CONTINUE
  | CREATE
  | CURRENT
  | CURSOR
  | DECIMAL
  | DECLARE
  | DEFAULT
  | DELETE
  | DESC
  | DISTINCT
  | DOUBLE
  | ESCAPE
  | EXISTS
  | FETCH
  | FLOAT
  | FOR
  | FOREIGN
  | FOUND
  | FROM
  | GOTO
  | GRANT
  | GROUP
  | HAVING
  | IN
  | INDICATOR
  | INSERT
  | INTEGER
  | INTO
  | IS
  | KEY
  | LANGUAGE
  | LIKE
  | MODULE
  | NULL
  | NUMERIC
  | OF
  | ON
  | OPEN
  | OPTION
  | ORDER
  | PRECISION
  | PRIMARY
  | PRIVILEGES
  | PROCEDURE
  | PUBLIC
  | REAL
  | REFERENCES
  | ROLLBACK
  | SCHEMA
  | SELECT
  | SET
  | SMALLINT
  | SOME
  | SQLCODE
  | SQLERROR
  | TABLE
  | TO
  | UNION
  | UNIQUE
  | UPDATE
  | USER
  | VALUES
  | VIEW
  | WHENEVER
  | WHERE
  | WITH
  | WORK
  | COBOL
  | FORTRAN
  | PASCAL
  | PLI
  | C
  | ADA
  | OCAML
  | AVG
  | MIN
  | MAX
  | SUM
  | COUNT
  | COLON
  | LPAREN
  | RPAREN
  | COMMA
  | DOT
  | SEMICOLON
  | OR
  | AND
  | NOT
  | PLUS
  | MINUS
  | TIMES
  | DIV
  | EOF

open Parsing
# 2 "parser.mly"
  open Sqlstx
  open Helper_lp
  open Printf
  open Parsing

  let parse_error s = (err ())#error s

  let normal_int = function `int i -> i | _ -> parse_error "absurd integer"

(* #load "parser.cmo" #load "lexer.cmo"; open Parser open Lexer;; *)
(* Line 14, file parser.ml *)
let yytransl_const = [|
  262 (* ALL *);
  263 (* ANY *);
  264 (* AS *);
  265 (* ASC *);
  266 (* AUTHORIZATION *);
  267 (* BETWEEN *);
  268 (* BY *);
  269 (* CHARACTER *);
  270 (* CHECK *);
  271 (* CLOSE *);
  272 (* COMMIT *);
  273 (* CONTINUE *);
  274 (* CREATE *);
  275 (* CURRENT *);
  276 (* CURSOR *);
  277 (* DECIMAL *);
  278 (* DECLARE *);
  279 (* DEFAULT *);
  280 (* DELETE *);
  281 (* DESC *);
  282 (* DISTINCT *);
  283 (* DOUBLE *);
  284 (* ESCAPE *);
  285 (* EXISTS *);
  286 (* FETCH *);
  287 (* FLOAT *);
  288 (* FOR *);
  289 (* FOREIGN *);
  290 (* FOUND *);
  291 (* FROM *);
  292 (* GOTO *);
  293 (* GRANT *);
  294 (* GROUP *);
  295 (* HAVING *);
  296 (* IN *);
  297 (* INDICATOR *);
  298 (* INSERT *);
  299 (* INTEGER *);
  300 (* INTO *);
  301 (* IS *);
  302 (* KEY *);
  303 (* LANGUAGE *);
  304 (* LIKE *);
  305 (* MODULE *);
  306 (* NULL *);
  307 (* NUMERIC *);
  308 (* OF *);
  309 (* ON *);
  310 (* OPEN *);
  311 (* OPTION *);
  312 (* ORDER *);
  313 (* PRECISION *);
  314 (* PRIMARY *);
  315 (* PRIVILEGES *);
  316 (* PROCEDURE *);
  317 (* PUBLIC *);
  318 (* REAL *);
  319 (* REFERENCES *);
  320 (* ROLLBACK *);
  321 (* SCHEMA *);
  322 (* SELECT *);
  323 (* SET *);
  324 (* SMALLINT *);
  325 (* SOME *);
  326 (* SQLCODE *);
  327 (* SQLERROR *);
  328 (* TABLE *);
  329 (* TO *);
  330 (* UNION *);
  331 (* UNIQUE *);
  332 (* UPDATE *);
  333 (* USER *);
  334 (* VALUES *);
  335 (* VIEW *);
  336 (* WHENEVER *);
  337 (* WHERE *);
  338 (* WITH *);
  339 (* WORK *);
  340 (* COBOL *);
  341 (* FORTRAN *);
  342 (* PASCAL *);
  343 (* PLI *);
  344 (* C *);
  345 (* ADA *);
  346 (* OCAML *);
  347 (* AVG *);
  348 (* MIN *);
  349 (* MAX *);
  350 (* SUM *);
  351 (* COUNT *);
  352 (* COLON *);
  353 (* LPAREN *);
  354 (* RPAREN *);
  355 (* COMMA *);
  356 (* DOT *);
  357 (* SEMICOLON *);
  358 (* OR *);
  359 (* AND *);
  360 (* NOT *);
  361 (* PLUS *);
  362 (* MINUS *);
  363 (* TIMES *);
  364 (* DIV *);
    0 (* EOF *);
    0|]

let yytransl_block = [|
  257 (* IDENT *);
  258 (* STRING *);
  259 (* INTNUM *);
  260 (* FLOATNUM *);
  261 (* COMPARISON *);
    0|]

let yylhs = "\255\255\
\005\000\001\000\004\000\008\000\008\000\006\000\006\000\006\000\
\010\000\010\000\009\000\012\000\012\000\013\000\015\000\019\000\
\019\000\020\000\020\000\021\000\022\000\016\000\016\000\011\000\
\011\000\011\000\024\000\024\000\024\000\024\000\024\000\024\000\
\024\000\024\000\024\000\024\000\014\000\014\000\025\000\025\000\
\025\000\028\000\028\000\028\000\027\000\027\000\027\000\027\000\
\031\000\031\000\031\000\031\000\031\000\031\000\029\000\029\000\
\017\000\017\000\032\000\032\000\026\000\026\000\018\000\018\000\
\023\000\023\000\023\000\023\000\023\000\033\000\033\000\033\000\
\033\000\033\000\033\000\033\000\034\000\034\000\035\000\035\000\
\036\000\036\000\041\000\041\000\037\000\037\000\038\000\038\000\
\038\000\038\000\042\000\042\000\039\000\043\000\043\000\043\000\
\040\000\030\000\002\000\002\000\044\000\046\000\046\000\047\000\
\047\000\048\000\048\000\003\000\049\000\051\000\051\000\052\000\
\052\000\053\000\053\000\053\000\003\000\054\000\057\000\057\000\
\058\000\058\000\061\000\059\000\062\000\062\000\062\000\062\000\
\062\000\062\000\062\000\062\000\062\000\062\000\062\000\062\000\
\062\000\062\000\063\000\063\000\064\000\064\000\064\000\064\000\
\064\000\064\000\064\000\064\000\064\000\060\000\060\000\060\000\
\060\000\060\000\065\000\065\000\045\000\045\000\050\000\055\000\
\066\000\066\000\056\000\069\000\069\000\067\000\067\000\067\000\
\070\000\070\000\071\000\071\000\071\000\071\000\071\000\068\000\
\068\000\072\000\072\000\003\000\073\000\074\000\074\000\078\000\
\075\000\075\000\075\000\075\000\075\000\075\000\075\000\076\000\
\076\000\079\000\079\000\080\000\081\000\007\000\007\000\082\000\
\082\000\083\000\083\000\084\000\084\000\084\000\077\000\077\000\
\085\000\086\000\088\000\088\000\087\000\087\000\090\000\090\000\
\003\000\089\000\089\000\089\000\089\000\089\000\089\000\089\000\
\089\000\089\000\089\000\089\000\091\000\092\000\093\000\094\000\
\095\000\096\000\097\000\098\000\099\000\102\000\102\000\103\000\
\103\000\100\000\101\000\101\000\104\000\003\000\003\000\105\000\
\105\000\000\000\000\000\000\000\000\000\000\000"

let yylen = "\002\000\
\001\000\003\000\003\000\001\000\001\000\001\000\003\000\004\000\
\001\000\003\000\004\000\001\000\001\000\004\000\002\000\001\000\
\003\000\001\000\003\000\001\000\002\000\000\000\001\000\000\000\
\001\000\001\000\003\000\003\000\003\000\003\000\002\000\002\000\
\001\000\001\000\001\000\003\000\001\000\003\000\001\000\001\000\
\001\000\001\000\002\000\003\000\004\000\005\000\005\000\004\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\000\000\003\000\001\000\003\000\001\000\003\000\000\000\002\000\
\003\000\003\000\002\000\003\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\003\000\005\000\006\000\005\000\
\005\000\004\000\000\000\002\000\004\000\003\000\006\000\005\000\
\006\000\005\000\001\000\003\000\006\000\001\000\001\000\001\000\
\004\000\002\000\002\000\003\000\005\000\004\000\001\000\001\000\
\003\000\001\000\001\000\001\000\005\000\000\000\001\000\001\000\
\002\000\001\000\001\000\001\000\001\000\006\000\001\000\003\000\
\001\000\001\000\001\000\003\000\001\000\004\000\001\000\004\000\
\006\000\001\000\004\000\006\000\001\000\001\000\001\000\004\000\
\001\000\002\000\000\000\002\000\002\000\003\000\004\000\002\000\
\002\000\002\000\004\000\002\000\005\000\004\000\005\000\007\000\
\010\000\004\000\001\000\003\000\000\000\003\000\001\000\007\000\
\000\000\003\000\007\000\000\000\003\000\002\000\001\000\001\000\
\001\000\003\000\001\000\001\000\001\000\002\000\002\000\001\000\
\003\000\001\000\001\000\001\000\008\000\000\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\000\000\
\001\000\001\000\002\000\006\000\001\000\000\000\003\000\001\000\
\003\000\002\000\002\000\000\000\001\000\001\000\001\000\002\000\
\005\000\001\000\001\000\002\000\001\000\002\000\002\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\002\000\002\000\007\000\004\000\
\004\000\002\000\002\000\006\000\008\000\001\000\003\000\003\000\
\003\000\005\000\001\000\003\000\001\000\004\000\003\000\002\000\
\001\000\002\000\002\000\002\000\002\000\002\000"

let yydefred = "\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\250\000\000\000\009\000\006\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\251\000\000\000\223\000\108\000\117\000\114\000\115\000\
\116\000\180\000\217\000\218\000\219\000\220\000\221\000\222\000\
\224\000\225\000\226\000\227\000\228\000\252\000\253\000\000\000\
\001\000\254\000\025\000\026\000\000\000\000\000\000\000\000\000\
\000\000\197\000\229\000\230\000\000\000\000\000\000\000\000\000\
\000\000\000\000\173\000\172\000\000\000\171\000\000\000\000\000\
\000\000\169\000\000\000\184\000\000\000\183\000\234\000\235\000\
\000\000\020\000\000\000\000\000\000\000\000\000\004\000\099\000\
\000\000\000\000\055\000\056\000\041\000\049\000\050\000\051\000\
\052\000\053\000\000\000\000\000\000\000\000\000\013\000\000\000\
\000\000\000\000\033\000\034\000\035\000\039\000\040\000\000\000\
\000\000\010\000\000\000\000\000\007\000\005\000\002\000\000\000\
\000\000\000\000\000\000\000\000\166\000\000\000\175\000\174\000\
\000\000\000\000\000\000\000\000\000\000\000\000\249\000\000\000\
\247\000\000\000\100\000\003\000\000\000\098\000\000\000\031\000\
\032\000\000\000\011\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\043\000\000\000\000\000\000\000\000\000\000\000\
\200\000\008\000\159\000\000\000\000\000\000\000\000\000\232\000\
\023\000\245\000\000\000\243\000\123\000\155\000\000\000\000\000\
\170\000\000\000\185\000\186\000\187\000\188\000\189\000\190\000\
\191\000\000\000\000\000\000\000\000\000\238\000\248\000\246\000\
\062\000\036\000\000\000\016\000\000\000\000\000\000\000\000\000\
\000\000\000\000\029\000\030\000\044\000\000\000\000\000\000\000\
\000\000\205\000\206\000\202\000\203\000\000\000\000\000\109\000\
\000\000\112\000\000\000\000\000\000\000\000\000\000\000\119\000\
\121\000\122\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\069\000\070\000\071\000\072\000\073\000\
\074\000\075\000\076\000\000\000\158\000\000\000\000\000\000\000\
\103\000\101\000\000\000\000\000\000\000\000\000\000\000\242\000\
\000\000\000\000\000\000\000\000\000\000\000\000\045\000\048\000\
\201\000\113\000\000\000\000\000\000\000\000\000\118\000\000\000\
\000\000\000\000\000\000\000\000\133\000\000\000\137\000\134\000\
\139\000\000\000\000\000\000\000\000\000\000\000\067\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\244\000\
\156\000\178\000\179\000\000\000\176\000\000\000\000\000\236\000\
\241\000\000\000\000\000\239\000\017\000\019\000\000\000\000\000\
\014\000\047\000\046\000\000\000\000\000\000\000\000\000\120\000\
\000\000\000\000\138\000\000\000\000\000\000\000\000\000\160\000\
\231\000\000\000\068\000\000\000\066\000\095\000\094\000\096\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\086\000\000\000\000\000\000\000\163\000\107\000\106\000\
\000\000\104\000\000\000\000\000\000\000\194\000\000\000\059\000\
\000\000\000\000\154\000\000\000\000\000\150\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\140\000\000\000\
\097\000\000\000\000\000\000\000\000\000\091\000\000\000\000\000\
\082\000\000\000\000\000\000\000\085\000\000\000\177\000\102\000\
\000\000\000\000\000\000\000\000\207\000\195\000\237\000\000\000\
\000\000\151\000\126\000\131\000\000\000\136\000\128\000\000\000\
\000\000\145\000\146\000\144\000\000\000\000\000\162\000\078\000\
\000\000\000\000\088\000\090\000\000\000\084\000\000\000\000\000\
\000\000\081\000\165\000\105\000\000\000\210\000\000\000\208\000\
\060\000\000\000\000\000\000\000\000\000\000\000\000\000\142\000\
\093\000\092\000\000\000\087\000\089\000\000\000\216\000\000\000\
\000\000\213\000\000\000\132\000\129\000\147\000\000\000\143\000\
\000\000\215\000\000\000\214\000\000\000\149\000\196\000\000\000\
\211\000\000\000\212\000\153\000"

let yydgoto = "\006\000\
\009\000\026\000\027\000\047\000\050\000\010\000\057\000\088\000\
\011\000\012\000\053\000\104\000\147\000\105\000\148\000\168\000\
\004\001\057\001\195\000\196\000\197\000\169\000\233\000\234\000\
\107\000\108\000\109\000\110\000\111\000\112\000\113\000\105\001\
\236\000\237\000\238\000\239\000\240\000\241\000\242\000\243\000\
\129\001\127\001\083\001\028\000\127\000\250\000\097\001\098\001\
\029\000\043\001\216\000\217\000\030\000\031\000\032\000\033\000\
\223\000\224\000\225\000\226\000\174\000\025\001\070\001\119\001\
\175\000\072\001\072\000\044\001\094\001\073\000\074\000\045\001\
\034\000\077\000\186\000\100\001\140\001\078\000\101\001\102\001\
\059\000\160\000\161\000\212\000\141\001\175\001\193\001\208\001\
\035\000\194\001\036\000\037\000\038\000\039\000\040\000\041\000\
\042\000\043\000\044\000\045\000\171\000\189\000\190\000\172\000\
\137\000"

let yysindex = "\018\002\
\056\255\153\005\153\005\243\254\057\000\000\000\090\255\056\255\
\000\000\133\255\000\000\000\000\067\255\051\255\144\255\097\255\
\067\255\073\255\094\255\171\255\067\255\112\255\090\255\209\255\
\245\254\000\000\015\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\176\255\
\000\000\000\000\000\000\000\000\142\255\232\254\206\255\028\255\
\018\000\000\000\000\000\000\000\244\255\209\255\209\255\209\255\
\214\255\231\255\000\000\000\000\218\255\000\000\218\255\249\255\
\207\255\000\000\209\255\000\000\025\000\000\000\000\000\000\000\
\142\255\000\000\022\000\160\255\061\000\153\005\000\000\000\000\
\018\000\212\255\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\081\000\001\005\001\005\001\005\000\000\056\000\
\250\255\135\255\000\000\000\000\000\000\000\000\000\000\241\254\
\001\000\000\000\205\255\056\255\000\000\000\000\000\000\098\000\
\029\000\218\255\020\000\053\000\000\000\102\000\000\000\000\000\
\209\255\197\000\218\255\015\005\088\000\102\000\000\000\153\000\
\000\000\160\255\000\000\000\000\168\000\000\000\186\255\000\000\
\000\000\209\255\000\000\079\000\001\005\001\005\001\005\001\005\
\001\005\053\000\000\000\064\255\212\255\192\255\192\255\094\000\
\000\000\000\000\000\000\156\255\075\255\196\000\079\004\000\000\
\000\000\000\000\110\000\000\000\000\000\000\000\158\255\151\000\
\000\000\147\255\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\216\000\053\000\238\000\113\255\000\000\000\000\000\000\
\000\000\000\000\147\000\000\000\251\000\192\004\224\000\135\255\
\161\255\161\255\000\000\000\000\000\000\001\005\007\001\169\000\
\017\000\000\000\000\000\000\000\000\000\205\255\174\255\000\000\
\156\255\000\000\172\000\225\000\235\000\173\000\172\255\000\000\
\000\000\000\000\174\000\243\254\230\000\186\000\192\004\192\004\
\223\255\077\001\239\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\053\000\000\000\102\000\037\255\189\000\
\000\000\000\000\098\000\230\254\215\004\136\004\102\000\000\000\
\209\255\034\001\027\001\254\000\091\000\201\000\000\000\000\000\
\000\000\000\000\192\004\203\000\204\000\102\000\000\000\075\255\
\205\000\206\000\255\000\210\000\000\000\211\000\000\000\000\000\
\000\000\231\000\067\255\243\254\126\255\157\255\000\000\192\004\
\192\004\185\004\001\005\218\000\027\255\140\255\001\255\000\000\
\000\000\000\000\000\000\249\254\000\000\022\255\039\001\000\000\
\000\000\135\255\011\001\000\000\000\000\000\000\007\001\192\004\
\000\000\000\000\000\000\215\255\102\000\102\000\245\255\000\000\
\061\001\062\001\000\000\063\001\066\001\023\255\058\001\000\000\
\000\000\232\000\000\000\226\000\000\000\000\000\000\000\000\000\
\236\004\135\255\236\000\072\000\025\255\050\001\001\005\240\000\
\027\255\000\000\030\001\046\001\037\255\000\000\000\000\000\000\
\048\000\000\000\067\255\024\001\039\001\000\000\067\255\000\000\
\243\000\223\255\000\000\060\000\068\000\000\000\245\000\073\000\
\248\000\093\000\253\000\030\255\209\255\053\001\000\000\049\001\
\000\000\009\001\243\254\001\005\012\001\000\000\109\000\027\255\
\000\000\108\000\025\255\050\001\000\000\054\001\000\000\000\000\
\022\255\085\001\113\001\024\001\000\000\000\000\000\000\007\001\
\057\001\000\000\000\000\000\000\119\001\000\000\000\000\120\001\
\192\004\000\000\000\000\000\000\019\001\128\255\000\000\000\000\
\026\001\135\255\000\000\000\000\027\255\000\000\001\005\031\001\
\120\000\000\000\000\000\000\000\096\001\000\000\082\255\000\000\
\000\000\209\255\032\001\033\001\050\000\102\000\087\001\000\000\
\000\000\000\000\135\255\000\000\000\000\056\255\000\000\174\000\
\103\255\000\000\041\001\000\000\000\000\000\000\136\000\000\000\
\133\255\000\000\181\004\000\000\102\000\000\000\000\000\181\004\
\000\000\139\000\000\000\000\000"

let yyrindex = "\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\182\255\000\000\
\000\000\019\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\093\001\000\000\000\000\182\255\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\019\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\089\001\000\000\000\000\226\254\000\000\226\254\000\000\
\090\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\148\002\000\000\000\000\
\000\000\036\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\009\000\020\255\000\000\000\000\000\000\000\000\000\000\146\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\142\001\025\001\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\149\255\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\062\003\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\159\002\005\000\005\000\007\000\
\000\000\000\000\000\000\008\000\000\000\000\000\000\000\000\000\
\000\000\000\000\103\004\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\025\001\000\000\000\000\000\000\
\000\000\000\000\009\003\000\000\212\002\000\000\146\003\131\255\
\250\000\097\001\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\010\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\093\003\000\000\125\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\252\003\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\048\001\045\005\000\000\056\005\000\000\066\005\000\000\000\000\
\000\000\006\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\012\000\000\000\000\000\094\001\000\000\
\000\000\060\004\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\142\000\000\000\000\000\
\000\000\000\000\000\000\106\002\000\000\000\000\000\000\000\000\
\000\000\150\001\000\000\000\000\000\000\203\001\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\095\001\000\000\000\000\000\000\
\199\003\049\004\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\203\001\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\013\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\168\255\197\255\000\000\000\000\
\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\053\002\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\159\000\000\000\000\000\000\000\000\000\000\000\
\049\255\000\000\000\000\000\000\000\000\000\000\000\000\004\000\
\000\000\000\000\000\000\000\000"

let yygindex = "\000\000\
\000\000\070\002\155\002\000\000\000\000\248\255\211\255\031\000\
\254\255\243\255\137\002\081\002\168\001\000\000\000\000\162\255\
\000\000\000\000\000\000\166\001\233\255\000\000\045\255\217\255\
\254\254\189\255\000\000\154\255\059\001\226\255\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\037\001\045\001\000\000\000\000\059\000\000\000\000\000\040\001\
\000\000\153\255\000\000\000\000\123\255\000\000\000\000\000\000\
\000\000\154\001\000\000\000\000\138\255\001\001\000\000\000\000\
\253\254\000\000\000\000\000\000\000\000\000\000\056\002\098\001\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\104\001\
\028\000\000\000\232\001\035\002\067\001\000\000\000\000\000\000\
\116\255\004\001\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\021\002\000\000\210\001\223\001\
\075\002"

let yytablesize = 1769
let yytable = "\054\000\
\083\000\048\000\089\000\209\000\204\000\161\000\199\000\110\000\
\146\000\111\000\063\001\164\000\181\000\106\000\087\000\188\000\
\164\000\087\000\198\000\029\001\031\001\170\000\157\000\091\000\
\092\000\154\000\091\000\092\000\091\000\092\000\218\000\091\000\
\092\000\116\000\086\001\061\000\115\001\163\000\121\000\122\000\
\123\000\106\000\117\000\096\001\065\000\116\001\227\000\159\000\
\079\000\056\000\090\001\131\000\007\000\199\000\037\000\060\001\
\049\000\108\001\109\001\084\000\143\000\144\000\145\000\037\000\
\090\000\091\000\092\000\058\000\157\000\206\000\198\000\095\001\
\244\000\114\000\092\001\173\000\076\001\077\001\066\000\154\001\
\099\000\155\000\126\001\010\001\170\000\117\001\132\001\119\000\
\219\000\207\000\007\000\093\001\085\000\007\000\000\001\051\000\
\067\000\042\001\093\000\235\000\106\001\093\000\162\000\093\000\
\091\001\176\000\155\001\220\000\198\000\200\000\201\000\202\000\
\203\000\204\000\068\000\052\000\209\000\099\000\037\000\140\000\
\099\000\007\000\099\000\205\000\008\000\166\001\118\001\041\001\
\126\001\128\000\235\000\064\000\221\000\060\000\096\001\069\000\
\188\000\075\000\070\000\006\001\093\000\170\000\090\000\091\000\
\092\000\042\000\159\000\047\001\071\000\222\000\087\001\191\001\
\008\000\227\000\094\000\095\000\096\000\097\000\098\000\099\000\
\100\000\034\001\186\001\235\000\235\000\038\000\005\001\035\001\
\101\000\102\000\208\000\076\000\191\001\215\000\038\000\249\000\
\135\000\099\000\199\001\088\001\166\000\148\000\024\000\024\000\
\024\000\183\001\235\000\089\001\055\000\178\000\148\000\030\001\
\018\000\254\000\080\000\136\000\036\001\181\001\099\000\235\000\
\210\000\210\001\184\001\203\001\037\001\157\000\056\000\158\000\
\061\000\082\000\141\000\255\000\007\000\050\001\157\000\062\000\
\211\000\115\000\093\000\141\000\235\000\235\000\063\000\075\001\
\248\000\026\001\157\000\032\001\033\001\038\000\148\000\055\000\
\094\000\095\000\096\000\097\000\098\000\099\000\100\000\150\000\
\151\000\152\000\153\000\104\001\235\000\062\000\101\000\102\000\
\103\000\027\000\082\001\084\001\063\000\120\000\194\000\245\000\
\246\000\124\000\024\000\141\000\038\001\150\000\151\000\152\000\
\153\000\148\000\148\000\152\000\153\000\015\001\016\001\148\000\
\024\000\024\000\024\000\024\000\024\000\024\000\024\000\161\000\
\022\000\074\001\204\000\194\000\199\000\164\000\024\000\024\000\
\024\000\125\000\150\000\151\000\152\000\153\000\141\000\141\000\
\061\000\143\000\161\000\012\000\141\000\129\000\061\000\130\001\
\164\000\130\000\061\000\061\000\012\000\061\000\073\001\141\000\
\107\001\061\000\126\000\061\000\032\001\033\001\209\001\209\000\
\204\000\061\000\199\000\211\001\032\001\033\001\061\000\132\000\
\061\000\061\000\061\000\061\000\177\001\061\000\122\001\061\000\
\061\000\142\000\125\001\061\000\162\001\235\000\110\001\246\000\
\134\000\061\000\146\000\061\000\149\000\157\001\138\000\061\000\
\028\000\156\000\163\000\061\000\167\000\061\000\173\000\204\000\
\209\000\204\000\161\000\199\000\110\000\061\000\111\000\061\000\
\164\000\181\000\008\001\086\000\061\000\061\000\118\000\198\000\
\161\001\150\000\151\000\152\000\153\000\165\000\138\001\187\001\
\168\001\034\000\143\001\187\000\054\000\061\000\061\000\034\000\
\061\000\061\000\061\000\061\000\061\000\061\000\061\000\061\000\
\192\001\136\001\137\001\198\001\099\000\077\000\042\000\032\001\
\033\001\191\000\195\001\207\001\042\000\145\001\246\000\198\000\
\042\000\042\000\192\001\042\000\034\000\146\001\246\000\042\000\
\193\000\042\000\148\001\149\001\034\000\042\000\124\001\042\000\
\150\000\151\000\152\000\153\000\042\000\201\001\042\000\042\000\
\042\000\042\000\017\001\042\000\058\001\042\000\151\001\152\001\
\214\000\042\000\018\001\150\000\151\000\152\000\153\000\042\000\
\019\001\042\000\083\000\228\000\020\001\042\000\164\001\165\001\
\244\000\042\000\167\001\042\000\150\000\151\000\152\000\153\000\
\021\001\189\001\165\001\042\000\067\000\042\000\034\000\247\000\
\022\001\251\000\042\000\042\000\034\000\034\000\034\000\034\000\
\034\000\206\001\246\000\023\001\212\001\246\000\068\000\124\000\
\124\000\024\001\253\000\042\000\042\000\001\001\042\000\042\000\
\042\000\042\000\042\000\042\000\042\000\042\000\027\000\080\000\
\152\000\152\000\002\001\069\000\027\000\003\001\070\000\157\000\
\027\000\027\000\007\001\027\000\011\001\014\001\012\001\027\000\
\071\000\027\000\001\000\002\000\003\000\004\000\005\000\027\000\
\013\001\027\001\028\001\039\001\027\000\046\001\027\000\027\000\
\027\000\027\000\054\001\027\000\056\001\027\000\055\001\022\000\
\022\000\027\000\059\001\061\001\062\001\065\001\066\001\027\000\
\022\000\027\000\068\001\069\001\079\000\027\000\022\000\067\001\
\071\001\027\000\085\001\027\000\099\001\125\000\103\001\111\001\
\112\001\113\001\022\000\027\000\114\001\027\000\125\000\120\001\
\033\001\121\001\027\000\027\000\123\001\128\001\022\000\133\001\
\131\001\034\001\134\001\139\001\022\000\144\001\147\001\035\001\
\022\000\150\001\022\000\027\000\027\000\153\001\027\000\027\000\
\027\000\027\000\027\000\027\000\022\000\028\000\158\001\159\001\
\173\001\065\000\160\001\028\000\171\001\163\001\125\000\028\000\
\028\000\174\001\028\000\182\001\036\001\125\000\028\000\178\001\
\028\000\179\001\180\001\185\001\037\001\022\000\028\000\190\001\
\188\001\196\001\197\001\028\000\200\001\028\000\028\000\028\000\
\028\000\205\001\028\000\182\000\028\000\167\000\168\000\125\000\
\028\000\125\000\125\000\005\000\125\000\157\000\028\000\125\000\
\028\000\192\000\193\000\139\000\028\000\046\000\061\000\081\000\
\028\000\133\000\028\000\048\001\077\000\077\000\053\001\077\000\
\170\001\064\001\028\000\077\000\028\000\077\000\156\001\169\001\
\172\001\028\000\028\000\077\000\038\001\150\000\151\000\152\000\
\153\000\177\000\077\000\077\000\077\000\009\001\135\001\077\000\
\202\001\213\000\028\000\028\000\204\001\028\000\028\000\028\000\
\028\000\028\000\028\000\077\000\142\001\077\000\176\001\252\000\
\052\001\077\000\040\001\018\000\192\000\077\000\000\000\077\000\
\000\000\083\000\083\000\000\000\083\000\000\000\000\000\077\000\
\083\000\077\000\083\000\000\000\000\000\000\000\000\000\077\000\
\083\000\000\000\000\000\000\000\000\000\000\000\000\000\083\000\
\083\000\083\000\000\000\000\000\083\000\000\000\000\000\077\000\
\000\000\000\000\077\000\077\000\077\000\000\000\000\000\000\000\
\083\000\000\000\083\000\000\000\000\000\000\000\083\000\000\000\
\015\000\000\000\083\000\000\000\083\000\000\000\080\000\080\000\
\000\000\080\000\000\000\000\000\083\000\080\000\083\000\080\000\
\000\000\000\000\000\000\000\000\083\000\080\000\000\000\000\000\
\000\000\000\000\000\000\000\000\080\000\080\000\080\000\000\000\
\000\000\080\000\000\000\000\000\083\000\000\000\000\000\083\000\
\083\000\083\000\000\000\000\000\000\000\080\000\000\000\080\000\
\000\000\000\000\000\000\080\000\000\000\022\000\000\000\080\000\
\000\000\080\000\000\000\079\000\079\000\000\000\079\000\000\000\
\000\000\080\000\079\000\080\000\079\000\000\000\000\000\000\000\
\000\000\080\000\079\000\000\000\000\000\000\000\000\000\000\000\
\000\000\079\000\079\000\079\000\021\000\000\000\079\000\000\000\
\000\000\080\000\000\000\000\000\080\000\080\000\080\000\000\000\
\000\000\000\000\079\000\000\000\079\000\000\000\000\000\000\000\
\079\000\000\000\000\000\000\000\079\000\000\000\079\000\000\000\
\065\000\065\000\000\000\065\000\000\000\000\000\079\000\065\000\
\079\000\065\000\000\000\000\000\000\000\000\000\079\000\065\000\
\000\000\000\000\000\000\000\000\000\000\000\000\065\000\065\000\
\065\000\057\000\000\000\065\000\000\000\000\000\079\000\000\000\
\000\000\079\000\079\000\079\000\000\000\000\000\000\000\065\000\
\000\000\065\000\000\000\000\000\000\000\065\000\000\000\061\000\
\000\000\065\000\000\000\065\000\000\000\061\000\061\000\000\000\
\061\000\000\000\000\000\065\000\061\000\065\000\061\000\061\000\
\000\000\000\000\000\000\065\000\061\000\000\000\000\000\000\000\
\000\000\000\000\000\000\061\000\000\000\061\000\058\000\000\000\
\061\000\000\000\000\000\065\000\000\000\000\000\065\000\065\000\
\000\000\000\000\000\000\000\000\061\000\000\000\061\000\000\000\
\000\000\000\000\061\000\000\000\000\000\000\000\061\000\000\000\
\061\000\000\000\018\000\018\000\000\000\018\000\000\000\000\000\
\061\000\018\000\061\000\018\000\000\000\000\000\000\000\000\000\
\061\000\018\000\000\000\000\000\000\000\000\000\000\000\000\000\
\018\000\018\000\018\000\063\000\000\000\018\000\000\000\000\000\
\061\000\061\000\000\000\061\000\000\000\000\000\000\000\000\000\
\000\000\018\000\000\000\018\000\000\000\000\000\000\000\018\000\
\000\000\000\000\000\000\018\000\000\000\018\000\000\000\015\000\
\015\000\000\000\015\000\000\000\000\000\018\000\015\000\018\000\
\015\000\000\000\000\000\000\000\018\000\018\000\015\000\000\000\
\000\000\000\000\000\000\000\000\000\000\015\000\015\000\015\000\
\064\000\000\000\015\000\000\000\000\000\018\000\018\000\000\000\
\018\000\000\000\000\000\240\000\000\000\000\000\015\000\000\000\
\015\000\000\000\000\000\000\000\015\000\000\000\000\000\000\000\
\015\000\000\000\015\000\000\000\022\000\022\000\000\000\022\000\
\000\000\000\000\015\000\022\000\015\000\022\000\000\000\000\000\
\000\000\015\000\015\000\022\000\000\000\000\000\000\000\000\000\
\000\000\000\000\022\000\022\000\022\000\000\000\233\000\022\000\
\000\000\000\000\015\000\021\000\021\000\015\000\021\000\000\000\
\000\000\000\000\021\000\022\000\021\000\022\000\000\000\000\000\
\000\000\022\000\021\000\000\000\000\000\022\000\000\000\022\000\
\000\000\021\000\021\000\021\000\000\000\000\000\021\000\022\000\
\000\000\022\000\000\000\000\000\000\000\000\000\000\000\022\000\
\000\000\000\000\021\000\000\000\021\000\000\000\000\000\000\000\
\021\000\000\000\000\000\000\000\021\000\000\000\021\000\022\000\
\057\000\057\000\022\000\057\000\000\000\000\000\021\000\057\000\
\021\000\057\000\000\000\000\000\000\000\000\000\021\000\057\000\
\000\000\000\000\000\000\000\000\000\000\000\000\057\000\000\000\
\057\000\000\000\000\000\057\000\000\000\000\000\021\000\000\000\
\000\000\021\000\000\000\000\000\000\000\000\000\000\000\057\000\
\000\000\057\000\000\000\000\000\000\000\057\000\000\000\000\000\
\000\000\057\000\000\000\057\000\000\000\058\000\058\000\000\000\
\058\000\000\000\000\000\057\000\058\000\057\000\058\000\000\000\
\000\000\000\000\000\000\057\000\058\000\000\000\000\000\000\000\
\000\000\000\000\000\000\058\000\000\000\058\000\000\000\000\000\
\058\000\000\000\000\000\057\000\000\000\000\000\057\000\000\000\
\000\000\000\000\000\000\000\000\058\000\000\000\058\000\000\000\
\000\000\000\000\058\000\000\000\000\000\000\000\058\000\000\000\
\058\000\000\000\063\000\063\000\000\000\063\000\000\000\000\000\
\058\000\063\000\058\000\063\000\000\000\000\000\000\000\000\000\
\058\000\063\000\000\000\000\000\000\000\000\000\000\000\000\000\
\063\000\000\000\000\000\000\000\000\000\063\000\000\000\000\000\
\058\000\000\000\000\000\058\000\000\000\000\000\000\000\000\000\
\000\000\063\000\000\000\063\000\000\000\000\000\000\000\063\000\
\000\000\000\000\000\000\063\000\000\000\063\000\000\000\064\000\
\064\000\000\000\064\000\000\000\000\000\063\000\064\000\063\000\
\064\000\000\000\240\000\240\000\000\000\063\000\064\000\090\000\
\091\000\092\000\000\000\240\000\000\000\064\000\000\000\000\000\
\000\000\240\000\064\000\000\000\000\000\063\000\000\000\000\000\
\063\000\229\000\000\000\000\000\000\000\240\000\064\000\000\000\
\064\000\000\000\000\000\230\000\064\000\000\000\000\000\000\000\
\064\000\240\000\064\000\000\000\000\000\233\000\233\000\240\000\
\000\000\000\000\064\000\240\000\064\000\240\000\233\000\000\000\
\000\000\000\000\064\000\000\000\233\000\000\000\000\000\240\000\
\090\000\091\000\092\000\000\000\240\000\000\000\000\000\000\000\
\233\000\000\000\064\000\000\000\000\000\064\000\000\000\000\000\
\000\000\000\000\051\001\093\000\233\000\000\000\240\000\000\000\
\240\000\000\000\233\000\000\000\230\000\000\000\233\000\000\000\
\233\000\094\000\095\000\096\000\097\000\098\000\099\000\231\000\
\000\000\000\000\233\000\000\000\000\000\000\000\232\000\101\000\
\102\000\090\000\091\000\092\000\000\000\000\000\078\001\079\001\
\090\000\091\000\092\000\013\000\014\000\000\000\000\000\000\000\
\000\000\000\000\000\000\233\000\016\000\000\000\000\000\000\000\
\000\000\000\000\017\000\000\000\093\000\000\000\000\000\090\000\
\091\000\092\000\000\000\000\000\230\000\000\000\019\000\000\000\
\000\000\000\000\094\000\095\000\096\000\097\000\098\000\099\000\
\231\000\000\000\021\000\000\000\090\000\091\000\092\000\232\000\
\101\000\102\000\000\000\000\000\022\000\000\000\023\000\000\000\
\000\000\000\000\000\000\000\000\000\000\080\001\000\000\000\000\
\024\000\090\000\091\000\092\000\000\000\093\000\000\000\000\000\
\049\001\000\000\000\000\000\000\093\000\000\000\000\000\000\000\
\000\000\000\000\000\000\094\000\095\000\096\000\097\000\098\000\
\099\000\081\001\094\000\095\000\096\000\097\000\098\000\099\000\
\231\000\101\000\102\000\093\000\000\000\000\000\000\000\232\000\
\101\000\102\000\000\000\000\000\000\000\007\000\000\000\000\000\
\000\000\094\000\095\000\096\000\097\000\098\000\099\000\100\000\
\093\000\000\000\130\000\000\000\000\000\000\000\000\000\101\000\
\102\000\000\000\000\000\130\000\000\000\135\000\094\000\095\000\
\096\000\097\000\098\000\099\000\100\000\093\000\135\000\127\000\
\000\000\000\000\000\000\000\000\101\000\102\000\000\000\000\000\
\127\000\000\000\000\000\094\000\095\000\096\000\097\000\098\000\
\099\000\100\000\179\000\180\000\181\000\182\000\183\000\184\000\
\185\000\101\000\102\000\130\000\000\000\000\000\000\000\000\000\
\000\000\000\000\130\000\000\000\000\000\000\000\135\000\000\000\
\000\000\000\000\000\000\000\000\000\000\135\000\000\000\000\000\
\127\000\000\000\000\000\000\000\000\000\000\000\000\000\127\000\
\000\000\000\000\000\000\000\000\130\000\000\000\130\000\130\000\
\000\000\130\000\000\000\000\000\130\000\000\000\000\000\135\000\
\000\000\135\000\135\000\000\000\135\000\000\000\000\000\135\000\
\000\000\127\000\000\000\127\000\127\000\000\000\127\000\013\000\
\014\000\127\000\015\000\000\000\000\000\000\000\000\000\000\000\
\016\000\000\000\000\000\000\000\000\000\000\000\017\000\000\000\
\000\000\000\000\000\000\000\000\000\000\018\000\000\000\000\000\
\000\000\000\000\019\000\000\000\000\000\000\000\000\000\000\000\
\000\000\020\000\000\000\000\000\000\000\000\000\021\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\022\000\000\000\023\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\024\000\000\000\000\000\000\000\
\025\000"

let yycheck = "\008\000\
\024\000\004\000\048\000\000\000\000\000\000\000\000\000\000\000\
\035\001\000\000\014\001\000\000\000\000\053\000\000\000\134\000\
\120\000\000\000\000\000\231\000\232\000\124\000\053\001\002\001\
\003\001\041\001\002\001\003\001\002\001\003\001\164\000\002\001\
\003\001\006\001\037\001\000\000\014\001\001\001\062\000\063\000\
\064\000\081\000\056\000\046\001\017\000\023\001\165\000\115\000\
\021\000\074\001\050\001\075\000\066\001\148\000\035\001\011\001\
\000\000\061\001\062\001\071\001\100\000\101\000\102\000\044\001\
\001\001\002\001\003\001\001\001\099\001\006\001\022\001\050\001\
\099\001\098\001\082\001\001\001\032\001\033\001\006\001\050\001\
\096\001\112\000\085\001\217\000\187\000\063\001\089\001\057\000\
\014\001\026\001\066\001\099\001\104\001\066\001\189\000\006\001\
\024\001\061\001\077\001\167\000\056\001\077\001\116\000\077\001\
\104\001\129\000\077\001\033\001\060\001\149\000\150\000\151\000\
\152\000\153\000\042\001\026\001\156\000\096\001\099\001\089\000\
\096\001\066\001\096\001\154\000\097\001\128\001\104\001\246\000\
\131\001\071\000\198\000\035\001\058\001\083\001\137\001\063\001\
\255\000\044\001\066\001\207\000\077\001\244\000\001\001\002\001\
\003\001\000\000\214\000\251\000\076\001\075\001\011\001\070\001\
\097\001\016\001\091\001\092\001\093\001\094\001\095\001\096\001\
\097\001\005\001\165\001\231\000\232\000\035\001\206\000\011\001\
\105\001\106\001\107\001\001\001\070\001\018\001\044\001\178\000\
\017\001\096\001\182\001\040\001\122\000\014\001\001\001\002\001\
\003\001\058\001\254\000\048\001\056\001\131\000\023\001\231\000\
\037\001\081\001\083\001\036\001\040\001\153\001\096\001\011\001\
\009\001\205\001\075\001\101\001\048\001\001\001\074\001\003\001\
\065\001\001\001\014\001\099\001\066\001\253\000\066\001\072\001\
\025\001\012\001\077\001\023\001\032\001\033\001\079\001\098\001\
\078\001\228\000\078\001\102\001\103\001\099\001\063\001\056\001\
\091\001\092\001\093\001\094\001\095\001\096\001\097\001\105\001\
\106\001\107\001\108\001\055\001\056\001\072\001\105\001\106\001\
\107\001\000\000\034\001\035\001\079\001\010\001\098\001\098\001\
\099\001\044\001\077\001\063\001\104\001\105\001\106\001\107\001\
\108\001\098\001\099\001\107\001\108\001\098\001\099\001\104\001\
\091\001\092\001\093\001\094\001\095\001\096\001\097\001\018\001\
\000\000\028\001\022\001\098\001\022\001\018\001\105\001\106\001\
\107\001\059\001\105\001\106\001\107\001\108\001\098\001\099\001\
\005\001\081\001\037\001\035\001\104\001\053\001\011\001\087\001\
\037\001\099\001\015\001\016\001\044\001\018\001\027\001\100\001\
\098\001\022\001\097\001\024\001\102\001\103\001\203\001\060\001\
\060\001\030\001\060\001\208\001\102\001\103\001\035\001\047\001\
\037\001\038\001\039\001\040\001\144\001\042\001\081\001\044\001\
\045\001\001\001\085\001\048\001\124\001\153\001\098\001\099\001\
\067\001\054\001\035\001\056\001\099\001\117\001\034\001\060\001\
\000\000\097\001\001\001\064\001\081\001\066\001\001\001\099\001\
\101\001\101\001\101\001\101\001\101\001\074\001\101\001\076\001\
\101\001\101\001\098\001\101\001\081\001\082\001\101\001\101\001\
\123\001\105\001\106\001\107\001\108\001\097\001\099\001\167\001\
\131\001\005\001\103\001\044\001\097\001\098\001\099\001\011\001\
\101\001\102\001\103\001\104\001\105\001\106\001\107\001\108\001\
\175\001\098\001\099\001\098\001\096\001\000\000\005\001\102\001\
\103\001\001\001\178\001\201\001\011\001\098\001\099\001\081\001\
\015\001\016\001\193\001\018\001\040\001\098\001\099\001\022\001\
\001\001\024\001\098\001\099\001\048\001\028\001\103\001\030\001\
\105\001\106\001\107\001\108\001\035\001\190\001\037\001\038\001\
\039\001\040\001\013\001\042\001\098\001\044\001\098\001\099\001\
\099\001\048\001\021\001\105\001\106\001\107\001\108\001\054\001\
\027\001\056\001\000\000\008\001\031\001\060\001\098\001\099\001\
\099\001\064\001\103\001\066\001\105\001\106\001\107\001\108\001\
\043\001\098\001\099\001\074\001\024\001\076\001\098\001\073\001\
\051\001\010\001\081\001\082\001\104\001\105\001\106\001\107\001\
\108\001\098\001\099\001\062\001\098\001\099\001\042\001\098\001\
\099\001\068\001\005\001\098\001\099\001\099\001\101\001\102\001\
\103\001\104\001\105\001\106\001\107\001\108\001\005\001\000\000\
\098\001\099\001\008\001\063\001\011\001\038\001\066\001\001\001\
\015\001\016\001\098\001\018\001\097\001\097\001\046\001\022\001\
\076\001\024\001\001\000\002\000\003\000\004\000\005\000\030\001\
\046\001\052\001\097\001\045\001\035\001\097\001\037\001\038\001\
\039\001\040\001\001\001\042\001\039\001\044\001\012\001\015\001\
\016\001\048\001\098\001\097\001\097\001\097\001\097\001\054\001\
\024\001\056\001\097\001\097\001\000\000\060\001\030\001\057\001\
\082\001\064\001\097\001\066\001\022\001\014\001\052\001\003\001\
\003\001\003\001\042\001\074\001\003\001\076\001\023\001\014\001\
\103\001\098\001\081\001\082\001\097\001\028\001\054\001\050\001\
\097\001\005\001\037\001\060\001\060\001\099\001\098\001\011\001\
\064\001\098\001\066\001\098\001\099\001\097\001\101\001\102\001\
\103\001\104\001\105\001\106\001\076\001\005\001\050\001\055\001\
\020\001\000\000\098\001\011\001\055\001\098\001\063\001\015\001\
\016\001\001\001\018\001\097\001\040\001\070\001\022\001\063\001\
\024\001\003\001\003\001\098\001\048\001\101\001\030\001\032\001\
\098\001\098\001\098\001\035\001\046\001\037\001\038\001\039\001\
\040\001\097\001\042\001\047\001\044\001\053\001\053\001\096\001\
\048\001\098\001\099\001\000\000\101\001\008\001\054\001\104\001\
\056\001\060\001\060\001\086\000\060\001\003\000\000\000\023\000\
\064\001\081\000\066\001\252\000\015\001\016\001\001\001\018\001\
\132\001\016\001\074\001\022\001\076\001\024\001\116\001\131\001\
\137\001\081\001\082\001\030\001\104\001\105\001\106\001\107\001\
\108\001\130\000\037\001\038\001\039\001\214\000\093\001\042\001\
\192\001\159\000\098\001\099\001\193\001\101\001\102\001\103\001\
\104\001\105\001\106\001\054\001\101\001\056\001\140\001\187\000\
\255\000\060\001\244\000\000\000\138\000\064\001\255\255\066\001\
\255\255\015\001\016\001\255\255\018\001\255\255\255\255\074\001\
\022\001\076\001\024\001\255\255\255\255\255\255\255\255\082\001\
\030\001\255\255\255\255\255\255\255\255\255\255\255\255\037\001\
\038\001\039\001\255\255\255\255\042\001\255\255\255\255\098\001\
\255\255\255\255\101\001\102\001\103\001\255\255\255\255\255\255\
\054\001\255\255\056\001\255\255\255\255\255\255\060\001\255\255\
\000\000\255\255\064\001\255\255\066\001\255\255\015\001\016\001\
\255\255\018\001\255\255\255\255\074\001\022\001\076\001\024\001\
\255\255\255\255\255\255\255\255\082\001\030\001\255\255\255\255\
\255\255\255\255\255\255\255\255\037\001\038\001\039\001\255\255\
\255\255\042\001\255\255\255\255\098\001\255\255\255\255\101\001\
\102\001\103\001\255\255\255\255\255\255\054\001\255\255\056\001\
\255\255\255\255\255\255\060\001\255\255\000\000\255\255\064\001\
\255\255\066\001\255\255\015\001\016\001\255\255\018\001\255\255\
\255\255\074\001\022\001\076\001\024\001\255\255\255\255\255\255\
\255\255\082\001\030\001\255\255\255\255\255\255\255\255\255\255\
\255\255\037\001\038\001\039\001\000\000\255\255\042\001\255\255\
\255\255\098\001\255\255\255\255\101\001\102\001\103\001\255\255\
\255\255\255\255\054\001\255\255\056\001\255\255\255\255\255\255\
\060\001\255\255\255\255\255\255\064\001\255\255\066\001\255\255\
\015\001\016\001\255\255\018\001\255\255\255\255\074\001\022\001\
\076\001\024\001\255\255\255\255\255\255\255\255\082\001\030\001\
\255\255\255\255\255\255\255\255\255\255\255\255\037\001\038\001\
\039\001\000\000\255\255\042\001\255\255\255\255\098\001\255\255\
\255\255\101\001\102\001\103\001\255\255\255\255\255\255\054\001\
\255\255\056\001\255\255\255\255\255\255\060\001\255\255\009\001\
\255\255\064\001\255\255\066\001\255\255\015\001\016\001\255\255\
\018\001\255\255\255\255\074\001\022\001\076\001\024\001\025\001\
\255\255\255\255\255\255\082\001\030\001\255\255\255\255\255\255\
\255\255\255\255\255\255\037\001\255\255\039\001\000\000\255\255\
\042\001\255\255\255\255\098\001\255\255\255\255\101\001\102\001\
\255\255\255\255\255\255\255\255\054\001\255\255\056\001\255\255\
\255\255\255\255\060\001\255\255\255\255\255\255\064\001\255\255\
\066\001\255\255\015\001\016\001\255\255\018\001\255\255\255\255\
\074\001\022\001\076\001\024\001\255\255\255\255\255\255\255\255\
\082\001\030\001\255\255\255\255\255\255\255\255\255\255\255\255\
\037\001\038\001\039\001\000\000\255\255\042\001\255\255\255\255\
\098\001\099\001\255\255\101\001\255\255\255\255\255\255\255\255\
\255\255\054\001\255\255\056\001\255\255\255\255\255\255\060\001\
\255\255\255\255\255\255\064\001\255\255\066\001\255\255\015\001\
\016\001\255\255\018\001\255\255\255\255\074\001\022\001\076\001\
\024\001\255\255\255\255\255\255\081\001\082\001\030\001\255\255\
\255\255\255\255\255\255\255\255\255\255\037\001\038\001\039\001\
\000\000\255\255\042\001\255\255\255\255\098\001\099\001\255\255\
\101\001\255\255\255\255\000\000\255\255\255\255\054\001\255\255\
\056\001\255\255\255\255\255\255\060\001\255\255\255\255\255\255\
\064\001\255\255\066\001\255\255\015\001\016\001\255\255\018\001\
\255\255\255\255\074\001\022\001\076\001\024\001\255\255\255\255\
\255\255\081\001\082\001\030\001\255\255\255\255\255\255\255\255\
\255\255\255\255\037\001\038\001\039\001\255\255\000\000\042\001\
\255\255\255\255\098\001\015\001\016\001\101\001\018\001\255\255\
\255\255\255\255\022\001\054\001\024\001\056\001\255\255\255\255\
\255\255\060\001\030\001\255\255\255\255\064\001\255\255\066\001\
\255\255\037\001\038\001\039\001\255\255\255\255\042\001\074\001\
\255\255\076\001\255\255\255\255\255\255\255\255\255\255\082\001\
\255\255\255\255\054\001\255\255\056\001\255\255\255\255\255\255\
\060\001\255\255\255\255\255\255\064\001\255\255\066\001\098\001\
\015\001\016\001\101\001\018\001\255\255\255\255\074\001\022\001\
\076\001\024\001\255\255\255\255\255\255\255\255\082\001\030\001\
\255\255\255\255\255\255\255\255\255\255\255\255\037\001\255\255\
\039\001\255\255\255\255\042\001\255\255\255\255\098\001\255\255\
\255\255\101\001\255\255\255\255\255\255\255\255\255\255\054\001\
\255\255\056\001\255\255\255\255\255\255\060\001\255\255\255\255\
\255\255\064\001\255\255\066\001\255\255\015\001\016\001\255\255\
\018\001\255\255\255\255\074\001\022\001\076\001\024\001\255\255\
\255\255\255\255\255\255\082\001\030\001\255\255\255\255\255\255\
\255\255\255\255\255\255\037\001\255\255\039\001\255\255\255\255\
\042\001\255\255\255\255\098\001\255\255\255\255\101\001\255\255\
\255\255\255\255\255\255\255\255\054\001\255\255\056\001\255\255\
\255\255\255\255\060\001\255\255\255\255\255\255\064\001\255\255\
\066\001\255\255\015\001\016\001\255\255\018\001\255\255\255\255\
\074\001\022\001\076\001\024\001\255\255\255\255\255\255\255\255\
\082\001\030\001\255\255\255\255\255\255\255\255\255\255\255\255\
\037\001\255\255\255\255\255\255\255\255\042\001\255\255\255\255\
\098\001\255\255\255\255\101\001\255\255\255\255\255\255\255\255\
\255\255\054\001\255\255\056\001\255\255\255\255\255\255\060\001\
\255\255\255\255\255\255\064\001\255\255\066\001\255\255\015\001\
\016\001\255\255\018\001\255\255\255\255\074\001\022\001\076\001\
\024\001\255\255\015\001\016\001\255\255\082\001\030\001\001\001\
\002\001\003\001\255\255\024\001\255\255\037\001\255\255\255\255\
\255\255\030\001\042\001\255\255\255\255\098\001\255\255\255\255\
\101\001\019\001\255\255\255\255\255\255\042\001\054\001\255\255\
\056\001\255\255\255\255\029\001\060\001\255\255\255\255\255\255\
\064\001\054\001\066\001\255\255\255\255\015\001\016\001\060\001\
\255\255\255\255\074\001\064\001\076\001\066\001\024\001\255\255\
\255\255\255\255\082\001\255\255\030\001\255\255\255\255\076\001\
\001\001\002\001\003\001\255\255\081\001\255\255\255\255\255\255\
\042\001\255\255\098\001\255\255\255\255\101\001\255\255\255\255\
\255\255\255\255\019\001\077\001\054\001\255\255\099\001\255\255\
\101\001\255\255\060\001\255\255\029\001\255\255\064\001\255\255\
\066\001\091\001\092\001\093\001\094\001\095\001\096\001\097\001\
\255\255\255\255\076\001\255\255\255\255\255\255\104\001\105\001\
\106\001\001\001\002\001\003\001\255\255\255\255\006\001\007\001\
\001\001\002\001\003\001\015\001\016\001\255\255\255\255\255\255\
\255\255\255\255\255\255\101\001\024\001\255\255\255\255\255\255\
\255\255\255\255\030\001\255\255\077\001\255\255\255\255\001\001\
\002\001\003\001\255\255\255\255\029\001\255\255\042\001\255\255\
\255\255\255\255\091\001\092\001\093\001\094\001\095\001\096\001\
\097\001\255\255\054\001\255\255\001\001\002\001\003\001\104\001\
\105\001\106\001\255\255\255\255\064\001\255\255\066\001\255\255\
\255\255\255\255\255\255\255\255\255\255\069\001\255\255\255\255\
\076\001\001\001\002\001\003\001\255\255\077\001\255\255\255\255\
\050\001\255\255\255\255\255\255\077\001\255\255\255\255\255\255\
\255\255\255\255\255\255\091\001\092\001\093\001\094\001\095\001\
\096\001\097\001\091\001\092\001\093\001\094\001\095\001\096\001\
\097\001\105\001\106\001\077\001\255\255\255\255\255\255\104\001\
\105\001\106\001\255\255\255\255\255\255\066\001\255\255\255\255\
\255\255\091\001\092\001\093\001\094\001\095\001\096\001\097\001\
\077\001\255\255\014\001\255\255\255\255\255\255\255\255\105\001\
\106\001\255\255\255\255\023\001\255\255\014\001\091\001\092\001\
\093\001\094\001\095\001\096\001\097\001\077\001\023\001\014\001\
\255\255\255\255\255\255\255\255\105\001\106\001\255\255\255\255\
\023\001\255\255\255\255\091\001\092\001\093\001\094\001\095\001\
\096\001\097\001\084\001\085\001\086\001\087\001\088\001\089\001\
\090\001\105\001\106\001\063\001\255\255\255\255\255\255\255\255\
\255\255\255\255\070\001\255\255\255\255\255\255\063\001\255\255\
\255\255\255\255\255\255\255\255\255\255\070\001\255\255\255\255\
\063\001\255\255\255\255\255\255\255\255\255\255\255\255\070\001\
\255\255\255\255\255\255\255\255\096\001\255\255\098\001\099\001\
\255\255\101\001\255\255\255\255\104\001\255\255\255\255\096\001\
\255\255\098\001\099\001\255\255\101\001\255\255\255\255\104\001\
\255\255\096\001\255\255\098\001\099\001\255\255\101\001\015\001\
\016\001\104\001\018\001\255\255\255\255\255\255\255\255\255\255\
\024\001\255\255\255\255\255\255\255\255\255\255\030\001\255\255\
\255\255\255\255\255\255\255\255\255\255\037\001\255\255\255\255\
\255\255\255\255\042\001\255\255\255\255\255\255\255\255\255\255\
\255\255\049\001\255\255\255\255\255\255\255\255\054\001\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\064\001\255\255\066\001\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\076\001\255\255\255\255\255\255\
\080\001"

let yynames_const = "\
  ALL\000\
  ANY\000\
  AS\000\
  ASC\000\
  AUTHORIZATION\000\
  BETWEEN\000\
  BY\000\
  CHARACTER\000\
  CHECK\000\
  CLOSE\000\
  COMMIT\000\
  CONTINUE\000\
  CREATE\000\
  CURRENT\000\
  CURSOR\000\
  DECIMAL\000\
  DECLARE\000\
  DEFAULT\000\
  DELETE\000\
  DESC\000\
  DISTINCT\000\
  DOUBLE\000\
  ESCAPE\000\
  EXISTS\000\
  FETCH\000\
  FLOAT\000\
  FOR\000\
  FOREIGN\000\
  FOUND\000\
  FROM\000\
  GOTO\000\
  GRANT\000\
  GROUP\000\
  HAVING\000\
  IN\000\
  INDICATOR\000\
  INSERT\000\
  INTEGER\000\
  INTO\000\
  IS\000\
  KEY\000\
  LANGUAGE\000\
  LIKE\000\
  MODULE\000\
  NULL\000\
  NUMERIC\000\
  OF\000\
  ON\000\
  OPEN\000\
  OPTION\000\
  ORDER\000\
  PRECISION\000\
  PRIMARY\000\
  PRIVILEGES\000\
  PROCEDURE\000\
  PUBLIC\000\
  REAL\000\
  REFERENCES\000\
  ROLLBACK\000\
  SCHEMA\000\
  SELECT\000\
  SET\000\
  SMALLINT\000\
  SOME\000\
  SQLCODE\000\
  SQLERROR\000\
  TABLE\000\
  TO\000\
  UNION\000\
  UNIQUE\000\
  UPDATE\000\
  USER\000\
  VALUES\000\
  VIEW\000\
  WHENEVER\000\
  WHERE\000\
  WITH\000\
  WORK\000\
  COBOL\000\
  FORTRAN\000\
  PASCAL\000\
  PLI\000\
  C\000\
  ADA\000\
  OCAML\000\
  AVG\000\
  MIN\000\
  MAX\000\
  SUM\000\
  COUNT\000\
  COLON\000\
  LPAREN\000\
  RPAREN\000\
  COMMA\000\
  DOT\000\
  SEMICOLON\000\
  OR\000\
  AND\000\
  NOT\000\
  PLUS\000\
  MINUS\000\
  TIMES\000\
  DIV\000\
  EOF\000\
  "

let yynames_block = "\
  IDENT\000\
  STRING\000\
  INTNUM\000\
  FLOATNUM\000\
  COMPARISON\000\
  "

let yyact = [|
  (fun _ -> failwith "parser")
; (fun parser_env ->
    Obj.repr((
# 72 "parser.mly"
                 () ) :  unit ))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'query_exp) in
    let _2 = (peek_val parser_env 1 : 'opt_order_by_clause) in
    let _3 = (peek_val parser_env 0 : 'endsql) in
    Obj.repr((
# 74 "parser.mly"
                                                      _1, _2 ) :  Sqlstx.query ))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'select_exp) in
    let _2 = (peek_val parser_env 1 : 'opt_order_by_clause) in
    let _3 = (peek_val parser_env 0 : 'endsql) in
    Obj.repr((
# 76 "parser.mly"
                                                           _1, _2 ) :  Sqlstx.select * Sqlstx.ordering list ))
; (fun parser_env ->
    Obj.repr((
# 79 "parser.mly"
                                                      ) : 'endsql))
; (fun parser_env ->
    Obj.repr((
# 80 "parser.mly"
                                                      ) : 'endsql))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'query_term) in
    Obj.repr((
# 87 "parser.mly"
                                        _1 ) : 'query_exp))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'query_exp) in
    let _3 = (peek_val parser_env 0 : 'query_term) in
    Obj.repr((
# 88 "parser.mly"
                                         `union (_1, _3) ) : 'query_exp))
; (fun parser_env ->
    let _1 = (peek_val parser_env 3 : 'query_exp) in
    let _4 = (peek_val parser_env 0 : 'query_term) in
    Obj.repr((
# 89 "parser.mly"
                                         `unionall (_1, _4) ) : 'query_exp))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'select_exp) in
    Obj.repr((
# 93 "parser.mly"
                                        `select _1 ) : 'query_term))
; (fun parser_env ->
    let _2 = (peek_val parser_env 1 : 'query_exp) in
    Obj.repr((
# 94 "parser.mly"
                                         _2 ) : 'query_term))
; (fun parser_env ->
    let _2 = (peek_val parser_env 2 : 'opt_all_distinct) in
    let _3 = (peek_val parser_env 1 : 'selection) in
    let _4 = (peek_val parser_env 0 : 'table_exp) in
    Obj.repr((
# 98 "parser.mly"
                                                   let a, b, c, d = _4 in _2, _3, a, b, c, d ) : 'select_exp))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'rev_scalar_exp_commalist) in
    Obj.repr((
# 102 "parser.mly"
                                            `list (List.rev _1) ) : 'selection))
; (fun parser_env ->
    Obj.repr((
# 103 "parser.mly"
                                         `star ) : 'selection))
; (fun parser_env ->
    let _1 = (peek_val parser_env 3 : 'from_clause) in
    let _2 = (peek_val parser_env 2 : 'opt_where_clause) in
    let _3 = (peek_val parser_env 1 : 'opt_group_by_clause) in
    let _4 = (peek_val parser_env 0 : 'opt_having_clause) in
    Obj.repr((
# 111 "parser.mly"
                                                         _1, _2, _3, _4 ) : 'table_exp))
; (fun parser_env ->
    let _2 = (peek_val parser_env 0 : 'rev_table_ref_commalist) in
    Obj.repr((
# 115 "parser.mly"
                                            List.rev _2 ) : 'from_clause))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'table_ref) in
    Obj.repr((
# 119 "parser.mly"
                                        [_1] ) : 'rev_table_ref_commalist))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'rev_table_ref_commalist) in
    let _3 = (peek_val parser_env 0 : 'table_ref) in
    Obj.repr((
# 120 "parser.mly"
                                             _3 :: _1 ) : 'rev_table_ref_commalist))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'table) in
    Obj.repr((
# 124 "parser.mly"
                                        `table _1 ) : 'table_ref))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'table) in
    let _3 = (peek_val parser_env 0 :  string ) in
    Obj.repr((
# 125 "parser.mly"
                                          `tableas (_1, _3) ) : 'table_ref))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 :  string ) in
    Obj.repr((
# 129 "parser.mly"
                                         _1 ) : 'table))
; (fun parser_env ->
    let _2 = (peek_val parser_env 0 : 'search_condition) in
    Obj.repr((
# 134 "parser.mly"
                                        _2 ) : 'where_clause))
; (fun parser_env ->
    Obj.repr((
# 138 "parser.mly"
                                        None ) : 'opt_where_clause))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'where_clause) in
    Obj.repr((
# 139 "parser.mly"
                                         Some _1 ) : 'opt_where_clause))
; (fun parser_env ->
    Obj.repr((
# 143 "parser.mly"
                                        `nomod ) : 'opt_all_distinct))
; (fun parser_env ->
    Obj.repr((
# 144 "parser.mly"
                                         `all ) : 'opt_all_distinct))
; (fun parser_env ->
    Obj.repr((
# 145 "parser.mly"
                                         `distinct ) : 'opt_all_distinct))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'scalar_exp) in
    let _3 = (peek_val parser_env 0 : 'scalar_exp) in
    Obj.repr((
# 151 "parser.mly"
                                          `binop (`plus, _1, _3) ) : 'scalar_exp))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'scalar_exp) in
    let _3 = (peek_val parser_env 0 : 'scalar_exp) in
    Obj.repr((
# 152 "parser.mly"
                                           `binop (`minus, _1, _3) ) : 'scalar_exp))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'scalar_exp) in
    let _3 = (peek_val parser_env 0 : 'scalar_exp) in
    Obj.repr((
# 153 "parser.mly"
                                           `binop (`times, _1, _3) ) : 'scalar_exp))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'scalar_exp) in
    let _3 = (peek_val parser_env 0 : 'scalar_exp) in
    Obj.repr((
# 154 "parser.mly"
                                           `binop (`div, _1, _3) ) : 'scalar_exp))
; (fun parser_env ->
    let _2 = (peek_val parser_env 0 : 'scalar_exp) in
    Obj.repr((
# 155 "parser.mly"
                                           _2 ) : 'scalar_exp))
; (fun parser_env ->
    let _2 = (peek_val parser_env 0 : 'scalar_exp) in
    Obj.repr((
# 156 "parser.mly"
                                           `uminus _2 ) : 'scalar_exp))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'atom) in
    Obj.repr((
# 157 "parser.mly"
                                           `atom _1 ) : 'scalar_exp))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'column_ref) in
    Obj.repr((
# 158 "parser.mly"
                                           `column _1 ) : 'scalar_exp))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'function_ref) in
    Obj.repr((
# 159 "parser.mly"
                                           `functioncall _1 ) : 'scalar_exp))
; (fun parser_env ->
    let _2 = (peek_val parser_env 1 : 'scalar_exp) in
    Obj.repr((
# 160 "parser.mly"
                                           _2 ) : 'scalar_exp))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'scalar_exp) in
    Obj.repr((
# 164 "parser.mly"
                                          [_1] ) : 'rev_scalar_exp_commalist))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'rev_scalar_exp_commalist) in
    let _3 = (peek_val parser_env 0 : 'scalar_exp) in
    Obj.repr((
# 165 "parser.mly"
                                               _3 :: _1 ) : 'rev_scalar_exp_commalist))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'parameter_ref) in
    Obj.repr((
# 169 "parser.mly"
                                          `parameter _1 ) : 'atom))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'literal) in
    Obj.repr((
# 170 "parser.mly"
                                           (_1 :> atom) ) : 'atom))
; (fun parser_env ->
    Obj.repr((
# 171 "parser.mly"
                                           `user ) : 'atom))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'parameter) in
    Obj.repr((
# 175 "parser.mly"
                                          `single _1 ) : 'parameter_ref))
; (fun parser_env ->
    let _1 = (peek_val parser_env 1 : 'parameter) in
    let _2 = (peek_val parser_env 0 : 'parameter) in
    Obj.repr((
# 176 "parser.mly"
                                           `couple (_1, _2) ) : 'parameter_ref))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'parameter) in
    let _3 = (peek_val parser_env 0 : 'parameter) in
    Obj.repr((
# 177 "parser.mly"
                                           `indicator (_1, _3) ) : 'parameter_ref))
; (fun parser_env ->
    let _1 = (peek_val parser_env 3 : 'ammsc) in
    Obj.repr((
# 181 "parser.mly"
                                              _1, `star ) : 'function_ref))
; (fun parser_env ->
    let _1 = (peek_val parser_env 4 : 'ammsc) in
    let _4 = (peek_val parser_env 1 : 'column_ref) in
    Obj.repr((
# 182 "parser.mly"
                                               _1, `distinct _4 ) : 'function_ref))
; (fun parser_env ->
    let _1 = (peek_val parser_env 4 : 'ammsc) in
    let _4 = (peek_val parser_env 1 : 'scalar_exp) in
    Obj.repr((
# 183 "parser.mly"
                                               _1, `exp (`all, _4) ) : 'function_ref))
; (fun parser_env ->
    let _1 = (peek_val parser_env 3 : 'ammsc) in
    let _3 = (peek_val parser_env 1 : 'scalar_exp) in
    Obj.repr((
# 184 "parser.mly"
                                               _1, `exp (`nomod, _3) ) : 'function_ref))
; (fun parser_env ->
    Obj.repr((
# 188 "parser.mly"
                         `avg ) : 'ammsc))
; (fun parser_env ->
    Obj.repr((
# 189 "parser.mly"
                  `min ) : 'ammsc))
; (fun parser_env ->
    Obj.repr((
# 190 "parser.mly"
                  `max ) : 'ammsc))
; (fun parser_env ->
    Obj.repr((
# 191 "parser.mly"
                  `sum ) : 'ammsc))
; (fun parser_env ->
    Obj.repr((
# 192 "parser.mly"
                  `count ) : 'ammsc))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 :  string ) in
    Obj.repr((
# 193 "parser.mly"
                  `other _1 ) : 'ammsc))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 :  string ) in
    Obj.repr((
# 196 "parser.mly"
                    `string _1 ) : 'literal))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 :  [`int of int | `inttoomuch of string] ) in
    Obj.repr((
# 197 "parser.mly"
                     _1 :> literal ) : 'literal))
; (fun parser_env ->
    Obj.repr((
# 202 "parser.mly"
                                     None ) : 'opt_group_by_clause))
; (fun parser_env ->
    let _3 = (peek_val parser_env 0 : 'rev_column_ref_commalist) in
    Obj.repr((
# 203 "parser.mly"
                                          Some (List.rev _3) ) : 'opt_group_by_clause))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'column_ref) in
    Obj.repr((
# 207 "parser.mly"
                                           [_1] ) : 'rev_column_ref_commalist))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'rev_column_ref_commalist) in
    let _3 = (peek_val parser_env 0 : 'column_ref) in
    Obj.repr((
# 208 "parser.mly"
                                                _3 :: _1 ) : 'rev_column_ref_commalist))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 :  string ) in
    Obj.repr((
# 212 "parser.mly"
                        `ref _1 ) : 'column_ref))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 :  string ) in
    let _3 = (peek_val parser_env 0 :  string ) in
    Obj.repr((
# 213 "parser.mly"
                        `refdotref (_1, _3) ) : 'column_ref))
; (fun parser_env ->
    Obj.repr((
# 219 "parser.mly"
                              None ) : 'opt_having_clause))
; (fun parser_env ->
    let _2 = (peek_val parser_env 0 : 'search_condition) in
    Obj.repr((
# 220 "parser.mly"
                               Some _2 ) : 'opt_having_clause))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'search_condition) in
    let _3 = (peek_val parser_env 0 : 'search_condition) in
    Obj.repr((
# 227 "parser.mly"
                                            `cor (_1, _3) ) : 'search_condition))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'search_condition) in
    let _3 = (peek_val parser_env 0 : 'search_condition) in
    Obj.repr((
# 228 "parser.mly"
                                            `cand (_1, _3) ) : 'search_condition))
; (fun parser_env ->
    let _2 = (peek_val parser_env 0 : 'search_condition) in
    Obj.repr((
# 229 "parser.mly"
                                            `cnot _2 ) : 'search_condition))
; (fun parser_env ->
    let _2 = (peek_val parser_env 1 : 'search_condition) in
    Obj.repr((
# 230 "parser.mly"
                                            _2 ) : 'search_condition))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'predicate) in
    Obj.repr((
# 231 "parser.mly"
                                            `p _1 ) : 'search_condition))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'comparison_predicate) in
    Obj.repr((
# 235 "parser.mly"
                                           _1 ) : 'predicate))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'between_predicate) in
    Obj.repr((
# 236 "parser.mly"
                                            _1 ) : 'predicate))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'like_predicate) in
    Obj.repr((
# 237 "parser.mly"
                                            _1 ) : 'predicate))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'test_for_null) in
    Obj.repr((
# 238 "parser.mly"
                                            _1 ) : 'predicate))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'in_predicate) in
    Obj.repr((
# 239 "parser.mly"
                                            _1 ) : 'predicate))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'all_or_any_predicate) in
    Obj.repr((
# 240 "parser.mly"
                                            _1 ) : 'predicate))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'existence_test) in
    Obj.repr((
# 241 "parser.mly"
                                            _1 ) : 'predicate))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'scalar_exp) in
    let _2 = (peek_val parser_env 1 :  Sqlstx.comparison ) in
    let _3 = (peek_val parser_env 0 : 'scalar_exp) in
    Obj.repr((
# 245 "parser.mly"
                                                           `comparisonexp (_1, _2, _3) ) : 'comparison_predicate))
; (fun parser_env ->
    let _1 = (peek_val parser_env 4 : 'scalar_exp) in
    let _2 = (peek_val parser_env 3 :  Sqlstx.comparison ) in
    let _4 = (peek_val parser_env 1 : 'select_exp) in
    Obj.repr((
# 246 "parser.mly"
                                                                `comparisonselect (_1, _2, _4) ) : 'comparison_predicate))
; (fun parser_env ->
    let _1 = (peek_val parser_env 5 : 'scalar_exp) in
    let _4 = (peek_val parser_env 2 : 'scalar_exp) in
    let _6 = (peek_val parser_env 0 : 'scalar_exp) in
    Obj.repr((
# 250 "parser.mly"
                                                           `between (true, _1, _4, _6) ) : 'between_predicate))
; (fun parser_env ->
    let _1 = (peek_val parser_env 4 : 'scalar_exp) in
    let _3 = (peek_val parser_env 2 : 'scalar_exp) in
    let _5 = (peek_val parser_env 0 : 'scalar_exp) in
    Obj.repr((
# 251 "parser.mly"
                                                            `between (false, _1, _3, _5) ) : 'between_predicate))
; (fun parser_env ->
    let _1 = (peek_val parser_env 4 : 'scalar_exp) in
    let _4 = (peek_val parser_env 1 : 'atom) in
    let _5 = (peek_val parser_env 0 : 'opt_escape) in
    Obj.repr((
# 255 "parser.mly"
                                                           `like (true, _1, _4, _5) ) : 'like_predicate))
; (fun parser_env ->
    let _1 = (peek_val parser_env 3 : 'scalar_exp) in
    let _3 = (peek_val parser_env 1 : 'atom) in
    let _4 = (peek_val parser_env 0 : 'opt_escape) in
    Obj.repr((
# 256 "parser.mly"
                                                            `like (false, _1, _3, _4) ) : 'like_predicate))
; (fun parser_env ->
    Obj.repr((
# 260 "parser.mly"
                                                           None ) : 'opt_escape))
; (fun parser_env ->
    let _2 = (peek_val parser_env 0 : 'atom) in
    Obj.repr((
# 261 "parser.mly"
                                                            Some _2 ) : 'opt_escape))
; (fun parser_env ->
    let _1 = (peek_val parser_env 3 : 'column_ref) in
    Obj.repr((
# 265 "parser.mly"
                                                           `iscolnull (true, _1) ) : 'test_for_null))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'column_ref) in
    Obj.repr((
# 266 "parser.mly"
                                                            `iscolnull (false, _1) ) : 'test_for_null))
; (fun parser_env ->
    let _1 = (peek_val parser_env 5 : 'scalar_exp) in
    let _5 = (peek_val parser_env 1 : 'select_exp) in
    Obj.repr((
# 270 "parser.mly"
                                                               `in_select (true, _1, _5) ) : 'in_predicate))
; (fun parser_env ->
    let _1 = (peek_val parser_env 4 : 'scalar_exp) in
    let _4 = (peek_val parser_env 1 : 'select_exp) in
    Obj.repr((
# 271 "parser.mly"
                                                                `in_select (false, _1, _4) ) : 'in_predicate))
; (fun parser_env ->
    let _1 = (peek_val parser_env 5 : 'scalar_exp) in
    let _5 = (peek_val parser_env 1 : 'rev_atom_commalist) in
    Obj.repr((
# 272 "parser.mly"
                                                            `in_atom_list (true, _1, List.rev _5) ) : 'in_predicate))
; (fun parser_env ->
    let _1 = (peek_val parser_env 4 : 'scalar_exp) in
    let _4 = (peek_val parser_env 1 : 'rev_atom_commalist) in
    Obj.repr((
# 273 "parser.mly"
                                                            `in_atom_list (false, _1, List.rev _4) ) : 'in_predicate))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'atom) in
    Obj.repr((
# 277 "parser.mly"
                                                           [_1] ) : 'rev_atom_commalist))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'rev_atom_commalist) in
    let _3 = (peek_val parser_env 0 : 'atom) in
    Obj.repr((
# 278 "parser.mly"
                                                            _3 :: _1 ) : 'rev_atom_commalist))
; (fun parser_env ->
    let _1 = (peek_val parser_env 5 : 'scalar_exp) in
    let _2 = (peek_val parser_env 4 :  Sqlstx.comparison ) in
    let _3 = (peek_val parser_env 3 : 'any_all_some) in
    let _5 = (peek_val parser_env 1 : 'select_exp) in
    Obj.repr((
# 282 "parser.mly"
                                                                `allorany (_1, _2, _3, _5) ) : 'all_or_any_predicate))
; (fun parser_env ->
    Obj.repr((
# 286 "parser.mly"
                `some ) : 'any_all_some))
; (fun parser_env ->
    Obj.repr((
# 287 "parser.mly"
                 `all ) : 'any_all_some))
; (fun parser_env ->
    Obj.repr((
# 288 "parser.mly"
                 `some ) : 'any_all_some))
; (fun parser_env ->
    let _3 = (peek_val parser_env 1 : 'select_exp) in
    Obj.repr((
# 292 "parser.mly"
                                                             `exists _3 ) : 'existence_test))
; (fun parser_env ->
    let _2 = (peek_val parser_env 0 :  string ) in
    Obj.repr((
# 296 "parser.mly"
                                                             _2 ) : 'parameter))
; (fun parser_env ->
    let _1 = (peek_val parser_env 1 :  Sqlstx.cmd ) in
    let _2 = (peek_val parser_env 0 : 'endsql) in
    Obj.repr((
# 302 "parser.mly"
                                    [_1] ) :  Sqlstx.cmd list ))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 :  Sqlstx.cmd ) in
    let _3 = (peek_val parser_env 0 :  Sqlstx.cmd list ) in
    Obj.repr((
# 303 "parser.mly"
                                     _1 :: _3 ) :  Sqlstx.cmd list ))
; (fun parser_env ->
    let _3 = (peek_val parser_env 2 : 'table) in
    let _4 = (peek_val parser_env 1 : 'opt_column_commalist) in
    let _5 = (peek_val parser_env 0 : 'values_or_select_exp) in
    Obj.repr((
# 308 "parser.mly"
                                                                    _3, _4, _5 ) : 'insert_statement))
; (fun parser_env ->
    let _3 = (peek_val parser_env 1 : 'rev_insert_atom_commalist) in
    Obj.repr((
# 312 "parser.mly"
                                                                    `values (List.rev _3) ) : 'values_or_select_exp))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'select_exp) in
    Obj.repr((
# 313 "parser.mly"
                                                                     `select _1 ) : 'values_or_select_exp))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'insert_atom) in
    Obj.repr((
# 317 "parser.mly"
                                                                    [ _1 ] ) : 'rev_insert_atom_commalist))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'rev_insert_atom_commalist) in
    let _3 = (peek_val parser_env 0 : 'insert_atom) in
    Obj.repr((
# 318 "parser.mly"
                                                                     _3 :: _1 ) : 'rev_insert_atom_commalist))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'atom) in
    Obj.repr((
# 322 "parser.mly"
                                                                    `atom _1 ) : 'insert_atom))
; (fun parser_env ->
    Obj.repr((
# 323 "parser.mly"
                                                                     `null ) : 'insert_atom))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'schema) in
    Obj.repr((
# 329 "parser.mly"
               `schemadef _1 ) :  Sqlstx.cmd ))
; (fun parser_env ->
    let _4 = (peek_val parser_env 1 : 'user) in
    let _5 = (peek_val parser_env 0 : 'opt_schema_element_list) in
    Obj.repr((
# 334 "parser.mly"
                                                             _4, _5 ) : 'schema))
; (fun parser_env ->
    Obj.repr((
# 338 "parser.mly"
                [] ) : 'opt_schema_element_list))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'rev_schema_element_list) in
    Obj.repr((
# 339 "parser.mly"
                             List.rev _1 ) : 'opt_schema_element_list))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'schema_element) in
    Obj.repr((
# 343 "parser.mly"
                                           [ _1 ] ) : 'rev_schema_element_list))
; (fun parser_env ->
    let _1 = (peek_val parser_env 1 : 'rev_schema_element_list) in
    let _2 = (peek_val parser_env 0 : 'schema_element) in
    Obj.repr((
# 344 "parser.mly"
                                            _2 :: _1 ) : 'rev_schema_element_list))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'base_table_def) in
    Obj.repr((
# 348 "parser.mly"
                          `tabledef _1 ) : 'schema_element))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'view_def) in
    Obj.repr((
# 349 "parser.mly"
                           `viewdef _1 ) : 'schema_element))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'privilege_def) in
    Obj.repr((
# 350 "parser.mly"
                           `privdef _1 ) : 'schema_element))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'schema_element) in
    Obj.repr((
# 353 "parser.mly"
                                 _1 :> cmd ) :  Sqlstx.cmd ))
; (fun parser_env ->
    let _3 = (peek_val parser_env 3 : 'table) in
    let _5 = (peek_val parser_env 1 : 'base_table_element_commalist) in
    Obj.repr((
# 357 "parser.mly"
                                                                  _3, _5 ) : 'base_table_def))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'base_table_element) in
    Obj.repr((
# 361 "parser.mly"
                       [ _1 ] ) : 'base_table_element_commalist))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'base_table_element_commalist) in
    let _3 = (peek_val parser_env 0 : 'base_table_element) in
    Obj.repr((
# 362 "parser.mly"
                                                           _1 @ [ _3 ] ) : 'base_table_element_commalist))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'column_def) in
    Obj.repr((
# 366 "parser.mly"
                              `columndef _1 ) : 'base_table_element))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'table_constraint_def) in
    Obj.repr((
# 367 "parser.mly"
                               `tblcnstr _1 ) : 'base_table_element))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 :  string ) in
    Obj.repr((
# 370 "parser.mly"
                 _1 ) : 'column))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'column) in
    let _2 = (peek_val parser_env 1 : 'data_type) in
    let _3 = (peek_val parser_env 0 : 'column_def_opt_list) in
    Obj.repr((
# 374 "parser.mly"
                                         _1, _2, _3 ) : 'column_def))
; (fun parser_env ->
    Obj.repr((
# 379 "parser.mly"
                                                                `char None) : 'data_type))
; (fun parser_env ->
    let _3 = (peek_val parser_env 1 :  [`int of int | `inttoomuch of string] ) in
    Obj.repr((
# 380 "parser.mly"
                                                                 `char (Some (normal_int _3)) ) : 'data_type))
; (fun parser_env ->
    Obj.repr((
# 381 "parser.mly"
                                                                 `numeric `default ) : 'data_type))
; (fun parser_env ->
    let _3 = (peek_val parser_env 1 :  [`int of int | `inttoomuch of string] ) in
    Obj.repr((
# 382 "parser.mly"
                                                                 `numeric (`length (normal_int _3)) ) : 'data_type))
; (fun parser_env ->
    let _3 = (peek_val parser_env 3 :  [`int of int | `inttoomuch of string] ) in
    let _5 = (peek_val parser_env 1 :  [`int of int | `inttoomuch of string] ) in
    Obj.repr((
# 383 "parser.mly"
                                                                 `numeric (`lengthdec (normal_int _3, normal_int _5)) ) : 'data_type))
; (fun parser_env ->
    Obj.repr((
# 384 "parser.mly"
                                                                 `decimal `default ) : 'data_type))
; (fun parser_env ->
    let _3 = (peek_val parser_env 1 :  [`int of int | `inttoomuch of string] ) in
    Obj.repr((
# 385 "parser.mly"
                                                                 `decimal (`length (normal_int _3)) ) : 'data_type))
; (fun parser_env ->
    let _3 = (peek_val parser_env 3 :  [`int of int | `inttoomuch of string] ) in
    let _5 = (peek_val parser_env 1 :  [`int of int | `inttoomuch of string] ) in
    Obj.repr((
# 386 "parser.mly"
                                                                 `decimal (`lengthdec (normal_int _3, normal_int _5)) ) : 'data_type))
; (fun parser_env ->
    Obj.repr((
# 387 "parser.mly"
                                                                 `int ) : 'data_type))
; (fun parser_env ->
    Obj.repr((
# 388 "parser.mly"
                                                                 `smallint ) : 'data_type))
; (fun parser_env ->
    Obj.repr((
# 389 "parser.mly"
                                                                 `float None ) : 'data_type))
; (fun parser_env ->
    let _3 = (peek_val parser_env 1 :  [`int of int | `inttoomuch of string] ) in
    Obj.repr((
# 390 "parser.mly"
                                                                 `float (Some (normal_int _3)) ) : 'data_type))
; (fun parser_env ->
    Obj.repr((
# 391 "parser.mly"
                                                                 `real ) : 'data_type))
; (fun parser_env ->
    Obj.repr((
# 392 "parser.mly"
                                                                 `doubleprecision ) : 'data_type))
; (fun parser_env ->
    Obj.repr((
# 396 "parser.mly"
                [] ) : 'column_def_opt_list))
; (fun parser_env ->
    let _1 = (peek_val parser_env 1 : 'column_def_opt_list) in
    let _2 = (peek_val parser_env 0 : 'column_def_opt) in
    Obj.repr((
# 397 "parser.mly"
                                        _1 @ [_2] ) : 'column_def_opt_list))
; (fun parser_env ->
    Obj.repr((
# 401 "parser.mly"
                                                                `not_null ) : 'column_def_opt))
; (fun parser_env ->
    Obj.repr((
# 402 "parser.mly"
                                                                 `not_null_unique ) : 'column_def_opt))
; (fun parser_env ->
    Obj.repr((
# 403 "parser.mly"
                                                                 `not_null_primary_key ) : 'column_def_opt))
; (fun parser_env ->
    let _2 = (peek_val parser_env 0 : 'literal) in
    Obj.repr((
# 404 "parser.mly"
                                                                 `default _2 ) : 'column_def_opt))
; (fun parser_env ->
    Obj.repr((
# 405 "parser.mly"
                                                                 `default_null ) : 'column_def_opt))
; (fun parser_env ->
    Obj.repr((
# 406 "parser.mly"
                                                                 `default_user ) : 'column_def_opt))
; (fun parser_env ->
    let _3 = (peek_val parser_env 1 : 'search_condition) in
    Obj.repr((
# 407 "parser.mly"
                                                                 `check _3 ) : 'column_def_opt))
; (fun parser_env ->
    let _2 = (peek_val parser_env 0 : 'table) in
    Obj.repr((
# 408 "parser.mly"
                                                                 `references (_2, []) ) : 'column_def_opt))
; (fun parser_env ->
    let _2 = (peek_val parser_env 3 : 'table) in
    let _4 = (peek_val parser_env 1 : 'column_commalist) in
    Obj.repr((
# 409 "parser.mly"
                                                                 `references (_2, _4) ) : 'column_def_opt))
; (fun parser_env ->
    let _3 = (peek_val parser_env 1 : 'column_commalist) in
    Obj.repr((
# 413 "parser.mly"
                                                                `unique _3 ) : 'table_constraint_def))
; (fun parser_env ->
    let _4 = (peek_val parser_env 1 : 'column_commalist) in
    Obj.repr((
# 414 "parser.mly"
                                                                 `primkey _4 ) : 'table_constraint_def))
; (fun parser_env ->
    let _4 = (peek_val parser_env 3 : 'column_commalist) in
    let _7 = (peek_val parser_env 0 : 'table) in
    Obj.repr((
# 416 "parser.mly"
                                                         `foreignkey (_4, _7, []) ) : 'table_constraint_def))
; (fun parser_env ->
    let _4 = (peek_val parser_env 6 : 'column_commalist) in
    let _7 = (peek_val parser_env 3 : 'table) in
    let _9 = (peek_val parser_env 1 : 'column_commalist) in
    Obj.repr((
# 418 "parser.mly"
                                                         `foreignkey (_4, _7, _9) ) : 'table_constraint_def))
; (fun parser_env ->
    let _3 = (peek_val parser_env 1 : 'search_condition) in
    Obj.repr((
# 419 "parser.mly"
                                                                 `check _3 ) : 'table_constraint_def))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'column) in
    Obj.repr((
# 424 "parser.mly"
                                                                [_1] ) : 'column_commalist))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'column_commalist) in
    let _3 = (peek_val parser_env 0 : 'column) in
    Obj.repr((
# 425 "parser.mly"
                                                                 _1 @ [_3] ) : 'column_commalist))
; (fun parser_env ->
    Obj.repr((
# 429 "parser.mly"
                                                                [] ) : 'opt_column_commalist))
; (fun parser_env ->
    let _2 = (peek_val parser_env 1 : 'column_commalist) in
    Obj.repr((
# 430 "parser.mly"
                                                                 _2 ) : 'opt_column_commalist))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 :  string ) in
    Obj.repr((
# 433 "parser.mly"
                            _1 ) : 'user))
; (fun parser_env ->
    let _3 = (peek_val parser_env 4 : 'table) in
    let _4 = (peek_val parser_env 3 : 'opt_column_commalist) in
    let _6 = (peek_val parser_env 1 : 'select_exp) in
    let _7 = (peek_val parser_env 0 : 'opt_with_check_option) in
    Obj.repr((
# 438 "parser.mly"
                                                                _3, _4, _6, _7 ) : 'view_def))
; (fun parser_env ->
    Obj.repr((
# 442 "parser.mly"
                                                                `nocheck ) : 'opt_with_check_option))
; (fun parser_env ->
    Obj.repr((
# 443 "parser.mly"
                                                                 `check ) : 'opt_with_check_option))
; (fun parser_env ->
    let _2 = (peek_val parser_env 5 : 'privileges) in
    let _4 = (peek_val parser_env 3 : 'table) in
    let _6 = (peek_val parser_env 1 : 'grantee_commalist) in
    let _7 = (peek_val parser_env 0 : 'opt_with_grant_option) in
    Obj.repr((
# 449 "parser.mly"
                                                                _2, _4, _6, _7 ) : 'privilege_def))
; (fun parser_env ->
    Obj.repr((
# 453 "parser.mly"
                                                                `nograntoption ) : 'opt_with_grant_option))
; (fun parser_env ->
    Obj.repr((
# 454 "parser.mly"
                                                                 `grantoption ) : 'opt_with_grant_option))
; (fun parser_env ->
    Obj.repr((
# 458 "parser.mly"
                                                                `all ) : 'privileges))
; (fun parser_env ->
    Obj.repr((
# 459 "parser.mly"
                                                                 `all ) : 'privileges))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'operation_commalist) in
    Obj.repr((
# 460 "parser.mly"
                                                                 `some _1 ) : 'privileges))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'operation) in
    Obj.repr((
# 464 "parser.mly"
                                                                [_1] ) : 'operation_commalist))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'operation_commalist) in
    let _3 = (peek_val parser_env 0 : 'operation) in
    Obj.repr((
# 465 "parser.mly"
                                                                 _1 @ [_3] ) : 'operation_commalist))
; (fun parser_env ->
    Obj.repr((
# 469 "parser.mly"
                                                                `select ) : 'operation))
; (fun parser_env ->
    Obj.repr((
# 470 "parser.mly"
                                                                 `insert ) : 'operation))
; (fun parser_env ->
    Obj.repr((
# 471 "parser.mly"
                                                                 `delete ) : 'operation))
; (fun parser_env ->
    let _2 = (peek_val parser_env 0 : 'opt_column_commalist) in
    Obj.repr((
# 472 "parser.mly"
                                                                 `update _2 ) : 'operation))
; (fun parser_env ->
    let _2 = (peek_val parser_env 0 : 'opt_column_commalist) in
    Obj.repr((
# 473 "parser.mly"
                                                                 `references _2 ) : 'operation))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'grantee) in
    Obj.repr((
# 478 "parser.mly"
                                                                [_1] ) : 'grantee_commalist))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'grantee_commalist) in
    let _3 = (peek_val parser_env 0 : 'grantee) in
    Obj.repr((
# 479 "parser.mly"
                                                                 _1 @ [_3] ) : 'grantee_commalist))
; (fun parser_env ->
    Obj.repr((
# 483 "parser.mly"
                                                                `public ) : 'grantee))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'user) in
    Obj.repr((
# 484 "parser.mly"
                                                                 `user _1 ) : 'grantee))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'module_def) in
    Obj.repr((
# 488 "parser.mly"
                                                                    `moduledef _1 ) :  Sqlstx.cmd ))
; (fun parser_env ->
    let _2 = (peek_val parser_env 6 : 'opt_module) in
    let _4 = (peek_val parser_env 4 : 'lang) in
    let _6 = (peek_val parser_env 2 : 'user) in
    let _7 = (peek_val parser_env 1 : 'opt_cursor_def_list) in
    let _8 = (peek_val parser_env 0 : 'procedure_def_list) in
    Obj.repr((
# 496 "parser.mly"
                                                                _2, _4, _6, _7, _8 ) : 'module_def))
; (fun parser_env ->
    Obj.repr((
# 500 "parser.mly"
                                                                None ) : 'opt_module))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'sqlmodule) in
    Obj.repr((
# 501 "parser.mly"
                                                                 Some _1 ) : 'opt_module))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 :  string ) in
    Obj.repr((
# 504 "parser.mly"
                    _1 ) : 'sqlmodule))
; (fun parser_env ->
    Obj.repr((
# 508 "parser.mly"
                                                                `cobol ) : 'lang))
; (fun parser_env ->
    Obj.repr((
# 509 "parser.mly"
                                                                 `fortran ) : 'lang))
; (fun parser_env ->
    Obj.repr((
# 510 "parser.mly"
                                                                 `pascal ) : 'lang))
; (fun parser_env ->
    Obj.repr((
# 511 "parser.mly"
                                                                 `pli ) : 'lang))
; (fun parser_env ->
    Obj.repr((
# 512 "parser.mly"
                                                                 `c ) : 'lang))
; (fun parser_env ->
    Obj.repr((
# 513 "parser.mly"
                                                                 `ada ) : 'lang))
; (fun parser_env ->
    Obj.repr((
# 514 "parser.mly"
                                                                       `ocaml ) : 'lang))
; (fun parser_env ->
    Obj.repr((
# 518 "parser.mly"
                                                                [] ) : 'opt_cursor_def_list))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'cursor_def_list) in
    Obj.repr((
# 519 "parser.mly"
                                                                 _1 ) : 'opt_cursor_def_list))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'cursor_def) in
    Obj.repr((
# 523 "parser.mly"
                                                                [_1] ) : 'cursor_def_list))
; (fun parser_env ->
    let _1 = (peek_val parser_env 1 : 'cursor_def_list) in
    let _2 = (peek_val parser_env 0 : 'cursor_def) in
    Obj.repr((
# 524 "parser.mly"
                                                                 _1 @ [_2] ) : 'cursor_def_list))
; (fun parser_env ->
    let _2 = (peek_val parser_env 4 : 'cursor) in
    let _5 = (peek_val parser_env 1 : 'query_exp) in
    let _6 = (peek_val parser_env 0 : 'opt_order_by_clause) in
    Obj.repr((
# 528 "parser.mly"
                                                                _2, _5, _6 ) : 'cursor_def))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 :  string ) in
    Obj.repr((
# 531 "parser.mly"
                 _1 ) : 'cursor))
; (fun parser_env ->
    Obj.repr((
# 536 "parser.mly"
                                                                [] ) : 'opt_order_by_clause))
; (fun parser_env ->
    let _3 = (peek_val parser_env 0 : 'ordering_spec_commalist) in
    Obj.repr((
# 537 "parser.mly"
                                                                 _3 ) : 'opt_order_by_clause))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'ordering_spec) in
    Obj.repr((
# 541 "parser.mly"
                                                                [_1] ) : 'ordering_spec_commalist))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'ordering_spec_commalist) in
    let _3 = (peek_val parser_env 0 : 'ordering_spec) in
    Obj.repr((
# 542 "parser.mly"
                                                                 _1 @ [_3] ) : 'ordering_spec_commalist))
; (fun parser_env ->
    let _1 = (peek_val parser_env 1 :  [`int of int | `inttoomuch of string] ) in
    let _2 = (peek_val parser_env 0 : 'opt_asc_desc) in
    Obj.repr((
# 546 "parser.mly"
                                                                `numcolumn (normal_int _1), _2 ) : 'ordering_spec))
; (fun parser_env ->
    let _1 = (peek_val parser_env 1 : 'column_ref) in
    let _2 = (peek_val parser_env 0 : 'opt_asc_desc) in
    Obj.repr((
# 547 "parser.mly"
                                                                 `column _1, _2 ) : 'ordering_spec))
; (fun parser_env ->
    Obj.repr((
# 551 "parser.mly"
                                                                None ) : 'opt_asc_desc))
; (fun parser_env ->
    Obj.repr((
# 552 "parser.mly"
                                                                 Some `asc ) : 'opt_asc_desc))
; (fun parser_env ->
    Obj.repr((
# 553 "parser.mly"
                                                                 Some `desc ) : 'opt_asc_desc))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'procedure_def) in
    Obj.repr((
# 557 "parser.mly"
                                                                [_1] ) : 'procedure_def_list))
; (fun parser_env ->
    let _1 = (peek_val parser_env 1 : 'procedure_def_list) in
    let _2 = (peek_val parser_env 0 : 'procedure_def) in
    Obj.repr((
# 558 "parser.mly"
                                                                 _1 @ [_2] ) : 'procedure_def_list))
; (fun parser_env ->
    let _2 = (peek_val parser_env 3 : 'procedure) in
    let _3 = (peek_val parser_env 2 : 'parameter_def_list) in
    let _5 = (peek_val parser_env 0 : 'manipulative_statement_list) in
    Obj.repr((
# 563 "parser.mly"
                                                                _2, _3, _5 ) : 'procedure_def))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 :  string ) in
    Obj.repr((
# 566 "parser.mly"
                   _1 ) : 'procedure))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'manipulative_statement) in
    Obj.repr((
# 570 "parser.mly"
                                                                [_1] ) : 'manipulative_statement_list))
; (fun parser_env ->
    let _1 = (peek_val parser_env 1 : 'manipulative_statement_list) in
    let _2 = (peek_val parser_env 0 : 'manipulative_statement) in
    Obj.repr((
# 571 "parser.mly"
                                                                 _1 @ [_2] ) : 'manipulative_statement_list))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'parameter_def) in
    Obj.repr((
# 575 "parser.mly"
                                                                [_1] ) : 'parameter_def_list))
; (fun parser_env ->
    let _1 = (peek_val parser_env 1 : 'parameter_def_list) in
    let _2 = (peek_val parser_env 0 : 'parameter_def) in
    Obj.repr((
# 576 "parser.mly"
                                                                 _1 @ [_2] ) : 'parameter_def_list))
; (fun parser_env ->
    let _1 = (peek_val parser_env 1 : 'parameter) in
    let _2 = (peek_val parser_env 0 : 'data_type) in
    Obj.repr((
# 580 "parser.mly"
                                                                `par (_1, _2) ) : 'parameter_def))
; (fun parser_env ->
    Obj.repr((
# 581 "parser.mly"
                                                                 `sqlcode ) : 'parameter_def))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'manipulative_statement) in
    Obj.repr((
# 586 "parser.mly"
                                                                    `manip _1 ) :  Sqlstx.cmd ))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'close_statement) in
    Obj.repr((
# 590 "parser.mly"
                                                                `close _1 ) : 'manipulative_statement))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'commit_statement) in
    Obj.repr((
# 591 "parser.mly"
                                                                 `commit ) : 'manipulative_statement))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'delete_statement_positioned) in
    Obj.repr((
# 592 "parser.mly"
                                                                 `delete_pos _1 ) : 'manipulative_statement))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'delete_statement_searched) in
    Obj.repr((
# 593 "parser.mly"
                                                                 `delete_where _1 ) : 'manipulative_statement))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'fetch_statement) in
    Obj.repr((
# 594 "parser.mly"
                                                                 `fetch _1 ) : 'manipulative_statement))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'insert_statement) in
    Obj.repr((
# 595 "parser.mly"
                                                                 `insert _1 ) : 'manipulative_statement))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'open_statement) in
    Obj.repr((
# 596 "parser.mly"
                                                                 `opencursor _1 ) : 'manipulative_statement))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'rollback_statement) in
    Obj.repr((
# 597 "parser.mly"
                                                                 `rollback ) : 'manipulative_statement))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'select_statement) in
    Obj.repr((
# 598 "parser.mly"
                                                                 `select _1 ) : 'manipulative_statement))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'update_statement_positioned) in
    Obj.repr((
# 599 "parser.mly"
                                                                 `update_pos _1 ) : 'manipulative_statement))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'update_statement_searched) in
    Obj.repr((
# 600 "parser.mly"
                                                                 `update_where _1 ) : 'manipulative_statement))
; (fun parser_env ->
    let _2 = (peek_val parser_env 0 : 'cursor) in
    Obj.repr((
# 604 "parser.mly"
                                                                _2 ) : 'close_statement))
; (fun parser_env ->
    Obj.repr((
# 608 "parser.mly"
                                                                () ) : 'commit_statement))
; (fun parser_env ->
    let _3 = (peek_val parser_env 4 : 'table) in
    let _7 = (peek_val parser_env 0 : 'cursor) in
    Obj.repr((
# 612 "parser.mly"
                                                                _3, _7 ) : 'delete_statement_positioned))
; (fun parser_env ->
    let _3 = (peek_val parser_env 1 : 'table) in
    let _4 = (peek_val parser_env 0 : 'opt_where_clause) in
    Obj.repr((
# 616 "parser.mly"
                                                                _3, _4 ) : 'delete_statement_searched))
; (fun parser_env ->
    let _2 = (peek_val parser_env 2 : 'cursor) in
    let _4 = (peek_val parser_env 0 : 'target_commalist) in
    Obj.repr((
# 620 "parser.mly"
                                                                _2, _4 ) : 'fetch_statement))
; (fun parser_env ->
    let _2 = (peek_val parser_env 0 : 'cursor) in
    Obj.repr((
# 624 "parser.mly"
                                                                _2 ) : 'open_statement))
; (fun parser_env ->
    Obj.repr((
# 628 "parser.mly"
                                                                () ) : 'rollback_statement))
; (fun parser_env ->
    let _2 = (peek_val parser_env 4 : 'opt_all_distinct) in
    let _3 = (peek_val parser_env 3 : 'selection) in
    let _5 = (peek_val parser_env 1 : 'target_commalist) in
    let _6 = (peek_val parser_env 0 : 'table_exp) in
    Obj.repr((
# 634 "parser.mly"
                                                                let a, b, c, d = _6 in (_2, _3, a, b, c, d), _5 ) : 'select_statement))
; (fun parser_env ->
    let _2 = (peek_val parser_env 6 : 'table) in
    let _4 = (peek_val parser_env 4 : 'assignment_commalist) in
    let _8 = (peek_val parser_env 0 : 'cursor) in
    Obj.repr((
# 639 "parser.mly"
                                                                _2, _4, _8 ) : 'update_statement_positioned))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'assignment) in
    Obj.repr((
# 643 "parser.mly"
                                                                 [_1] ) : 'assignment_commalist))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'assignment_commalist) in
    let _3 = (peek_val parser_env 0 : 'assignment) in
    Obj.repr((
# 644 "parser.mly"
                                                                 _1 @ [_3] ) : 'assignment_commalist))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'column) in
    let _2 = (peek_val parser_env 1 :  Sqlstx.comparison ) in
    let _3 = (peek_val parser_env 0 : 'scalar_exp) in
    Obj.repr((
# 648 "parser.mly"
                                                                if _2 <> `eq 
									      then parse_error "assignment expected" 
									      else `column_exp (_1, _3) ) : 'assignment))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'column) in
    let _2 = (peek_val parser_env 1 :  Sqlstx.comparison ) in
    Obj.repr((
# 651 "parser.mly"
                                                                 if _2 <> `eq 
									      then parse_error "assignment expected" 
									      else `column_null _1 ) : 'assignment))
; (fun parser_env ->
    let _2 = (peek_val parser_env 3 : 'table) in
    let _4 = (peek_val parser_env 1 : 'assignment_commalist) in
    let _5 = (peek_val parser_env 0 : 'opt_where_clause) in
    Obj.repr((
# 657 "parser.mly"
                                                                _2, _4, _5 ) : 'update_statement_searched))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'target) in
    Obj.repr((
# 661 "parser.mly"
                                                                [_1] ) : 'target_commalist))
; (fun parser_env ->
    let _1 = (peek_val parser_env 2 : 'target_commalist) in
    let _3 = (peek_val parser_env 0 : 'target) in
    Obj.repr((
# 662 "parser.mly"
                                                                 _1 @ [_3] ) : 'target_commalist))
; (fun parser_env ->
    let _1 = (peek_val parser_env 0 : 'parameter_ref) in
    Obj.repr((
# 666 "parser.mly"
                                                                _1 ) : 'target))
; (fun parser_env ->
    let _4 = (peek_val parser_env 0 : 'when_action) in
    Obj.repr((
# 671 "parser.mly"
                                                                    `when_not_found _4 ) :  Sqlstx.cmd ))
; (fun parser_env ->
    let _3 = (peek_val parser_env 0 : 'when_action) in
    Obj.repr((
# 672 "parser.mly"
                                                                 `whenever_sqlerror _3 ) :  Sqlstx.cmd ))
; (fun parser_env ->
    let _2 = (peek_val parser_env 0 :  string ) in
    Obj.repr((
# 675 "parser.mly"
                                                                           `goto _2 ) : 'when_action))
; (fun parser_env ->
    Obj.repr((
# 676 "parser.mly"
                                                                 `continue ) : 'when_action))
(* Entry query *)
; (fun parser_env -> raise (YYexit (peek_val parser_env 0)))
(* Entry sql_cmd_list *)
; (fun parser_env -> raise (YYexit (peek_val parser_env 0)))
(* Entry cmd *)
; (fun parser_env -> raise (YYexit (peek_val parser_env 0)))
(* Entry full_select *)
; (fun parser_env -> raise (YYexit (peek_val parser_env 0)))
(* Entry ugly_eof *)
; (fun parser_env -> raise (YYexit (peek_val parser_env 0)))
|]
let yytables =
  { actions=yyact;
    transl_const=yytransl_const;
    transl_block=yytransl_block;
    lhs=yylhs;
    len=yylen;
    defred=yydefred;
    dgoto=yydgoto;
    sindex=yysindex;
    rindex=yyrindex;
    gindex=yygindex;
    tablesize=yytablesize;
    table=yytable;
    check=yycheck;
    error_function=parse_error;
    names_const=yynames_const;
    names_block=yynames_block }
let query (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (yyparse yytables 1 lexfun lexbuf :  Sqlstx.query )
let sql_cmd_list (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (yyparse yytables 2 lexfun lexbuf :  Sqlstx.cmd list )
let cmd (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (yyparse yytables 3 lexfun lexbuf :  Sqlstx.cmd )
let full_select (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (yyparse yytables 4 lexfun lexbuf :  Sqlstx.select * Sqlstx.ordering list )
let ugly_eof (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (yyparse yytables 5 lexfun lexbuf :  unit )
(* Line 680, file parser.mly *)
(*

 
*)


(* Line 2081, file parser.ml *)
