(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

module M = Rep_messages

type 'a report_ele =
  | Leaf of (unit -> string)
  | Tag of 'a tag
  | List of 'a liste
  | Cond of 'a cond
  | Sub of 'a sub
	
and 'a tag = {
    mutable tag : string ;
    mutable atts : (string * (unit -> string)) list ;
    mutable tag_subs : 'a report_ele list
  } 
      
and 'a liste =
    { mutable list_subs : ('a -> 'a report_ele list) ;
      mutable f : (unit -> 'a list) ;
    }
      
and 'a cond =
    { mutable cond : unit -> bool ;
      mutable subs_then : 'a report_ele list ;
      mutable subs_else : 'a report_ele list ;
    } 

and 'a sub = 
    { 
      mutable sub_rep : unit -> 'a report ;
    } 
      
and 'a report = {
    mutable rep_eles : 'a report_ele list ;
  } 
      
