(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Utils plugin. This plugin provides some basic commands 
   to show how to create your own plugin.*)

open Cam_plug

(** Make the user give a Cameleon command name and execute it.
   This comment is associated to the following command,
   thanks to our custom ocamldoc generator.
   @command exec
*)
let exec args =
  match args with
  | [] ->
      (
       let coms = Cam_plug.available_commands () in
       let com = ref (try List.hd coms with _ -> "") in
       let p = Configwin.combo
	   ~f: (fun s -> com := s)
	   ~new_allowed: true
	   ~blank_allowed: false
	   "Command : "
	   coms
	   !com
       in
       match Configwin.simple_get "execute" [p] with
	 Configwin.Return_cancel | Configwin.Return_apply -> ()
       | Configwin.Return_ok -> Cam_plug.eval !com ()
      )
  | l ->
      let com = String.concat " " l in
      Cam_plug.eval com ()


(** Make the user give an url and launch mozilla with this url.
   If no url is given, make the user type it. In this case, 
   the default url begins with http:// or file:///, depending
   on whether a directory is selected or not.
   @command mozilla
*)
let mozilla args =
  let url_opt = 
    match args with
      url :: _ -> Some url
    | [] ->
	GToolbox.input_string ~title: "mozilla" 
	  ~text: (match selected_dir() with None -> "http://" | Some s -> "file:///"^s) 
	  "url: " 
  in
  match url_opt with
    None -> ()
  | Some s -> ignore (Sys.command ("mozilla "^(Filename.quote s)^" &"))

let _ = add_command "exec" "execute a prompted command" exec 
let _ = add_command "mozilla" "launch mozilla on a given url" mozilla
