(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Messages and string constants *)                                            

(** {2 Software information} *)

let software = "ocamlmake-o-matic"
let software_version = "1.3"
let software_copyright = 
  "Copyright 2002 Institut National de Recherche en \n"^
  "Informatique et en Automatique. All rights reserved.\n"^
  "This software is distributed under the terms of the\n"^
  "GNU General Public License version2.\n"^
  "(see file LICENSE in the distribution)"
let software_author1 = "Dimitri Ara"
let software_author_mail1 = "dimitri.ara@mutu.net"
let software_author2 = "Maxence Guesdon"
let software_author_mail2 = "maxence.guesdon@inria.fr"
let software_about = 
  software^" version "^software_version^"\n\n"^
  software_author1^" <"^software_author_mail1^">\n"^
  software_author2^" <"^software_author_mail2^">\n\n"^
  software_copyright

let home =                                                                        
  try Sys.getenv "HOME"
  with Not_found -> ""

(** {2 Command line and config options} *)

let usage = "Usage : "^Sys.argv.(0)^" [options] [-- program [arguments]] \nwhere
 options are :"

(** {2 Labels and messages} *)

let yes = "Yes"
let no = "No"
let cancel = "Cancel"

let action = "Action"
let ocaml = "OCaml"
let activated = "Activated"
let value = "Value"
let add = "Add"
let remove = "Remove"
let edit = "Edit"
let up = "Up"
let common = "Common"

let template = "Template"
let templates = template ^ "s"
let target = "Target"
let targets = "Target" ^ "s"
let templates_targets = templates ^ "/" ^ targets

let save_or_not = "Save?"

let new_template_title = "New template"
let new_template_name= "Name of the new template"
let new_template_filename = "Name of the associated file"

let add_field = "Add field"
let add_field_name = "Name of the field"
let add_field_type = "Type of the field"

let remove_field = "Remove field"
let remove_field_name = "Name of the field to remove"

let rename_field = "Rename field"
let rename_field_name = "Name of the field to rename"
let rename_field_newname = "New name"
let template_properties_name = "Name of the template"
let template_properties_filename = "Name of the associated file"
let template_properties = "Template properties"

let list_add = "Add value"
let list_add_name = "Name of the value to add"

let list_edit_name = "Name of the value"
let list_edit_activated = "Is value activated?"
let list_edit = "Edit value"



(** {2 Menu labels} *)

let mFile = "File"
let mQuit = "Quit"
let mAbout = "About..."
let mQuestion_mark = "?"
let mSave = "Save"
let mTemplates = "Templates"
let mNewTemplate = "New template"
let mRemoveTemplate = "Remove template"
let mAddField = "Add field"
let mRemoveField = "Remove field"
let mTemplateProperties = "Edit properties"
let mRenameField = "Rename field"
