(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Misc functions. *)

open Dbf_types.Current

let remove_blanks str =
  let len = String.length str in
  let buf = Buffer.create len in
  for i = 0 to len - 1 do
    match str.[i] with
      '\000' | ' ' | '\t' | '\r' | '\n' -> ()
    | c -> Buffer.add_char buf c
  done;
  Buffer.contents buf

let set_val l k v =
  let l2 = List.remove_assoc k l in
  (k, v) :: l2

let get_val l k def =
  try List.assoc k l
  with Not_found -> def

let sort_columns_list l = 
  List.sort
      (fun c1 c2 -> compare c1.col_name c2.col_name)
      l

let sort_columns t = 
  t.ta_columns <- sort_columns_list t.ta_columns

let sort_tables_list l =
  List.sort
    (fun t1 t2 -> compare t1.ta_name t2.ta_name)
    l

let sort_tables s = 
  s.sch_tables <- sort_tables_list s.sch_tables

(** Create the given empty file. *)
let create_file f =
  try let oc = open_out f in close_out oc
  with Sys_error s -> prerr_endline s


	      
