(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

let menus = ref []

let commands = Hashtbl.create 13

let normalize_com s =
  let len = String.length s in
  let buf = Buffer.create len in
  for i = 0 to len - 1 do
    match s.[i] with
      ' ' | '\t' | '\n' | '\r' 
    | '\'' | '"' | '\\' -> Buffer.add_char buf '_'
    | c -> Buffer.add_char buf c
  done;
  Buffer.contents buf

let add_command com desc f =
  let n_com = normalize_com com in
  Hashtbl.remove commands n_com;
  Hashtbl.add commands n_com (desc, f)

let available_commands () =
  let l = ref [] in
  Hashtbl.iter (fun com -> fun _ -> l := com :: !l) commands ;
  List.sort compare !l

let available_commands_with_help () =
  let l = ref [] in
  Hashtbl.iter (fun com -> fun (h,_) -> l := (com, h) :: !l) commands ;
  List.sort (fun (c,_) (c2,_) -> compare c c2)  !l

let exec com args () =
  try
    let (_, f) = Hashtbl.find commands com in
    f args
  with
    Not_found ->
      prerr_endline (Printf.sprintf "command %s not available." com)
  | e ->
      prerr_endline (Printf.sprintf "command %s: %s" com 
		       (Printexc.to_string e))


let selected_dir = ref (fun () -> None)

let selected_files = ref (fun () -> [])

let custom_editors = ref []

let add_embedded_app com f_app =
  add_command com "" (fun _ -> Cam_embed.create com f_app ())

let config_boxes = ref []

let add_config_box f = 
  config_boxes := !config_boxes @ [f]

let pack_view = ref (fun _ -> fun _ -> ())

let views = ref []

let add_view v label = 
  !pack_view v label;
  views := v :: !views

let display_message = ref (fun _ -> ())
