#ifndef _KDESCORETRACK_CPP_
#define _KDESCORETRACK_CPP_

#include <iostream.h>

#include <kiconloader.h>

#include <qspinbox.h>
#include <qcombobox.h>


#include "prMainEditor.h"
#include "scoreTrack.h"
#include "player.h"
#include "song.h"

#include "kdeScoreTrack.h"
#include "kdeMainEditor.h"

extern const char * gmNames[];
extern Song * sonG;

extern PrMainEditor * mainEditor;

#define ME ((KdeMainEditor*)mainEditor)

KdeScoreTrack::KdeScoreTrack(Track * tr) : KdeTrack(tr) {

  KIconLoader * loader = KGlobal::iconLoader();
  _icon = new QPixmap(loader->loadIcon( "note", KIcon::Toolbar ));

  int hh = ME->trackHeight();
  QStrList * devList = new QStrList();
  for (int i=0;i<sonG->player()->devicenum();i++) devList->append(sonG->player()->device(i));
  
  _instbox = new QComboBox(FALSE,this,"instrument");
  _instbox->insertStrList( gmNames );
  _instbox->setCurrentItem(((ScoreTrack*)_track)->program());
  _instbox->setGeometry(168,0,160,hh+1);
  connect(_instbox,SIGNAL(highlighted(int)),SLOT(updateInst(int)));

  _output = new QComboBox(FALSE,this,"_output");
  _output->insertStrList( devList );
  _output->setCurrentItem(((ScoreTrack*)_track)->output());
  _output->setGeometry(328,0,96,hh+1);
  connect(_output,SIGNAL(highlighted(int)),SLOT(updateOut(int)));

  _chanbox = new QSpinBox(0,15,1,this);
  _chanbox->setGeometry(424,0,44,hh+1);
  _chanbox->setValue(((ScoreTrack*)_track)->channel());
  _chanbox->setBackgroundMode( PaletteMid );
  connect(_chanbox,SIGNAL(valueChanged(int)),SLOT(updateChan(int)));

  _vol = new QSpinBox(-100,100,1,this);
  _vol->setGeometry(468,0,54,hh+1);
  _vol->setValue(((ScoreTrack*)_track)->volume());
  _vol->setBackgroundMode( PaletteMid );
  connect(_vol,SIGNAL(valueChanged(int)),SLOT(updateVol(int)));

  _tra = new QSpinBox(-100,100,1,this);
  _tra->setGeometry(522,0,54,hh+1);
  _tra->setValue(((ScoreTrack*)_track)->transpose());
  _tra->setBackgroundMode( PaletteMid );
  connect(_tra,SIGNAL(valueChanged(int)),SLOT(updateTra(int)));

  _del = new QSpinBox(-100,100,1,this);
  _del->setGeometry(576,0,54,hh+1);
  _del->setValue(((ScoreTrack*)_track)->delay());
  _del->setBackgroundMode( PaletteMid );
  connect(_del,SIGNAL(valueChanged(int)),SLOT(updateDel(int)));

}

void KdeScoreTrack::erase() {
  // TODO: delete anything?;
  KdeTrack::erase();
}

void KdeScoreTrack::update(bool menu) {
  KdeTrack::update(menu);
  //mute->update(); track->gMain()->muteTrack(track->trackNum());
  
  _instbox->setCurrentItem(((ScoreTrack*)_track)->program());
  _output->setCurrentItem(((ScoreTrack*)_track)->output());
  _chanbox->setValue(((ScoreTrack*)_track)->channel());
  _vol->setValue(((ScoreTrack*)_track)->volume());
  _tra->setValue(((ScoreTrack*)_track)->transpose());
  _del->setValue(((ScoreTrack*)_track)->delay());
  
  //show();
}


int KdeScoreTrack::gProgram() {
  // return _instbox->getCurrentItem();
  return 0;
}

void KdeScoreTrack::sProgram(int n) {
  //((KbScoreTrack*)track)->sProgram(n);
  _instbox->setCurrentItem(n);
}


void KdeScoreTrack::updateChan(int n) {
  ((ScoreTrack*)_track)->setChannel(n);
}

void KdeScoreTrack::updateInst(int n) {
  ((ScoreTrack*)_track)->setProgram(n);
  //track->gMain()->updateInst(track->trackNum(),n);
}

void KdeScoreTrack::updateOut(int n) {
  ((ScoreTrack*)_track)->setOutput(n);
}

void KdeScoreTrack::updateVol(int n) {
  ((ScoreTrack*)_track)->setVolume(n);
  //track->gMain()->updateVol(track->trackNum());
}

void KdeScoreTrack::updateTra(int n) {
  ((ScoreTrack*)_track)->setTranspose(n);
  //track->gMain()->updateTra(track->trackNum());
}

void KdeScoreTrack::updateDel(int n) {
  ((ScoreTrack*)_track)->setDelay(n);
}





#endif
#include "kdeScoreTrack.moc"
