#ifndef _KDESCORECONTENT2_CPP_
#define _KDESCORECONTENT2_CPP_

#include <stdio.h>
#include <iostream.h>
#include <stdlib.h>
#include <math.h>

#include <kiconloader.h>
#include <klocale.h>
#include <kmenubar.h>

#include <qbitmap.h>
#include <qpopupmenu.h>
#include <qpainter.h>
#include <qlineedit.h>
#include <fstream.h>

#include "part.h"
#include "track.h"
#include "song.h"
#include "player.h"
#include "str.h"
#include "expression.h"
#include "lyrics.h"
#include "symbol.h"
#include "addToSelection.h"
#include "newSelection.h"
#include "removeFromSelection.h"
#include "moveEvent.h"
#include "copyEvent.h"
#include "addElement.h"
#include "removeElement.h"
#include "addOrnament.h"
#include "removeOrnament.h"
#include "changeNote.h"
#include "glueNote.h"
#include "splitNote.h"
#include "unselect.h"
#include "reference.h"
#include "scoreTrack.h"
#include "iterator.h"
#include "scoreIterator.h"
#include "scoreBar.h"
#include "prFactory.h"
#include "mupPrinter.h"

#include "kdeScoreContent2.h"
#include "kdeScoreEditor2.h"
#include "kdeMainEditor.h"
#include "kdeEditorToolBar.h"
#include "kdeEditorNoteBar.h"
#include "kdeEditorButtonBar.h"
#include "kdeEditorScrollBar.h"
#include "kdeEditInfo.h"
#include "kdeEditorMenuBar.h"
#include "kdeKeyChooser.h"
#include "kdeSPD.h"
#include "positionCursor.h"
// #include "curHand.h"
#include "brahmsResources.h"

#include "qtScoreAddons.h"

#define ME ((KdeMainEditor*)mainEditor)

extern PrFactory * factory;
extern Song * sonG;
extern PrMainEditor * mainEditor;
extern Table * selectioN;

extern const char * gmNames[];
extern int sharpTab[];
extern int flatTab[];
extern int signShift[];
extern int scrSigns[];
extern int allSigns[15][7];
extern int freqTab[];
extern int yClef[];

extern void createBreakGroups(QtScoreGroup *& grp, QtScoreGroup *& grp1, Position pos, int length, Position off, Part * master, int met0, int met1);

extern const char * bClef2mClef[];
extern const char * extNoteNames[];
extern const char * auxScoreNames[];

enum { ID_TOOL_IN, ID_TOOL_ANS, ID_TOOL_AOS, ID_TOOL_LYR };
enum { ID_OPTIONS_NOTEBAR, ID_OPTIONS_AUTHOR, ID_OPTIONS_AUX, ID_OPTIONS_NEXT, ID_OPTIONS_STN, ID_OPTIONS_SIN, ID_OPTIONS_LYRICS, ID_OPTIONS_VOLUMES };

QPixmap * imgNotePtr = 0;
QPixmap * imgSignPtr = 0;
QPixmap * imgFlagPtr = 0;
QPixmap * imgBreakPtr = 0;
QPixmap * imgNoteAccentPtr = 0;
QPixmap * imgScoreSymbolPtr = 0;

static unsigned char symbolc1[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,
 0x24,0x00,0x4e,0x00,0x5d,0x80,0x3e,0x40,0x1f,0xa0,0x0f,0xd0,0x07,0xe8,0x03,
 0xf4,0x01,0xfa,0x00,0x79,0x00,0x3f,0x00,0x1f,0x00,0x0f,0x00};

static unsigned char symbolc2[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,
 0x24,0x00,0x4e,0x00,0x59,0x80,0x30,0x40,0x18,0x20,0x0c,0x10,0x06,0x08,0x03,
 0x84,0x01,0xc2,0x00,0x61,0x00,0x37,0x00,0x1f,0x00,0x0f,0x00};

static unsigned char lyricsc1[] = {
 0x00,0x00,0x00,0x00,0x6c,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x18,0x10,
 0x24,0x6c,0x4e,0x00,0x5d,0x80,0x3e,0x40,0x1f,0xa0,0x0f,0xd0,0x07,0xe8,0x03,
 0xf4,0x01,0xfa,0x00,0x79,0x00,0x3f,0x00,0x1f,0x00,0x0f,0x00};

static unsigned char lyricsc2[] = {
 0x00,0x00,0x00,0x00,0x6c,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x18,0x10,
 0x24,0x6c,0x4e,0x00,0x59,0x80,0x30,0x40,0x18,0x20,0x0c,0x10,0x06,0x08,0x03,
 0x84,0x01,0xc2,0x00,0x61,0x00,0x37,0x00,0x1f,0x00,0x0f,0x00};

enum { BowUp, BowDown };

// KbText * textElement = 0;


KdeScoreContent2::KdeScoreContent2(QFrame * parent, KdeScoreEditor2 * ed , KdeEditorToolBar * tb, KdeEditorNoteBar * nb, KdeEditorButtonBar * bb)
  : QFrame(parent,"content",QFrame::Sunken), _editor(ed), _notebar(nb), _toolbar(tb), _buttonbar(bb),
    _grab(0), _grabX(-1), shftFlag(false), ctrlFlag(false), suprFlag(false), _key_chooser(0)
{
  _position_cursor = new PositionCursor(this,0); // offset has to be set when calling move, because it depends on the key of the staff


  QBitmap cb1( 15, 21, symbolc1, TRUE );
  QBitmap cm1( 15, 21, symbolc1, TRUE );
  symbolcursor1 = new QCursor( cb1, cm1, 0, 19);
  QBitmap cb2( 15, 21, symbolc2, TRUE );
  QBitmap cm2( 15, 21, symbolc2, TRUE );
  symbolcursor2 = new QCursor( cb2, cm2, 0, 19);

  QBitmap lb1( 15, 21, lyricsc1, TRUE );
  QBitmap lm1( 15, 21, lyricsc1, TRUE );
  lyricscursor1 = new QCursor( lb1, lm1, 0, 19);
  QBitmap lb2( 15, 21, lyricsc2, TRUE );
  QBitmap lm2( 15, 21, lyricsc2, TRUE );
  lyricscursor2 = new QCursor( lb2, lm2, 0, 19);


  yAux = 0;
  firstGroup = 0;
  showVOL = false;
  showLYR = false;

  txtLine = new QLineEdit(this,"text");
  txtLine->hide();
  lyrLine = new LyricsEdit(this);
  lyrLine->hide();
  connect(lyrLine,SIGNAL(returnPressed()),SLOT(setLyrics()));

  KIconLoader * loader = KGlobal::iconLoader();
  QBitmap maske;
  if (ME->editorBackground() == ::NoBackground) {
    setBackgroundColor( Qt::white );
    setBackgroundMode( QWidget::FixedColor );
  } else if (ME->editorBackground() == PaperBackground) {
    QPixmap paper = loader->loadIcon( "paper02", KIcon::Toolbar );
    setBackgroundPixmap(paper);
    setBackgroundMode( QWidget::FixedPixmap );
  } else if (ME->editorBackground() == UserDefinedBackground) {
    // QPixmap paper = loader->loadIcon( ME->userBackground(), KIcon::Toolbar );
  }
  cursorPM = loader->loadIcon( "cnote0",KIcon::Toolbar ); cursorBM[0] = cursorPM; cursor[0] = new QCursor( cursorBM[0], cursorBM[0],5,18);
  cursorPM = loader->loadIcon( "cnote1",KIcon::Toolbar ); cursorBM[1] = cursorPM; cursor[1] = new QCursor( cursorBM[1], cursorBM[1],5,18);
  cursorPM = loader->loadIcon( "cnote2",KIcon::Toolbar ); cursorBM[2] = cursorPM; cursor[2] = new QCursor( cursorBM[2], cursorBM[2],5,18);
  cursorPM = loader->loadIcon( "cnote3",KIcon::Toolbar ); cursorBM[3] = cursorPM; cursor[3] = new QCursor( cursorBM[3], cursorBM[3],5,18);
  cursorPM = loader->loadIcon( "cnote4",KIcon::Toolbar ); cursorBM[4] = cursorPM; cursor[4] = new QCursor( cursorBM[4], cursorBM[4],5,18);
  cursorPM = loader->loadIcon( "cnote5",KIcon::Toolbar ); cursorBM[5] = cursorPM; cursor[5] = new QCursor( cursorBM[5], cursorBM[5],5,18);
  cursorPM = loader->loadIcon( "cnote6",KIcon::Toolbar ); cursorBM[6] = cursorPM; cursor[6] = new QCursor( cursorBM[6], cursorBM[6],5,18);
  cursorPM = loader->loadIcon( "caddns",KIcon::Toolbar ); cursorBM[7] = cursorPM;
  cursorPM = loader->loadIcon( "caddns1",KIcon::Toolbar ); maske = cursorPM; cursor[7] = new QCursor( cursorBM[7], maske,7,10);
  cursorPM = loader->loadIcon( "caddos",KIcon::Toolbar ); cursorBM[8] = cursorPM;
  cursorPM = loader->loadIcon( "caddos1",KIcon::Toolbar ); maske = cursorPM; cursor[8] = new QCursor( cursorBM[8], maske,7,10);

  imgNote[0] = loader->loadIcon( "note0",KIcon::Toolbar ); maske = imgNote[0]; imgNote[0].setMask( maske );
  imgNote[1] = loader->loadIcon( "note1",KIcon::Toolbar ); maske = imgNote[1]; imgNote[1].setMask( maske );

  imgClef[0] = loader->loadIcon( "key0",KIcon::Toolbar ); maske = imgClef[0]; imgClef[0].setMask( maske );
  imgClef[1] = loader->loadIcon( "key1",KIcon::Toolbar ); maske = imgClef[1]; imgClef[1].setMask( maske );
  imgClef[2] = loader->loadIcon( "key2",KIcon::Toolbar ); maske = imgClef[2]; imgClef[2].setMask( maske );
  imgClef[3] = loader->loadIcon( "key3",KIcon::Toolbar ); maske = imgClef[3]; imgClef[3].setMask( maske );
  imgClef[4] = loader->loadIcon( "key4",KIcon::Toolbar ); maske = imgClef[4]; imgClef[4].setMask( maske );
  imgClef[5] = loader->loadIcon( "key5",KIcon::Toolbar ); maske = imgClef[5]; imgClef[5].setMask( maske );
  imgClef[6] = loader->loadIcon( "key6",KIcon::Toolbar ); maske = imgClef[6]; imgClef[6].setMask( maske );
  imgClef[7] = loader->loadIcon( "key7",KIcon::Toolbar ); maske = imgClef[7]; imgClef[7].setMask( maske );
  imgClef[8] = loader->loadIcon( "key8",KIcon::Toolbar ); maske = imgClef[8]; imgClef[8].setMask( maske );
  imgClef[9] = loader->loadIcon( "key9",KIcon::Toolbar ); maske = imgClef[9]; imgClef[9].setMask( maske );
  imgClef[10] = loader->loadIcon( "key10",KIcon::Toolbar ); maske = imgClef[10]; imgClef[10].setMask( maske );
  imgClef[11] = loader->loadIcon( "key11",KIcon::Toolbar ); maske = imgClef[11]; imgClef[11].setMask( maske );
  imgClef[12] = loader->loadIcon( "key12",KIcon::Toolbar ); maske = imgClef[12]; imgClef[12].setMask( maske );
  imgClef[13] = loader->loadIcon( "key13",KIcon::Toolbar ); maske = imgClef[13]; imgClef[13].setMask( maske );

  imgFlat  = loader->loadIcon( "sgnFlat",KIcon::Toolbar );  maske = imgFlat; imgFlat.setMask( maske );
  imgSharp = loader->loadIcon( "sgnSharp",KIcon::Toolbar ); maske = imgSharp; imgSharp.setMask( maske );

  for (int i=0;i<21;i++) {
    noteAccent[i] = loader->loadIcon( extNoteNames[i],KIcon::Toolbar );
  }
  noteExt = new QtSymbols(_editor,noteAccent,extNoteElement,21,7,"Note Symbols",ID_TOOL_ANS);

  for (int i=0;i<33;i++) {
    scoreSymbol[i] = loader->loadIcon( auxScoreNames[i],KIcon::Toolbar );
  }
  scoreAux = new QtSymbols(_editor,scoreSymbol,auxScoreElement,33,11,"Score Symbols",ID_TOOL_AOS);

  updateCursor();

  imgNotePtr = imgNote;
  imgSignPtr = imgSign;
  imgFlagPtr = imgFlag;
  imgBreakPtr = arrBreak;
  imgNoteAccentPtr = noteAccent;
  imgScoreSymbolPtr = scoreSymbol;

  _part = _editor->part();

  rbmenu = new QPopupMenu();
  /* rbmenu->connectItem( rbmenu->insertItem(i18n("flip stem")), this, SLOT(flipStem()) );
     rbmenu->connectItem( rbmenu->insertItem(i18n("flip bow")), this, SLOT(flipBow()) );
     rbmenu->insertSeparator();*/
  rbmenu->connectItem( rbmenu->insertItem(i18n("glue to next note")), this, SLOT(glueNote()) );
  rbmenu->connectItem( rbmenu->insertItem(i18n("split note")), this, SLOT(splitNote()) );
  rbmenu->insertSeparator();
  rbmenu->connectItem( rbmenu->insertItem(i18n("remove symbols")), this, SLOT(removeSymbols()) );
  rbmenu->connectItem( rbmenu->insertItem(i18n("remove bow")), this, SLOT(removeBow()) );
  rbmenu->insertSeparator();
  rbmenu->connectItem( rbmenu->insertItem(i18n("delete note")), this, SLOT(deleteNote()) );
  show();
}

KdeScoreContent2::~KdeScoreContent2() {
  delete noteExt;
  delete scoreAux;
  if (_key_chooser!=0) delete _key_chooser;
}

void KdeScoreContent2::glueNote() {
  if (_grab!=0) {
    sonG->doo(new GlueNote(_grab, _editor->part()));
    _grab = 0;
    _grabX = -1;
    repaint(FALSE);
  }
}

void KdeScoreContent2::splitNote() {
  if (_grab!=0) {
    sonG->doo(new SplitNote(_grab, _editor->part(), _editor->grid()));
    _grab = 0;
    _grabX = -1;
    repaint(FALSE);
  }
}

void KdeScoreContent2::deleteNote() {
  if (_grab!=0) {
    sonG->doo(new RemoveElement(_grab, _editor->part()));
    _grab = 0;
    _grabX = -1;
    repaint(FALSE);
  }
}

void KdeScoreContent2::removeSymbols() {
  if (_grab!=0) {
    sonG->doo(new RemoveOrnament(_grab,EXPRESSION));
    // _grab->removeExp();
    _grab = 0;
    _grabX = -1;
    repaint(FALSE);
  }
}

void KdeScoreContent2::removeBow() {
  if (_grab!=0) {
    sonG->doo(new RemoveOrnament(_grab,BOW));
    // _grab->removeBow();
    _grab = 0;
    _grabX = -1;
    repaint(FALSE);
  }
}

void KdeScoreContent2::flipStem() {
  /* TODO: if (selNote) ((KbNote*)selNote)->flipStem();
     selNote = 0; showNoteInfoOff();*/
}

void KdeScoreContent2::flipBow() {
  /* TODO: if (selNote) ((KbNote*)selNote)->flipBow();
     selNote = 0; showNoteInfoOff();*/
}

void KdeScoreContent2::paintEvent( QPaintEvent * ) {
  setMouseTracking(TRUE);

  QPixmap pix( width(), height() );
  pix.fill( this, 10,10 );
  QPainter score;
  score.begin( &pix );

  _editor->setScore(&score);

  _active_system = _editor->partIndex();

  ScoreIterator * iterator = _editor->iterator();
  if (iterator!=0) delete iterator;

  iterator = new ScoreIterator(_editor, _editor->xoffset());
  _editor->setIterator(iterator);
  for (; !iterator->done(); (*iterator)++) {
    iterator->paint();
  }

  //
  // selection frame
  //
  if ((_grabX > -1) && (symbol==0)) {
    score.setPen(Qt::DashLine);
    if (_grab==0)
      score.drawRect(_pressX,_pressY,_moveX-_pressX,_moveY-_pressY);
    score.setPen(Qt::SolidLine);
  }

  _notebar->update();


  score.end();

  bitBlt( this, 0, 0, &pix );
  _editor->info()->repaint(FALSE);
}

ScoreBar * KdeScoreContent2::firstBar() {
  return _editor->iterator()==0 ? 0 : _editor->iterator()->firstBar(_active_system);
}





void KdeScoreContent2::updateCursor() {
  if (tool()==ID_TOOL_IN) {
    setCursor(*cursor[_editor->lengthOrd()-1]);
    if (!noteExt->isHidden()) noteExt->hide();
    if (!scoreAux->isHidden()) scoreAux->hide();
    setFocus();
  } else if (tool()==ID_TOOL_ANS) {
    if (noteExt->isHidden()) { setCursor(*symbolcursor1); noteExt->show(); }
    if (!scoreAux->isHidden()) scoreAux->hide();
  } else if (tool()==ID_TOOL_AOS) {
    if (!noteExt->isHidden()) noteExt->hide();
    if (scoreAux->isHidden()) { scoreAux->show(); setCursor(*symbolcursor1); }
  } else if (tool()==ID_TOOL_LYR) {
    if (!noteExt->isHidden()) noteExt->hide();
    if (!scoreAux->isHidden()) scoreAux->hide();
  }
}

void KdeScoreContent2::setTool(int i) {
  _editor->setTool(i);
}

int KdeScoreContent2::tool() {
  return _editor->tool();
}



void KdeScoreContent2::settings() {
  if (_key_chooser==0) _key_chooser = new KdeKeyChooser(_editor);
  _key_chooser->show();
}

void KdeScoreContent2::clearKeyChooser() { _key_chooser = 0; }


int KdeScoreContent2::gEnhValue() {
  return enhValue;
}

void KdeScoreContent2::sEnhValue(int e) {
  enhValue = e;
}


// *****************************************************************************
//
// SLOTS
// =====
//

void KdeScoreContent2::mousePressEvent ( QMouseEvent * me ) {
  _pressX = me->x();
  _pressY = me->y();

  _active_system = int((_moveY-YTOP-6)/YDELTA);
  _editor->setPart(_active_system);

  // double pixPerTick = (width()-xoffset-4.0)/(_editor->right().ticks()-_editor->left().ticks());
  ScoreArea area;
  _grabX = _editor->ticks(_pressX, area);
  long pos = _editor->snap(_grabX); //_editor->snap((_pressX-xoffset)/pixPerTick) + _editor->left().ticks();
  int pitch = Pitch(_pressY);
  bool tail = false;
  _grab = _editor->getGrabNote(pos,pitch,tail);
  if (int((_moveY-YTOP)/YDELTA)!=_active_system) _grab = 0;
  _grabY = _pressY;
  // _grabX = int((_pressX-xoffset)/pixPerTick + _editor->left().ticks()); // without snap!
  int tol = tool();

  if (me->button()==RightButton) {
    if (_grab) rbmenu->popup( mapToGlobal(me->pos()), 0 );
  } else {
    if (_grab==0) {
    } else {
      if (tol == ID_TOOL_IN) {
	//
	// NOTE TOOL
	//
	setCursor(imgNote[1]);
	_grabW = 16; // TODO ??? int(_grab->length()*pixPerTick);
      } else if (tol == ID_TOOL_ANS) {
	//
	// NOTE SYMBOL
	//
	if (_grab) {
	  if ((extNoteElement==NS_BOWDOWN)||(extNoteElement==NS_BOWUP)) { // Bow
	    // cout << "BOW" << endl;
	    int blen = 0;
	    Note * n = _grab;
	    while ((blen==0)&&(_part->next(n)!=0)) {
	      n = (Note*) _part->next(n);
	      blen = int(n->internalStart().ticks() - _grab->internalStart().ticks());
	    }
	    if (blen==0) blen = 384;
	    int dir = BowUp; if (extNoteElement==NS_BOWDOWN) dir = BowDown;
	    int delta = 0;
	    if (n) delta = (n->pitch() - ((Note*)_grab)->pitch())*3;
	    if (_grab&&_grab->isA()==NOTE) noteBow = ((Note*)_grab)->setBow(blen,dir,-delta);
	  } else { // ACCENT
	    noteExp = _grab->setExpression(extNoteElement); // returns this element, or create new if it does not exist
	    int scoreY = (_pressY-YTOP)%(YDELTA+yAux);
	    noteExp->setDisplacement( (scoreY<=48) ? -6 : 6 );
	  }
	}
      } else if (tol == ID_TOOL_LYR) {
	//
	// LYRICS
	//
	createLyrics(_grab, _editor->xposition(_part->start(_grab).ticks()), (1+_active_system)*YDELTA + YTOP );
      }
    }
    if (tol == ID_TOOL_AOS) {
      //
      // SYSTEM SYMBOL
      //
      symbol = 0;

      Position pos = _grabX; // _pressX - (_pressX%grid()) - _part->start();
      int scoreY = ((_pressY-YTOP) % (YDELTA+yAux));
      int scoreTopLine = 12;
      int scoreBottomLine = 84;
      // int offset = 0;
      switch (auxScoreElement) {
      case AS_LABEL1: symbol = _part->setSymbol(pos,auxScoreElement,scoreTopLine); break;
      case AS_LABEL2: symbol = _part->setSymbol(pos,auxScoreElement,scoreTopLine); break;
      case AS_LABEL3: symbol = _part->setSymbol(pos,auxScoreElement,scoreTopLine); break;
      case AS_CASE1: symbol = _part->setSymbol(pos,auxScoreElement,scoreTopLine); break;
      case AS_CASE2: symbol = _part->setSymbol(pos,auxScoreElement,scoreTopLine); break;
      case AS_PEDAL1: symbol = _part->setSymbol(pos,auxScoreElement,scoreBottomLine); break;
      case AS_PEDAL2: symbol = _part->setSymbol(pos,auxScoreElement,scoreBottomLine); break;
      case AS_NOTEDOT: symbol = _part->setSymbol(pos,auxScoreElement,scoreTopLine); break;
      case AS_NOTE3: symbol = _part->setSymbol(pos,auxScoreElement,scoreTopLine); break;
      case AS_NOTE6: symbol = _part->setSymbol(pos,auxScoreElement,scoreTopLine); break;
      case AS_NOTEXX: symbol = _part->setSymbol(pos,auxScoreElement,scoreTopLine,0); break;
      case AS_8VA: symbol = _part->setSymbol(pos,auxScoreElement,scoreTopLine,0); break;
      case AS_15VA: symbol = _part->setSymbol(pos,auxScoreElement,scoreTopLine,0); break;
      case AS_TRILLX: symbol = _part->setSymbol(pos,auxScoreElement,scoreY,384); break;
      case AS_TRILLX2: symbol = _part->setSymbol(pos,auxScoreElement,scoreY,384); break;
      case AS_DECRESCENDO: symbol = _part->setSymbol(pos,auxScoreElement,scoreY,192); break;
      case AS_CRESCENDO: symbol = _part->setSymbol(pos,auxScoreElement,scoreY,192); break;
      case AS_BRACKETUP: symbol = _part->setSymbol(pos,auxScoreElement,scoreY,768); break;
      case AS_BRACKETDOWN: symbol = _part->setSymbol(pos,auxScoreElement,scoreY,768); break;
      case AS_ARPEGGIO: symbol = _part->setSymbol(pos,auxScoreElement,scoreY,32); break;
      case AS_TEXT: symbol = _part->setSymbol(pos,auxScoreElement,scoreBottomLine,-2);
	// createText(symbol,xoffset+(pos.ticks()-_editor->left().ticks()+_part->start().ticks())*pixPerTick,_pressY);
	createText(symbol, _pressX, _pressY);
	break;
      case DYN_PPP: symbol = _part->setSymbol(pos,auxScoreElement,scoreY); break;
      case DYN_PP: symbol = _part->setSymbol(pos,auxScoreElement,scoreY); break;
      case DYN_P: symbol = _part->setSymbol(pos,auxScoreElement,scoreY); break;
      case DYN_MP: symbol = _part->setSymbol(pos,auxScoreElement,scoreY); break;
      case DYN_MF: symbol = _part->setSymbol(pos,auxScoreElement,scoreY); break;
      case DYN_F: symbol = _part->setSymbol(pos,auxScoreElement,scoreY); break;
      case DYN_FF: symbol = _part->setSymbol(pos,auxScoreElement,scoreY); break;
      case DYN_FFF: symbol = _part->setSymbol(pos,auxScoreElement,scoreY); break;
      case DYN_SFZ: symbol = _part->setSymbol(pos,auxScoreElement,scoreY); break;
      case DYN_SF: symbol = _part->setSymbol(pos,auxScoreElement,scoreY); break;
      case DYN_SFF: symbol = _part->setSymbol(pos,auxScoreElement,scoreY); break;
      case DYN_FP: symbol = _part->setSymbol(pos,auxScoreElement,scoreY); break;
	
	_grab = 0;
	_grabX = -1;
      }

    }
  }
}

void KdeScoreContent2::createText(Symbol * sym, int x, int y) {
  textElement = sym;
  // txtLine = new QLineEdit(this,"text");
  txtLine->setGeometry(x,y,30,14);
  txtLine->setText(textElement->text());
  txtLine->show();
  txtLine->setActiveWindow();
  txtLine->setFocus();
  connect(txtLine,SIGNAL(returnPressed()),SLOT(setText()));
}

void KdeScoreContent2::setText() {
  if (textElement!=0) {
    textElement->setText(strdup(txtLine->text().ascii()));
  }
  textElement = 0;
  txtLine->hide();
}

void KdeScoreContent2::mouseMoveEvent  ( QMouseEvent * me ) {
  _moveX = me->x();
  _moveY = me->y();

  ScoreArea area;
  long pos = _editor->snap(_editor->ticks(_moveX, area)); //_editor->snap((_moveX-xoffset)/pixPerTick) + _editor->left().ticks();
  int pitch = Pitch(_moveY);
  bool tail = false;
  Note * over = _editor->getGrabNote(pos,pitch,tail);
  if (int((_moveY-YTOP)/YDELTA)!=_active_system) over = 0;

  int tol = tool();

  if (_grab!=0) { // NOTE GRABBED
    // TODO: int y = mouseY()-2;
    // if (shftFlag) y = _grabY-2;
    // TODO: moveWidget->move(_moveX-2, y);
    // TODO: if (!moveWidget->isVisible()) moveWidget->show();
    if (tol == ID_TOOL_IN) {
      //
      // NOTE TOOL
      //
      if (shftFlag) QCursor::setPos(QWidget::mapToGlobal(QPoint(_moveX, _grabY)));
    } else if (tol == ID_TOOL_ANS) {
      if (noteBow) {
	// noteBow->setLength((_moveX-_pressX)*1.0/pixPerTick);
	noteBow->setLength(pos-_grabX);
	noteBow->setDelta(_moveY - _pressY);
      }
      if (noteExp) noteExp->setDisplacement(_moveY - _pressY);
      repaint(FALSE);
    }
  } else {        // FREE
    if (tol == ID_TOOL_IN) {
      //
      // NOTE TOOL
      //
      if (area!=Clef && area!=Indent) {
	if (_grabX > -1) {
	  setCursor(QCursor(2));              // CURSOR crosshair
	  repaint(FALSE);
	} else {
	  if (over) {
	    if (tail) setCursor(QCursor(6));  // CURSOR horizontal resize
	    else      setCursor(QCursor(13)); // CURSOR pointing hand
	  }
	  else updateCursor();                // CURSOR note or pen
	}
      } else { setCursor(QCursor(1)); }       // CURSOR arrow up
    } else if (tol == ID_TOOL_ANS) {
      //
      // NOTE SYMBOL
      //
      if (over) setCursor(*symbolcursor1);    // CURSOR filled pen
      else setCursor(*symbolcursor2);         // CURSOR open pen
    } else if (tol == ID_TOOL_LYR) {
      //
      // LYRICS
      //
      if (over) setCursor(*lyricscursor1);    // CURSOR filled text pen
      else setCursor(*lyricscursor2);         // CURSOR open text pen
    } else if (tol == ID_TOOL_AOS) {
      //
      // SYSTEM SYMBOL
      //
      int scoreY = ((_moveY-YTOP) % (YDELTA+yAux));
      if (symbol) {
	symbol->setDisplacement(scoreY);
	if (symbol->isParameterized()) {
	  symbol->setParameter(pos-_grabX);
	}
	repaint(FALSE);
      }
    }
  }
  if (area!=Clef && area!=Indent) {
    int bar=0; int beat=0; int tick=0;
    sonG->bbt(bar,beat,tick,Position(pos));
    _buttonbar->setPos(bar,beat,tick);
  }
  _buttonbar->setPitch(pitch,shftFlag,ctrlFlag);

}


void KdeScoreContent2::mouseReleaseEvent ( QMouseEvent * me ) {
  // TODO: setCursor(QCursor(*prcursor));
  int tol = tool();
  int ind = int((me->y()-YTOP)/YDELTA);
  // _editor->setPart(ind);
  ScoreArea area;
  long _grabX2 = _editor->ticks(_moveX, area);
  long pos = _editor->snap(_grabX2); //_editor->snap((_pressX-xoffset)/pixPerTick) + _editor->left().ticks();
  int pitch = Pitch(me->y());
  int _grabY2 = me->y();
  Part * pt = _editor->part();
  ScoreTrack * tr = (ScoreTrack*) pt->track();
  bool select = false;
  if (tol == ID_TOOL_IN) {
    //
    // NOTE TOOL
    //
    if (_grab!=0) { // GRABBED NOTE
      if ((_grabY == _grabY2)&&(_grabX == _grabX2)) { // select
	if (shftFlag) {
	  if (selectioN->hasEntry(_grab)) sonG->doo(new RemoveFromSelection(new Reference(_grab)));
	  else                            sonG->doo(new AddToSelection(new Reference(_grab)));
	} else                            sonG->doo(new NewSelection(new Reference(_grab)));
      } else {
	if (ctrlFlag) { // copy event
	  if (shftFlag) sonG->doo(new CopyEvent(Position(pos), _grab, pt));
	  else          sonG->doo(new CopyEvent(Position(pos), _grab, pt, pitch));
	} else {        // move event
	  if (shftFlag) sonG->doo(new MoveEvent(Position(pos), _grab, pt));
	  else          sonG->doo(new MoveEvent(Position(pos), _grab, pt, pitch));
	}
      }
      // TODO: moveWidget->hide();
    } else {      // FREE SPACE
      if (area==Clef) {
	// if ( me->x() < xoffset ) {
	settings();
      } else if (area==Indent) {
	cout << "Choose Symbol" << endl;
      } else if ((_grabY == _grabY2)&&(_grabX == _grabX2)) { // new Note
	if (pitch>0) {
	  if (_editor->speaker()) sonG->player()->hit(tr->output(), tr->channel(), pitch, _editor->velocity());
	  int enh = _editor->enharmonicShift();
	  if (shftFlag) enh++;
	  if (ctrlFlag) enh--;
	  Note * nn = new Note(pitch,_editor->velocity(),_editor->totalLength(),pos-pt->start(),enh);
	  int tp = _editor->tuplet();
	  if (tp>0) {
	    int dur = int(_editor->length()*0.5*(tp+1));
	    nn->tuplet(tp, dur);
	    nn->setDuration(long(dur/tp));
	  }
	  sonG->doo(new AddElement(nn,pt));
	}
      } else { // selection
	select = true;
	if (shftFlag) sonG->doo(new AddToSelection(pt->makeRefs(Pitch(_grabY), Pitch(_grabY2), _grabX, _grabX2)));
	else          sonG->doo(new NewSelection(pt->makeRefs(Pitch(_grabY), Pitch(_grabY2), _grabX, _grabX2)));
	_grabX = -1;
	_editor->update();
      }
    }
  }
  if (!select) _editor->setPart(ind);
  noteExp = 0;
  noteBow = 0;
  symbol = 0;
  _grab = 0;
  _grabX = -1;
}

void KdeScoreContent2::showFreq() {
}

int KdeScoreContent2::Pitch(int y) {
  scrKey = _editor->part()->key();
  clef = _editor->part()->clef();
  int ind = int((y-YTOP-_active_system*YDELTA)/3);
  if (clef!=0) ind -= yClef[clef];
  int pi = freqTab[ind];
  if (shftFlag && (!ctrlFlag)) pi++;
  if (ctrlFlag && (!shftFlag)) pi--;
  return pi;
}


void KdeScoreContent2::createLyrics(Note * note, int x, int y) {
  // lyrLine = new QLineEdit(this,"-");
  lyrX = x;
  lyrY = y;
  lyrLine->setGeometry(x,y,30,14);
  // cout << "lyr: " << x << ", " << y << " : " << pos << endl << *note << endl;
  lyricsNote = note;
  // lyricsPart = part;
  oldLyr = note->lyrics();
  if (oldLyr) lyrLine->setText(oldLyr->get());
  else lyrLine->setText("");
  lyrLine->show();
  lyrLine->setActiveWindow();
  lyrLine->setFocus();
}

void KdeScoreContent2::setLyrics() {
  setLyrics(false);
}

void KdeScoreContent2::setLyrics(bool cont) {
  if (lyricsNote!=0) {
    if (lyrLine->text().length()>0) {
      if (oldLyr)
	oldLyr->set(strdup(lyrLine->text().stripWhiteSpace().ascii()));
      else
	sonG->doo(new AddOrnament( new Lyrics(lyricsNote,(strdup(lyrLine->text().stripWhiteSpace().ascii()))), lyricsNote ));
    }
    Note * nx;
    for (nx = (Note*) _editor->part()->next(lyricsNote); nx!=0 && nx->isA()!=NOTE; nx = (Note*) _editor->part()->next(lyricsNote)) {}
    lyrLine->hide();
    repaint(FALSE);
    if (cont && (nx!=0)&&(lyrLine->text().length()>0)) {
      // int x = int(xoffset+(_part->start(nx)-_editor->left().ticks())*pixPerTick);
      createLyrics(nx, _editor->xposition(_part->start(nx).ticks()), lyrY);
    } else {
      setFocus();
    }
  }
  //if (lyrLine!=0) delete lyrLine;
  //lyrLine = 0;
}

void KdeScoreContent2::keyPressEvent ( QKeyEvent * key ) {
  Reference * ref = (Reference*)selectioN->first();
  Event * ev = ref==0 ? 0 : (Event*) ref->getValue();

  switch( key->key() ) {
  case Key_Space:
    if (key->state()==AltButton) {
      // double pixPerTick = (width()-xoffset-4.0)/(_editor->right().ticks()-_editor->left().ticks());
      // long pos = _editor->snap((_moveX-xoffset)/pixPerTick) + _editor->left().ticks();
      ScoreArea area;
      _toolbar->setInsertPoint(_editor->ticks(_moveX, area));
    }
    break;
  case Key_Super_L:
    suprFlag = TRUE;
    break;
  case Key_Shift:
    shftFlag = TRUE;
    _buttonbar->setPitch(Pitch(_moveY),shftFlag,ctrlFlag);
    break;
  case Key_Control:
    ctrlFlag = TRUE;
    _buttonbar->setPitch(Pitch(_moveY),shftFlag,ctrlFlag);
    break;
  case Key_Left:
    _editor->moveselleft();
    break;
  case Key_Right:
    _editor->moveselright();
  break;

  case Key_PageUp:
    _part = _editor->moveUp();
    if (selectioN->first()!=0) sonG->doo(new Unselect());
    update();
    break;

  case Key_PageDown:
    _part = _editor->moveDown();
    if (selectioN->first()!=0) sonG->doo(new Unselect());
    update();
    break;

  case Key_Up:
    if (ev && (ev->isA()==NOTE)) {
      Note * note = (Note*) ev;
      sonG->doo(new ChangeNote(note, _editor->part(), note->pitch() + 1));
    }
    break;
  case Key_Down:
    if (ev && (ev->isA()==NOTE)) {
      Note * note = (Note*) ev;
      sonG->doo(new ChangeNote(note, _editor->part(), note->pitch() - 1));
    }
    break;
  case Key_Enter:
    if (_editor->part()!=0) {
      // sonG->play(0,_editor->part(),_editor->left().ticks(),_editor->right().ticks());
      sonG->play(0,_editor->part(),_editor->left().ticks(),sonG->right().ticks());
    }
    break;
  case Key_Insert:
  case Key_0:
    ME->slotStop();
    break;
  default:
    key->ignore();
  }
  // repaint( FALSE );
}


void KdeScoreContent2::keyReleaseEvent ( QKeyEvent * key ) {
  switch( key->key() ) {
  case Key_Escape:
    // this is here, because keyPressEvent is not thrown for esc without shift, alt or meta...
    if (selectioN->first()!=0) sonG->doo(new Unselect());
    repaint(FALSE);
    break;
  case Key_Space:
    if (key->state()==AltButton) {
    }
    break;
  case Key_Shift:
    shftFlag = FALSE;
    _buttonbar->setPitch(Pitch(_moveY),shftFlag,ctrlFlag);
    break;
  case Key_Control:
    ctrlFlag = FALSE;
    _buttonbar->setPitch(Pitch(_moveY),shftFlag,ctrlFlag);
    break;
  case Key_Super_L:
    suprFlag = FALSE;
    break;
  default:
    key->ignore();
  }
}




void KdeScoreContent2::print() {
  myPrintDialog = new KdeSPD(this,"Print Dialog",_editor);
}

void KdeScoreContent2::printIt() {
  // MupPrinter * mp = new MupPrinter(_editor, mainEditor->filename(), mainEditor->PP(), mainEditor->PPS());

  factory->getScorePrinter()->print(_editor, mainEditor->filename(), mainEditor->PP(), mainEditor->PPS());
  const char * filename = mainEditor->filename();
  char * fname = (char*) strdup(filename); // new char[strlen(filename)+8];
  int flen = strlen(fname);
  fname[flen-3] = 'p'; fname[flen-2] = 's'; fname[flen-1] = 0;
  char * command = new char[3*strlen(fname)+30];
  sprintf(command,"kghostview %s &", fname);
  int e = ::system(command);
  if (e!=0) ME->slotStatusHelpMsg(i18n("An error has occured using kghostview"));
  delete fname;
  delete command;

}

void KdeScoreContent2::moveCursor(int ticks) {

  int pos = _editor->xposition(ticks);
  if (pos>width()-24) {
    _editor->moveleft(_editor->numberOfBars());
    _position_cursor->move(pos, false);
  } else {
    _position_cursor->move(pos);
  }

}

#endif
#include "kdeScoreContent2.moc"
