#ifndef _KDEMAINEDITOR_CPP_
#define _KDEMAINEDITOR_CPP_

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif //HAVE_CONFIG_H

#include "kdeMainEditor.h"
#include <version.h>

#ifdef HAVE_ARTS_ENVIRONMENT
#include "arts/artsmodules.h"
#include "arts/kartswidget.h"
using namespace Arts::Environment;
#endif

#include <stdlib.h>
#include <iostream.h>
#include <math.h>

// include files for QT
#include <qdir.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qspinbox.h>
#include <qprogressbar.h>
#include <qslider.h>
#include <qlineedit.h>
#include <qlayout.h>
#include <qframe.h>
#include <qcursor.h>

// include files for KDE
#include <kprinter.h>
#include <knotifyclient.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kmenubar.h>
#include <klocale.h>
#include <kconfig.h>
#include <kapp.h>
#include <kmainwindow.h>
#include <kaccel.h>
#include <kiconloader.h>
#include <ktoolbar.h>
#include <kaction.h>
#include <kstdaction.h>
#include <klineedit.h>
#include <kdebug.h>
#include <kkeydialog.h>
#include <kedittoolbar.h>
#include <kaboutdata.h>
#include <kstatusbar.h>
#include <kpopupmenu.h>
#include <khelpmenu.h>
#include <kio/netaccess.h>
#include <ktempfile.h>

#include "klineeditaction.h"
#include "kspinboxaction.h"
#include "klabelaction.h"
#include "selectionFrameAction.h"

#include "song.h"
#include "scoreTrack.h"
#include "drumTrack.h"
#include "masterTrack.h"
#include "audioTrack.h"
#include "commentTrack.h"
#include "part.h"
#include "unselect.h"
#include "addElement.h"
#include "cutSelection.h"
#include "copySelection.h"
#include "pasteSelection.h"
#include "vector.h"
#include "reference.h"
#include "str.h"
#include "note.h"
#include "loader.h"
#include "addon.h"
#include "table.h"
#include "player.h"

#include "brahmsResources.h"
#include "kdeArranger.h"
#include "kdeFactory.h"
#include "kdePartEditor.h"
#include "kdeScoreEditor.h"
#include "kdeScoreEditor2.h"
#include "kdePianoRollEditor.h"
#include "kdeTrack.h"
#include "kdeProgress.h"
#include "kdeSpecialEffects.h"
#include "kdePrefs.h"
// #include "kdeShell.h"
#include "headline.h"
#include "selectionFrame.h"
#include "timeBar.h"

#define MAXHEIGHT 2048

extern Song * sonG;
extern Table * selectioN;
extern Table * selectionMemory;


// We override the default KMainWindow flags to not use WDestructiveClose.
// Otherwise, main.cpp will delete us, after we kapp->exec() returned and
// we are deleted already.

KdeMainEditor::KdeMainEditor(const char * name, KApplication * app, int argc, char ** argv)
  : KMainWindow(0, name, WType_TopLevel), PrMainEditor(argc,argv), _app(app), _argc(argc), _argv(argv), _select_area(NONE), _tool(ID_PANEL_ARROW),
    _meter_text(new char[32]), _caption_text(new char[200]), _position_text(new char[32]), _grid(384),
    _track_width(632), _track_height(26), _pixPerTick(1.0/24), _bar_offset(0), _cycl(false),
    shftFlag(false), ctrlFlag(false), suprFlag(false), globalUserDef(0), songUserDef(0)
{
  setupActions();
  initStatusBar();
  initKeyAccel();

  KIconLoader * loader = KGlobal::iconLoader();
  arrTool = loader->loadIcon( "arrow", KIcon::Toolbar);
  cropTool = loader->loadIcon( "editcut", KIcon::Toolbar);
  glueTool = loader->loadIcon( "wizard", KIcon::Toolbar);

  initView();

  setCaption("Brahms");
  _right->setCursor(QCursor(arrTool,0,0));

  timer = new QTimer( this );
  connect( timer, SIGNAL(timeout()), this, SLOT(slotTimerEvent()) );

  _cursor = new QWidget(_right,"musiccursor");
  _cursor->setGeometry(20,0,2,_right->height());
  show();
  _cursor->show();

  setFocusPolicy( QWidget::StrongFocus );
}

KdeMainEditor::~KdeMainEditor()
{
  _recent->saveEntries( kapp->config() );
}

void KdeMainEditor::fatalError (FatalError error)
{
  switch (error)
  {
	case errorArtsConnect:
	  	KNotifyClient::event(KNotifyClient::fatalError,
			i18n( "Brahms couldn't connect aRts sound server. Please ensure "
			      "that artsd is running." ) );
		break;

	case errorArtsMidi:
	  	KNotifyClient::event(KNotifyClient::fatalError,
			i18n( "Brahms didn't find an Arts::MidiManager object on the aRts "
			      "sound server. Please ensure that the kdemultimedia package "
				  "is installed." ) );
		break;

	case errorArtsMidiRecord:
	  	KNotifyClient::event(KNotifyClient::fatalError,
			i18n( "Brahms couldn't initialize midi recording object on aRts "
			  	  "sound server. Currently, Brahms needs to be installed under "
				  "the same prefix aRts/KDE is installed under - i.e. if aRts "
				  "is installed in /opt/kde2, you will need to install Brahms "
				  "there, too (./configure --prefix=/opt/kde2)" ) );
		break;
  }
  exit(1);
}

void KdeMainEditor::run() {
  // initSong();
  loadSong(_argc,_argv);
  // for (Track * tr = (Track*) sonG->content(); tr != 0; tr = (Track*) sonG->next(tr)) tr->presentation()->update();
  update();
  gui(UNDO,false);
  gui(CHANGES,false);
  _app->exec();
}

void KdeMainEditor::update() {
  QWidget::update();
}

SelectArea KdeMainEditor::selectArea() { return _select_area; }

void KdeMainEditor::selectArea(SelectArea a) {
  _select_area = a;
  if (a==NONE) sonG->doo(new Unselect());
}

void KdeMainEditor::displaySongProperties() {
  // Meter:
  snprintf(_meter_text,30," %d / %d",sonG->meter0(),sonG->meter1());
  _meteredit->setText(_meter_text);
  
  // Tempo:
  _tempobox->setValue(sonG->tempo());
  
  // Title:
  if (projectDir()==0)
    sprintf(_caption_text,"Brahms: %s (%s)", sonG->title(), filename());
  else
    sprintf(_caption_text,"Brahms: %s (%s%s)", sonG->title(), projectDir(), filename());

  setCaption(_caption_text);
  
  // Position:
  int a = 0; int b = 0; int c = 0;
  sonG->bbt(a,b,c,sonG->current());
  snprintf(_position_text,30," %d. %d. %d",a,b,c);
  _songposition->lined()->setText(_position_text);
  _songposition->lined()->clearFocus();
  
  // Range:
  _selectionframe->selectionframe()->setTop(sonG->left());
  _selectionframe->selectionframe()->setBottom(sonG->right());
}

void KdeMainEditor::gui(GuiEvents i, bool b) {
  switch (i) {
  case CHANGES:
	_filesave->setEnabled( b );
    break;
  case UNDO:
	_editundo->setEnabled( b );
    break;
  case REDO:
	_editredo->setEnabled( b );
    break;
  case SELECTIONS:
	_editcut->setEnabled( b );
	_editcopy->setEnabled( b );
	_editclearhistory->setEnabled( b );
	//TODO:
    //toolbar->setItemEnabled( ID_EDIT_TRANSPOSE, b );
    //editMenu->setItemEnabled( ID_EDIT_TRANSPOSE, b );
    //editMenu->setItemEnabled( ID_EDIT_QUANTIZE_ALL, b );
    //editMenu->setItemEnabled( ID_EDIT_QUANTIZE_LENGTH, b );
    //editMenu->setItemEnabled( ID_EDIT_FIXED_LENGTH, b );
    break;
  case MEMORY:
	_editpaste->setEnabled( b );
    break;
  }
  update();
}

void KdeMainEditor::startTimer() {
  _play_count = 9;
  _loop = 0;
  _play->setEnabled( false );
  _pause->setEnabled( true );
  _playall->setEnabled( false );
  timer->start((int)(TIMERINTERVALL*0.002));
}

void KdeMainEditor::slotTimerEvent() {
  bool stop = false;
  if (_play_count++ == 10) {
    stop = (!sonG->player()->playQuantum(_cycl));
    _play_count = 0;
  }
  
  if (stop){
    slotStop();
  } else {
    //
    // updating cursors:
    //
    setCursorPosition(sonG->player()->ticks());

    if (_play_count==0) displaySongProperties();
  }
}

void KdeMainEditor::slotStop() {
  timer->stop();
  _play->setEnabled( true );
  _pause->setEnabled( false );
  _playall->setEnabled( true );
  sonG->player()->killAllNotes();

  setCursorPosition(0);
}

void KdeMainEditor::setCursorPosition(long ticks) {
  sonG->setCurrent(ticks);

  PrPartEditor * ed = editor(0);
  for (int i = 0; ed != 0; ed = editor(++i))
    ed->setCursorPosition(ticks);

  _timebar->setCursorPosition(ticks);
  _cursor->move(20+int(ticks*_pixPerTick), 0);
}

// ***********************************************************
// **                                                       **
// **                     Widgets                           **
// **                                                       **
// ***********************************************************
//

void KdeMainEditor::initView()
{
  hide();

  KIconLoader * loader = KGlobal::iconLoader();
  QPixmap qpLeft = loader->loadIcon( "Paper01", KIcon::Desktop );
  QPixmap qpRight = loader->loadIcon( "Planning-And-Probing-1", KIcon::Desktop );

  _main = new QWidget( this, "main widget" );
  setCentralWidget( _main );

  _mainlayout = new QHBoxLayout( _main );

  _splitter = new QSplitter( _main, "main splitter" );
  //_splitter->setFrameStyle( QFrame::Panel & QFrame::Sunken );
  //_splitter->setLineWidth( 4 );
  //_splitter->setMidLineWidth( 4 );
  _splitter->setOpaqueResize(TRUE);
  _mainlayout->addWidget( _splitter );

  _mainvscrollbar = new QScrollBar( 0, MAXHEIGHT, _track_height, _main->height(), 0, QScrollBar::Vertical, _main, "main scrollbar" );
  _mainlayout->addWidget( _mainvscrollbar );
  connect( _mainvscrollbar, SIGNAL( valueChanged( int ) ), SLOT( slotVerticalScroll( int ) ) );

  _leftmain = new QWidget( _splitter );
  _leftmain->setMaximumWidth( _track_width );
  _leftmain->setMinimumWidth( 0 );
  
  _leftscroller = new QScrollView( _leftmain, "left scrollview" );
  _leftscroller->setFrameStyle( QFrame::NoFrame );
  _leftscroller->setVScrollBarMode( QScrollView::AlwaysOff );
  _leftscroller->setHScrollBarMode( QScrollView::Auto );
  _leftscroller->verticalScrollBar()->setLineStep( _track_height );
  _leftscroller->verticalScrollBar()->setPageStep( _main->height() );
  _left = new QWidget( _leftscroller->viewport() );
  _leftscroller->addChild( _left );
  _left->setGeometry( 0, 0, _track_width, MAXHEIGHT );
  _left->setFixedWidth( _track_width );
  _left->setBackgroundPixmap( qpLeft );
  connect( _leftscroller->horizontalScrollBar(), SIGNAL( valueChanged( int ) ), SLOT( slotLeftScroll( int ) ) );
  connect( _leftscroller->verticalScrollBar(), SIGNAL( valueChanged( int ) ), SLOT( slotVerticalScroll( int ) ) );

  QWidget * _headlinescroll = new QWidget( _leftmain );
  _headlinescroll->setFixedHeight( _track_height );
  _headline = new HeadLine(_track_height,_headlinescroll);
  _headline->setFrameStyle( QFrame::Panel | QFrame::Raised );
  _headline->setGeometry(0, 0, _track_width+1, _track_height);

  _leftlayout = new QVBoxLayout( _leftmain );
  _leftlayout->addWidget( _headlinescroll );
  _leftlayout->addWidget( _leftscroller );
  
  userDefArr = new QPopupMenu();
  makeSongMenu(userDefArr);

  _rightmain = new QWidget( _splitter );
  
  _rightscroller = new QScrollView( _rightmain, "right scrollview" );
  _rightscroller->setFrameStyle( QFrame::NoFrame );
  _rightscroller->setVScrollBarMode( QScrollView::AlwaysOff );
  _rightscroller->setHScrollBarMode( QScrollView::Auto );
  _rightscroller->verticalScrollBar()->setLineStep( _track_height );
  _rightscroller->verticalScrollBar()->setPageStep( _main->height() );
  _right = new KdeArranger( _rightscroller->viewport(), userDefArr );
  _rightscroller->addChild( _right );
  _right->setGeometry( 0, 0, 2500, MAXHEIGHT );
  _right->setBackgroundPixmap( qpRight );
  connect( _rightscroller->horizontalScrollBar(), SIGNAL( valueChanged( int ) ), SLOT( slotRightScroll( int ) ) );
  connect( _rightscroller->verticalScrollBar(), SIGNAL( valueChanged( int ) ), SLOT( slotVerticalScroll( int ) ) );

  _timebar = new TimeBar(_rightmain);
  _timebar->setFrameStyle( QFrame::Panel | QFrame::Raised );
  _timebar->setGeometry(0,0,1600,24);
  _timebar->setFixedHeight( 24 );
  _timebar->setLineWidth(2);
  _timebar->setPixPerTick( _pixPerTick );
  _timebar->show();

  _rightlayout = new QVBoxLayout( _rightmain );
  _rightlayout->addWidget( _timebar );
  _rightlayout->addWidget( _rightscroller );

  show();
}

int KdeMainEditor::tool() { return _tool; }

void KdeMainEditor::resizeEvent( QResizeEvent * )
{
  _mainvscrollbar->setPageStep( _main->height() );
  _leftscroller->verticalScrollBar()->setPageStep( _main->height() );
  _rightscroller->verticalScrollBar()->setPageStep( _main->height() );
}

void KdeMainEditor::initKeyAccel()
{
#if 0
  keyAccel = new KAccel(this);
	
  // fileMenu accelerators
  keyAccel->connectItem(KStdAccel::New, this, SLOT(slotFileNew()));
  keyAccel->connectItem(KStdAccel::Open, this, SLOT(slotFileOpen()));
  keyAccel->connectItem(KStdAccel::Save, this, SLOT(slotFileSave()));
  keyAccel->connectItem(KStdAccel::Close, this, SLOT(slotFileClose()));
  keyAccel->connectItem(KStdAccel::Quit, this, SLOT(slotFileQuit()));
  // editMenu accelerators
  keyAccel->connectItem(KStdAccel::Undo, this, SLOT(slotEditUndo()));
  keyAccel->connectItem(KStdAccel::Redo, this, SLOT(slotEditRedo()));
  keyAccel->connectItem(KStdAccel::Cut, this, SLOT(slotEditCut()));
  keyAccel->connectItem(KStdAccel::Copy, this, SLOT(slotEditCopy()));
  keyAccel->connectItem(KStdAccel::Paste, this, SLOT(slotEditPaste()));
  //keyAccel->connectItem("E", this, SLOT(slotEditScore()));
  //keyAccel->connectItem("R", this, SLOT(slotEditPianoRoll()));

  keyAccel->connectItem(KStdAccel::Help, this, SLOT(appHelpActivated()));
			
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_NEW, KStdAccel::New);
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_OPEN, KStdAccel::Open);
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_SAVE, KStdAccel::Save);
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_CLOSE, KStdAccel::Close);
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_QUIT, KStdAccel::Quit);

  keyAccel->changeMenuAccel(editMenu, ID_EDIT_UNDO, KStdAccel::Undo);
  keyAccel->changeMenuAccel(editMenu, ID_EDIT_REDO, KStdAccel::Redo);
  keyAccel->changeMenuAccel(editMenu, ID_EDIT_CUT, KStdAccel::Cut);
  keyAccel->changeMenuAccel(editMenu, ID_EDIT_COPY, KStdAccel::Copy);
  keyAccel->changeMenuAccel(editMenu, ID_EDIT_PASTE, KStdAccel::Paste);
  keyAccel->changeMenuAccel(editMenu, ID_EDIT_EDIT_SCORE, i18n("Edit Score"));
  keyAccel->changeMenuAccel(editMenu, ID_EDIT_EDIT_PIANOROLL, i18n("Edit PianoRoll"));

  keyAccel->readSettings();
#endif
}

void KdeMainEditor::setupActions()
{
	// setup File menu
	KStdAction::openNew( this, SLOT( slotFileNew() ), actionCollection() );
	KStdAction::open( this, SLOT( slotFileOpen() ), actionCollection() );
	_recent = KStdAction::openRecent( this, SLOT( slotFileOpenRecent( const KURL & ) ), actionCollection() );
	_filesave = KStdAction::save( this, SLOT( slotFileSave() ), actionCollection() );
	_filesave->setEnabled( false );
	KStdAction::saveAs( this, SLOT( slotFileSaveAs() ), actionCollection() );
	KStdAction::close( this, SLOT( slotFileClose() ), actionCollection() );
	(void)new KAction( i18n( "Import MIDI..." ), 0, this, SLOT( slotFileImportMidi() ), actionCollection(), "file_import_midi" );
	(void)new KAction( i18n( "Export MIDI..." ), 0, this, SLOT( slotFileExportMidi() ), actionCollection(), "file_export_midi" );
	(void)new KAction( i18n( "Append..." ), 0, this, SLOT( slotFileAppend() ), actionCollection(), "file_append" );
	(void)new KAction( i18n( "Append MIDI..." ), 0, this, SLOT( slotFileAppendMidi() ), actionCollection(), "file_append_midi" );
	(void)new KAction( i18n( "Load Addon..." ), 0, this, SLOT( slotFileLoadAddon() ), actionCollection(), "file_load_addon" );
	(void)new KAction( i18n( "Special effects" ), 0, this, SLOT( slotFileSpecialEffects() ), actionCollection(), "file_special_effects" );
	KStdAction::quit( this, SLOT( slotFileQuit() ), actionCollection() );

	// setup Project menu
	(void)new KAction( i18n( "&Choose Project" ), BarIcon( "folder_sound" ), 0, this, SLOT( slotProjectNew() ), actionCollection(), "project_new" );
	_projectexport = new KAction( i18n( "&Export" ), BarIcon( "forward" ), 0, this, SLOT( slotProjectExport() ), actionCollection(), "project_export" );
	_projectexport->setEnabled( false );
	_projectimport = new KAction( i18n( "&Import" ), BarIcon( "back" ), 0, this, SLOT( slotProjectImport() ), actionCollection(), "project_import" );
	_projectimport->setEnabled( false );
	_projectcollect = new KAction( i18n( "C&ollect in Project" ), 0, this, SLOT( slotProjectCollect() ), actionCollection(), "project_collect" );
	_projectcollect->setEnabled( false );

	// setup Edit menu
	_editundo = KStdAction::undo( this, SLOT( slotEditUndo() ), actionCollection() );
	_editundo->setEnabled( false );
	_editredo = KStdAction::redo( this, SLOT( slotEditRedo() ), actionCollection() );
	_editredo->setEnabled( false );
	_editclearhistory = new KAction( i18n( "Clear History" ), BarIcon( "eraser" ), ALT+Key_H, this, SLOT( slotClearOplist() ), actionCollection(), "edit_clear_history" );
	(void)new KAction( i18n( "Add scoretrack" ), "addt", 0, this, SLOT( slotAddScoretrack() ), actionCollection(), "edit_add_scoretrack" );
	(void)new KAction( i18n( "Add drumtrack" ), 0, this, SLOT( slotAddDrumtrack() ), actionCollection(), "edit_add_drumtrack" );
	(void)new KAction( i18n( "Add mastertrack" ), 0, this, SLOT( slotAddMastertrack() ), actionCollection(), "edit_add_mastertrack" );
	(void)new KAction( i18n( "Add audiotrack" ), 0, this, SLOT( slotAddAudiotrack() ), actionCollection(), "edit_add_audiotrack" );
	(void)new KAction( i18n( "Add comment" ), 0, this, SLOT( slotAddComment() ), actionCollection(), "edit_add_comment" );
	_editcut = KStdAction::cut( this, SLOT( slotEditCut() ), actionCollection() );
	_editcut->setEnabled( false );
	_editcopy = KStdAction::copy( this, SLOT( slotEditCopy() ), actionCollection() );
	_editcopy->setEnabled( false );
	_editpaste = KStdAction::paste( this, SLOT( slotEditPaste() ), actionCollection() );
	_editpaste->setEnabled( false );
	(void)new KAction( i18n( "Edit score" ), ALT+Key_E, this, SLOT( slotEditScore() ), actionCollection(), "edit_edit_score" );
	(void)new KAction( i18n( "Edit score (obs)" ), 0, this, SLOT( slotEditScore2() ), actionCollection(), "edit_edit_score2" );
	(void)new KAction( i18n( "Edit pianoroll" ), ALT+Key_P, this, SLOT( slotEditPianoRoll() ), actionCollection(), "edit_edit_pianoroll" );
	(void)new KAction( i18n( "Mixdown" ), 0, this, SLOT( slotEditMixdown() ), actionCollection(), "edit_mixdown" );
	(void)new KAction( i18n( "Mark left" ), ALT+Key_L, this, SLOT( slotEditMarkLeft() ), actionCollection(), "edit_mark_left" );
	(void)new KAction( i18n( "Mark right" ), ALT+Key_R, this, SLOT( slotEditMarkRight() ), actionCollection(), "edit_mark_right" );
	(void)new KAction( i18n( "Preferences" ), 0, this, SLOT( slotEditPreferences() ), actionCollection(), "edit_preferences" );
	// (void)new KAction( i18n( "Shell" ), 0, this, SLOT( slotEditShell() ), actionCollection(), "edit_shell" );

	// setup Grid menu
	KRadioAction* grid1 = new KRadioAction( i18n( "1/1" ), 0, this, SLOT( slotGrid1() ), actionCollection(), "grid_1" );
	KRadioAction* grid2 = new KRadioAction( i18n( "1/2" ), 0, this, SLOT( slotGrid2() ), actionCollection(), "grid_2" );
	KRadioAction* grid4 = new KRadioAction( i18n( "1/4" ), 0, this, SLOT( slotGrid4() ), actionCollection(), "grid_4" );
	KRadioAction* grid8 = new KRadioAction( i18n( "1/8" ), 0, this, SLOT( slotGrid8() ), actionCollection(), "grid_8" );
	KRadioAction* grid16 = new KRadioAction( i18n( "1/16" ), 0, this, SLOT( slotGrid16() ), actionCollection(), "grid_16" );
	KRadioAction* grid32 = new KRadioAction( i18n( "1/32" ), 0, this, SLOT( slotGrid32() ), actionCollection(), "grid_32" );
	KRadioAction* grid64 = new KRadioAction( i18n( "1/64" ), 0, this, SLOT( slotGrid64() ), actionCollection(), "grid_64" );
	KRadioAction* gridOff = new KRadioAction( i18n( "Off" ), 0, this, SLOT( slotGridOff() ), actionCollection(), "grid_off" );
	grid1->setExclusiveGroup( "grid" );
	grid2->setExclusiveGroup( "grid" );
	grid4->setExclusiveGroup( "grid" );
	grid8->setExclusiveGroup( "grid" );
	grid16->setExclusiveGroup( "grid" );
	grid32->setExclusiveGroup( "grid" );
	grid64->setExclusiveGroup( "grid" );
	gridOff->setExclusiveGroup( "grid" );
	grid4->setChecked( true );

	// setup View menu
	_showtoolbar = KStdAction::showToolbar( this, SLOT( slotViewToolBar() ), actionCollection() );
	_showstatusbar = KStdAction::showStatusbar( this, SLOT( slotViewStatusBar() ), actionCollection() );
	KStdAction::zoomIn( this, SLOT( slotEditPlusH() ), actionCollection() );
	KStdAction::zoomOut( this, SLOT( slotEditMinusH() ), actionCollection() );
	_showpanel = new KToggleAction( i18n( "Show &Panel" ), 0, this, SLOT( slotViewPanel() ), actionCollection(), "view_panel" );
#ifdef HAVE_ARTS_ENVIRONMENT
	_showmixer = new KToggleAction( i18n( "Show &Mixer" ), 0, this, SLOT( slotViewMixer() ), actionCollection(), "view_mixer" );
#endif
	KStdAction::keyBindings( this, SLOT( slotSettingsConfigureKeys() ), actionCollection() );
	KStdAction::configureToolbars( this, SLOT( slotSettingsConfigureToolbars() ), actionCollection() );

	KActionMenu * globalMenu = new KActionMenu( i18n( "Global Plugins" ), actionCollection(), "global_menu" );
	globalUserDef = globalMenu->popupMenu();
	makeGlobalMenu( globalUserDef );
	globalMenu->plug( menuBar() );
	
	KActionMenu * songMenu = new KActionMenu( i18n( "Song Plugins" ), actionCollection(), "song_menu" );
	songUserDef = songMenu->popupMenu();
	makeSongMenu( songUserDef );
	songMenu->plug( menuBar() );
	
	setHelpMenuEnabled( false );

	KAboutData * aboutData = new KAboutData( "brahms", I18N_NOOP( "Brahms" ),
		BRAHMS_VERSION, I18N_NOOP( "KDE Sequencer" ), KAboutData::License_GPL,
		"(C) 199?-2001, The Brahms Developers",
		"", "http://Brahms.sourceforge.net/" );
	aboutData->addAuthor( "Dr. Jan Wuerthner", "Author", "jan.wuerthner@gmx.de" );
	aboutData->addAuthor( "Matthias Kretz", "XMLUI", "kretz@kde.org" );
	(void)new KHelpMenu( this, aboutData, true, actionCollection() );

	_progressbar = new QProgressBar( 100 );
	_progressbar->hide();

	// Toolbar Actions
	KToggleAction* arrow = new KRadioAction( i18n( "arrow" ), "arrow", 0, this, SLOT( slotToolArrow() ), actionCollection(), "arrow" );
	KToggleAction* crop = new KRadioAction( i18n( "crop" ), "editcut", 0, this, SLOT( slotToolCrop() ), actionCollection(), "crop" );
	KToggleAction* glue = new KRadioAction( i18n( "glue" ), "wizard", 0, this, SLOT( slotToolGlue() ), actionCollection(), "glue" );
	arrow->setExclusiveGroup( "cursur" );
	crop->setExclusiveGroup( "cursur" );
	glue->setExclusiveGroup( "cursur" );
	arrow->setChecked( true );

	// Panel Actions
	(void)new KAction( i18n( "Back to Start" ), "start", 0, this, SLOT( slotEditBack() ), actionCollection(), "panel_start" );
	(void)new KAction( i18n( "Rewind" ), "back", 0, this, SLOT( slotEditRewind() ), actionCollection(), "panel_back" );
	_songposition = new KLineEditAction( i18n( "Song Position" ), actionCollection(), "panel_songposition" );
	_songposition->setFont( QFont( "courier" ) );
	(void)new KAction( i18n( "Forward" ), "forward", 0, this, SLOT( slotEditForward() ), actionCollection(), "panel_forward" );
	(void)new KToggleAction( i18n( "Cylce" ), "cycl", 0, this, SLOT( slotEditCycle() ), actionCollection(), "panel_cycle" );
	_record = new KAction( i18n( "Record" ), "run", 0, this, SLOT( slotEditRecord() ), actionCollection(), "panel_record" );
	_record->setEnabled( false );
	_play = new KAction( i18n( "Play (range)" ), "1rightarrow", 0, this, SLOT( slotEditPlay() ), actionCollection(), "panel_play" );
	_playall = new KAction( i18n( "Play (all)" ), "1rightarrow", 0, this, SLOT( slotEditPlayAll() ), actionCollection(), "panel_play_all" );
	_pause = new KAction( i18n( "Pause" ), "player_pause", 0, this, SLOT( slotEditPause() ), actionCollection(), "panel_pause" );
	_pause->setEnabled( false );
	(void)new KAction( i18n( "Stop / Notes off" ), "player_stop", 0, this, SLOT( slotStop() ), actionCollection(), "panel_stop" );
	(void)new KLabelAction( i18n( "Range:" ), actionCollection(), "panel_range" );
	_selectionframe = new SelectionFrameAction( i18n( "Selection" ), 0, 0, 0, actionCollection(), "panel_selectionframe" );
	(void)new KLabelAction( i18n( "Tempo:" ), actionCollection(), "panel_tempo" );
	_tempobox = new KSpinBoxAction( 1, 260000, 1, i18n( "Tempo SpinBox" ), actionCollection(), "panel_tempobox" );
	connect( _tempobox, SIGNAL( valueChanged( int ) ), SLOT( slotTempoEntered( int ) ) );
	_tempobox->setPrefix( " " );
	(void)new KLabelAction( i18n( "Meter:" ), actionCollection(), "panel_meter" );
	_meteredit = new KLineEditAction( i18n( "Meteredit" ), actionCollection(), "panel_meteredit" );
	connect( _meteredit, SIGNAL( returnPressed() ), SLOT( slotMeterEntered() ) );

	createGUI();
}

void KdeMainEditor::paintEvent( QPaintEvent * ev )
{
  for (Track * tr = (Track*) sonG->content(); tr != 0; tr = (Track*) sonG->next(tr)) {
	if (tr->presentation()!=0) tr->presentation()->update();
  }
  displaySongProperties();
  _record->setEnabled( selectArea() == PARTS && selectioN->size() == 1 );
  KMainWindow::paintEvent( ev );
}
	
void KdeMainEditor::adjustHistory() {
  undopopup->clear();
  redopopup->clear();
  Vector * history = sonG->undoList();
  Vector * future = sonG->redoList();
  int sz = history->size();
  for (int i=0; i<sz; i++) {
    undopopup->insertItem(((Operation*) history->get(sz-i-1))->description(),i);
  }
  for (int i=0; i<future->size(); i++) {
    redopopup->insertItem(((Operation*) future->get(i))->description(),i);
  }
}

void KdeMainEditor::slotUndoMenu(int i) {
  sonG->undo(i);
  sonG->updateGui(true);
}

void KdeMainEditor::slotRedoMenu(int i) {
  sonG->redo(i);
  sonG->updateGui(true);
}

void KdeMainEditor::slotSongAddon(int i) {
  if (actionList()[0] != 0) {
    performAction( i, sonG );
  }
}

void KdeMainEditor::slotGlobalAddon(int i) {
  if (actionList()[0] != 0) {
    String * dummy = new String("dummy");
    performAction( i, dummy ); // the parameter must be anything but SONG,TRACK,PART,0
    delete dummy;
  }
}

void KdeMainEditor::updateAddons() {
  // Arranger Menu:
  userDefArr->clear();
  makeSongMenu(userDefArr);
  // Song Menu:
  if (songUserDef==0)
    songUserDef = new QPopupMenu();
  else
    songUserDef->clear();
  makeSongMenu(songUserDef);
  // Global Menu:
  if (globalUserDef==0)
    globalUserDef = new QPopupMenu();
  else
    globalUserDef->clear();
  makeGlobalMenu(globalUserDef);
  // Tracks and Parts:
  for (Track * tr = (Track*) sonG->content(); tr != 0; tr = (Track*) sonG->next(tr)) {
    if (tr->presentation()!=0) tr->presentation()->update(true); // true forces menus to be rebuilt
  }
}


void KdeMainEditor::makeSongMenu(QPopupMenu * menu) {
  char ** alist = actionList();
  char ** clist = categories();
  for (int i=0;clist[i]!=0;i++) {
    QPopupMenu * catMenu = new QPopupMenu();
    menu->insertItem(clist[i],catMenu,i);
    int * nlist = actionListByCategory(clist[i]);
    for (int k=0;nlist[k]!=-1;k++) {
      if (actionContext(nlist[k])&Addon::TREAT_SONG) {
		catMenu->insertItem(alist[nlist[k]],nlist[k]);
	  }
    }
    connect(catMenu,SIGNAL(activated(int)),SLOT(slotSongAddon(int)));
  }
}

void KdeMainEditor::makeGlobalMenu(QPopupMenu * menu) {
  char ** alist = actionList();
  char ** clist = categories();
  for (int i=0;clist[i]!=0;i++) {
    QPopupMenu * catMenu = new QPopupMenu();
    menu->insertItem(clist[i],catMenu,i);
    int * nlist = actionListByCategory(clist[i]);
    for (int k=0;nlist[k]!=-1;k++) {
      if (actionContext(nlist[k])&Addon::TREAT_GLOBAL) catMenu->insertItem(alist[nlist[k]],nlist[k]);
    }
    connect(catMenu,SIGNAL(activated(int)),SLOT(slotGlobalAddon(int)));
  }
}

void KdeMainEditor::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  // STATUSBAR
  // TODO: add your own items you need for displaying current application status.
  statusBar()->insertItem("          ", ID_STATUS_MSG, true);
}


void KdeMainEditor::addRecentFile(const KURL &url)
{
	_recent->addURL( url );
}



/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void KdeMainEditor::slotFileNewWindow()
{
  slotStatusMsg(i18n("Opening a new application window..."));
  // KdeMainEditor *new_window= new KdeMainEditor();
  // new_window->show();

  slotStatusMsg(IDS_STATUS_DEFAULT);
}

void KdeMainEditor::slotFileNew()
{
  slotStatusMsg(i18n("Creating new document..."));
  // if (_file_name!=0) delete _file_name;
  setFilename(strdup("untitled.bms"));
  if (sonG!=0) delete sonG;
  sonG = new Song();
  update();
  slotStatusMsg(IDS_STATUS_DEFAULT);
}

void KdeMainEditor::slotFileOpen()
{
  slotStatusMsg(i18n("Opening file..."));
  loadFile( KFileDialog::getOpenURL( ":load_bms", i18n( "*.bms|Brahms" ), this, i18n( "Open File..." ) ) );
  slotStatusMsg(IDS_STATUS_DEFAULT);
}

void KdeMainEditor::slotFileOpenRecent( const KURL & url )
{
  slotStatusMsg(i18n("Opening file..."));
  loadFile( url );
  slotStatusMsg(IDS_STATUS_DEFAULT);
}

void KdeMainEditor::slotFileLoadAddon()
{
  slotStatusMsg(i18n("Loading addon..."));
  QString fileToOpen = KFileDialog::getOpenFileName(QDir::currentDirPath(), i18n("libBrahmsAddon*.la|Brahms"), this, i18n("Loading Addon..."));
  // cout << fileToOpen.ascii() << endl;
  if(!fileToOpen.isEmpty()) {
    /* setFilename( (char*) strdup(fileToOpen) );
    if (sonG!=0) delete sonG;
    sonG = Loader::load(filename(), new KdeProgress(_progressbar));
    update();
    _progressbar->reset();*/
    bool ok = insertAddon( strdup(fileToOpen.ascii()) );
    if (ok) {
      update();
      updateAddons();
    }
  }
  slotStatusMsg(IDS_STATUS_DEFAULT);
}

void KdeMainEditor::slotFileSave()
{
  slotStatusMsg(i18n("Saving file..."));
  if (projectDir()==0)
    saveFile( KURL( QDir::currentDirPath()+QDir::separator()+filename() ) );
  else
    saveFile( KURL( QString(projectDir())+filename() ) );
  slotStatusMsg(IDS_STATUS_DEFAULT);
}

void KdeMainEditor::slotFileSaveAs()
{
  slotStatusMsg(i18n("Saving file with a new filename..."));
  // saveFile( KFileDialog::getSaveURL( ":save_bms", i18n("*.bms|Brahms"), this, i18n("Save as...") ) );
  saveFile( KFileDialog::getSaveURL( filename(), i18n("*.bms|Brahms"), this, i18n("Save as...") ) );
  slotStatusMsg(IDS_STATUS_DEFAULT);
}


void KdeMainEditor::slotFileImportMidi() {
  slotStatusMsg(i18n("Importing Midi File..."));
  QString fileToOpen = KFileDialog::getOpenFileName(QDir::currentDirPath(), i18n("*.mid|Midi"), this, i18n("Open File..."));
  if(!fileToOpen.isEmpty()) {
    char * xy = (char*) strdup(fileToOpen);
    if (sonG!=0) delete sonG;
    sonG = Loader::loadMidi(xy, new KdeProgress(_progressbar));
    update();
    _progressbar->reset();
  }
  slotStatusMsg(IDS_STATUS_DEFAULT);
}

void KdeMainEditor::slotFileExportMidi() {
  slotStatusMsg(i18n("Exporting Midi File..."));
  slotStatusMsg(IDS_STATUS_DEFAULT);
}

void KdeMainEditor::slotFileAppend() {
  slotStatusMsg(i18n("Appending File..."));
  slotStatusMsg(IDS_STATUS_DEFAULT);
}

void KdeMainEditor::slotFileAppendMidi() {
  slotStatusMsg(i18n("Appending Midi File..."));
  slotStatusMsg(IDS_STATUS_DEFAULT);
}

void KdeMainEditor::slotFileSpecialEffects() {
  slotStatusMsg(i18n("Say hello to the authors..."));
  new KdeSpecialEffects("authors");
  slotStatusMsg(IDS_STATUS_DEFAULT);
}

void KdeMainEditor::slotFileClose()
{
  slotStatusMsg(i18n("Closing file..."));
	
  close();
  slotStatusMsg(IDS_STATUS_DEFAULT);
}

void KdeMainEditor::slotFilePrint()
{
  slotStatusMsg(i18n("Printing..."));

  KPrinter printer;
  if (printer.setup(this))
  {
    // view->print(&printer);
  }

  slotStatusMsg(IDS_STATUS_DEFAULT);
}

void KdeMainEditor::slotFileQuit()
{
  slotStatusMsg(i18n("Exiting..."));
  close();
}


void KdeMainEditor::slotProjectNew() {
  slotStatusMsg(i18n("new project..."));
  QString dir = KFileDialog::getExistingDirectory(QDir::currentDirPath(), this, i18n("Choose new project directory..."));
  // QString fileToOpen = KFileDialog::getOpenFileName(QDir::homeDirPath(), i18n("*.bms|Brahms"), this, i18n("Open File..."));
  if(!dir.isEmpty()) {
    bool ok = QDir::setCurrent(dir);
    if (ok) {
      // cout << "ok: " << QDir::currentDirPath() << ", " << dir << endl;
      setProjectDir( (char*) strdup(dir) );
      displaySongProperties();
    } else {
      cout << "error: " << QDir::currentDirPath() << ", " << dir << endl;
    }
  }
  slotStatusMsg(IDS_STATUS_DEFAULT);
}

void KdeMainEditor::slotProjectExport() {

}

void KdeMainEditor::slotProjectImport() {

}

void KdeMainEditor::slotProjectCollect() {

}



void KdeMainEditor::slotEditCut()
{
  slotStatusMsg(i18n("Cutting selection..."));
  if (selectArea()==TRACKS) {
    sonG->doo(new CutSelection(sonG));
  } else {
    Reference * ref = (Reference*)selectioN->first();
    if (ref!=0) {
      sonG->doo(new CutSelection(((Part*)ref->getValue())->track()));
    }
  }
  slotStatusMsg(IDS_STATUS_DEFAULT);
  selectArea(NONE);
  update();
}

void KdeMainEditor::slotEditCopy()
{
  slotStatusMsg(i18n("Copying selection to clipboard..."));
  sonG->doo(new CopySelection());
  
  slotStatusMsg(IDS_STATUS_DEFAULT);
  // selectArea(NONE);
  update();
}

void KdeMainEditor::slotEditPaste()
{
  // paste regarding the following rules:
  // in memory:     selected:     paste into:
  //   PART           PART        -> the selected PART's track
  //   PART           TRACK       -> the selected track
  //   TRACK          *           -> the song

  slotStatusMsg(i18n("Inserting clipboard contents..."));
  if (selectionMemory!=0 && selectioN!=0) {
    Reference * refMem = (Reference*)selectionMemory->first();
    Reference * refSel = (Reference*)selectioN->first();
    if (refMem!=0) {
      //
      // paste Track
      //
      if        (refMem->getValue()->isTrack()) { // paste track(s) into the song: (3)
	sonG->doo(new PasteSelection(sonG, 0));
      } else if (refMem->getValue()->isA()==PART) { // check selection
	//
	// paste Part
	//
	if (refSel!=0) {
	  if (refSel->getValue()->isA()==PART) { // paste parts into track: (1)
	    sonG->doo(new PasteSelection(((Part*)refSel->getValue())->track(), sonG->current().ticks()));
	  } else if (refSel->getValue()->isTrack()) { // paste parts into track: (2)
	    sonG->doo(new PasteSelection(((Track*)refSel->getValue()), sonG->current().ticks()));
	  }
	}
      }
    }
  }
  slotStatusMsg(IDS_STATUS_DEFAULT);
  selectArea(NONE);
}

void KdeMainEditor::slotAddTrack(int i)
{
  slotStatusMsg(i18n("Adding Track..."));
  switch (i) {
  case ID_SCORE:  sonG->doo(new AddElement(new ScoreTrack(), sonG)); break;
  case ID_DRUM:   sonG->doo(new AddElement(new DrumTrack(), sonG)); break;
  case ID_MASTER: sonG->doo(new AddElement(new MasterTrack(), sonG)); break;
  case ID_AUDIO:  sonG->doo(new AddElement(new AudioTrack(), sonG)); break;
  case ID_TEXT:   sonG->doo(new AddElement(new CommentTrack(), sonG)); break;
  }
  selectArea(NONE);
  update();
  slotStatusMsg(IDS_STATUS_DEFAULT);
}

void KdeMainEditor::slotAddScoretrack()
{
  slotStatusMsg(i18n("Adding Scoretrack..."));
  sonG->doo(new AddElement(new ScoreTrack(), sonG));
  selectArea(NONE);
  update();
  slotStatusMsg(IDS_STATUS_DEFAULT);
}

void KdeMainEditor::slotAddDrumtrack()
{
  slotStatusMsg(i18n("Adding Drumtrack..."));
  sonG->doo(new AddElement(new DrumTrack(), sonG));
  selectArea(NONE);
  update();
  slotStatusMsg(IDS_STATUS_DEFAULT);
}

void KdeMainEditor::slotAddMastertrack()
{
  slotStatusMsg(i18n("Adding Mastertrack..."));
  sonG->doo(new AddElement(new MasterTrack(), sonG));
  selectArea(NONE);
  update();
  slotStatusMsg(IDS_STATUS_DEFAULT);
}

void KdeMainEditor::slotAddAudiotrack()
{
  slotStatusMsg(i18n("Adding Audiotrack..."));
  sonG->doo(new AddElement(new AudioTrack(), sonG));
  selectArea(NONE);
  update();
  slotStatusMsg(IDS_STATUS_DEFAULT);
}

void KdeMainEditor::slotAddComment()
{
  slotStatusMsg(i18n("Adding Comment..."));
  sonG->doo(new AddElement(new CommentTrack(), sonG));
  selectArea(NONE);
  update();
  slotStatusMsg(IDS_STATUS_DEFAULT);
}

void KdeMainEditor::slotViewToolBar()
{
	if( _showtoolbar->isChecked() )
		toolBar( "mainToolBar" )->show();
	else
		toolBar( "mainToolBar" )->hide();
}

void KdeMainEditor::slotViewPanel()
{
	if( _showpanel->isChecked() )
		toolBar( "panelToolBar" )->show();
	else
		toolBar( "panelToolBar" )->hide();
}

void KdeMainEditor::slotViewMixer()
{
	if( _showmixer->isChecked() )
	{
#ifdef HAVE_ARTS_ENVIRONMENT
		Arts::GenericGuiFactory guiFactory;
		Arts::Widget widget = guiFactory.createGui(sonG->envMixer());
		if (!widget.isNull()) {
			KArtsWidget * kartswidget = new KArtsWidget(widget);
			kartswidget->show();
		} else {
			cout << "widget is null" << endl;
		}
#endif
	}
}

void KdeMainEditor::slotViewStatusBar() {
	if( _showstatusbar->isChecked() )
		statusBar()->show();
	else
		statusBar()->hide();
}

void KdeMainEditor::slotSettingsConfigureKeys()
{
  KKeyDialog::configureKeys( actionCollection(), xmlFile() );
}

void KdeMainEditor::slotSettingsConfigureToolbars()
{
  //saveMainWindowSettings( KGlobal::config(), "MainWindow" );
  KEditToolbar dlg( actionCollection() );
  connect( &dlg, SIGNAL( newToolbarConfig() ), this, SLOT( slot_newToolbarConfig() ) );

  if ( dlg.exec() )
    createGUI();
}

void KdeMainEditor::slotNewToolbarConfig() //This is called when OK or Apply is clicked
{
  //applyMainWindowSettings( KGlobal::config(), "MainWindow" );
  createGUI();
}

void KdeMainEditor::slotGrid1()
{
  slotStatusMsg(i18n("set grid to whole"));
  setGrid( 1536 );
}

void KdeMainEditor::slotGrid2()
{
  slotStatusMsg(i18n("set grid to half"));
  setGrid( 768 );
}

void KdeMainEditor::slotGrid4()
{
  slotStatusMsg(i18n("set grid to quarter"));
  setGrid( 384 );
}

void KdeMainEditor::slotGrid8()
{
  slotStatusMsg(i18n("set grid to eighths"));
  setGrid( 192 );
}

void KdeMainEditor::slotGrid16()
{
  slotStatusMsg(i18n("set grid to sixteenths"));
  setGrid( 96 );
}

void KdeMainEditor::slotGrid32()
{
  slotStatusMsg(i18n("set grid to 32nd"));
  setGrid( 48 );
}

void KdeMainEditor::slotGrid64()
{
  slotStatusMsg(i18n("set grid to 64th"));
  setGrid( 24 );
}

void KdeMainEditor::slotGridOff()
{
  slotStatusMsg(i18n("turn grid off"));
  setGrid( 0 );
}

int KdeMainEditor::snap()
{
  return _grid;
}

void KdeMainEditor::slotClearOplist()
{
  sonG->clearOplist();
}

void KdeMainEditor::slotVerticalScroll( int value )
{
  _mainvscrollbar->setMaxValue( _rightscroller->verticalScrollBar()->maxValue() );
  _leftscroller->verticalScrollBar()->setValue( value );
  _rightscroller->verticalScrollBar()->setValue( value );
  _mainvscrollbar->setValue( value );
}

void KdeMainEditor::slotLeftScroll( int value )
{
  _headline->move( -value, 0 );
}

void KdeMainEditor::slotRightScroll( int value )
{
  _timebar->setOffset( value );
}

void KdeMainEditor::slotStatusMsg(const QString &text) {
  statusBar()->clear();
  //statusBar()->changeItem(text, ID_STATUS_MSG);
  statusBar()->message( text );
}


void KdeMainEditor::slotStatusHelpMsg(const QString &text) {
  statusBar()->message(text, 2000);
}


void KdeMainEditor::slotEditUndo() {
    sonG->undo();
    selectArea(NONE);
    update();
}

void KdeMainEditor::slotEditRedo() {
    sonG->redo();
    selectArea(NONE);
    update();
}

void KdeMainEditor::slotEditPlusH() {
  _pixPerTick *= 2.0;
  _timebar->setPixPerTick( _pixPerTick );
  update();
}

void KdeMainEditor::slotEditMinusH() {
  _pixPerTick /= 2.0;
  _timebar->setPixPerTick( _pixPerTick );
  update();
}

void KdeMainEditor::slotEditScore() {
  if (sonG->hasScore()) {
    KdeScoreEditor2 * ev = new KdeScoreEditor2(this);
    addEditor(ev);
    ev->KMainWindow::show();
  }
}

void KdeMainEditor::slotEditScore2() {
  if (sonG->hasScore()) {
    KdeScoreEditor * ev = new KdeScoreEditor();
    addEditor(ev);
    ev->KMainWindow::show();
  }
}

void KdeMainEditor::slotEditPianoRoll() {
  if (sonG->hasScore()) {
    KdePianoRollEditor * pn = new KdePianoRollEditor();
    addEditor(pn);
    pn->KMainWindow::show();
  }
}

void KdeMainEditor::slotEditPreferences() {
  // KdePrefs * prefs =
  new KdePrefs(this,"prefs");
}

void KdeMainEditor::slotEditShell() {
  // KdeShell * shell = new KdeShell();
  // shell->show();
}

void KdeMainEditor::slotPosEntered() {
  QString qs = _songposition->lined()->text();
  qs = qs.simplifyWhiteSpace();
  int c1 = qs.find('.');
  if (c1 != -1) {
    int c2 = qs.find('.',c1+1);
    if (c2 != -1) sonG->setCurrent(atoi(qs.left(c1)), atoi(qs.mid(c1+1,c2-c1-1)), atoi(qs.right(qs.length()-c2-1)));
  } else {
    sonG->setCurrent(atoi(qs), 1, 0);
  }
  _songposition->lined()->clearFocus();
  update();
}

void KdeMainEditor::slotTempoEntered(int i) {
  sonG->setTempo(i);
  _tempobox->spinbox()->clearFocus();
  update();
}

void KdeMainEditor::slotMeterEntered() {
  QString qs = _meteredit->lined()->text();
  qs = qs.simplifyWhiteSpace();
  int c1 = qs.find('/');
  if (c1 != -1) {
    sonG->setMeter(atoi(qs.left(c1)), atoi(qs.right(qs.length()-c1-1)));
  }
  _meteredit->lined()->clearFocus();
  update();
}

void KdeMainEditor::slotToolArrow()
{
  _right->setCursor(QCursor(arrTool,0,0));
  _tool = ID_PANEL_ARROW;
}

void KdeMainEditor::slotToolCrop()
{
  _right->setCursor(QCursor(cropTool,0,19));
  _tool = ID_PANEL_CROP;
}

void KdeMainEditor::slotToolGlue()
{
  _right->setCursor(QCursor(glueTool,17,6));
  _tool = ID_PANEL_GLUE;
}

void KdeMainEditor::slotEditMarkLeft() {
  QString qs = _songposition->lined()->text();
  qs = qs.simplifyWhiteSpace();
  int c1 = qs.find('.');
  if (c1 != -1) {
    int c2 = qs.find('.',c1+1);
    // if (c2 != -1) _selectionframe->selectionframe()->setTop(atoi(qs.right(qs.length()-c2-1)), atoi(qs.mid(c1+1,c2-c1-1)), atoi(qs.left(c1)));
    if (c2 != -1) sonG->setLeft(atoi(qs.left(c1)), atoi(qs.mid(c1+1,c2-c1-1)), atoi(qs.right(qs.length()-c2-1)));
    displaySongProperties();
    _timebar->repaint(FALSE);
  }
}

void KdeMainEditor::slotEditMarkRight() {
  QString qs = _songposition->lined()->text();
  qs = qs.simplifyWhiteSpace();
  int c1 = qs.find('.');
  if (c1 != -1) {
    int c2 = qs.find('.',c1+1);
    // if (c2 != -1) _selectionframe->selectionframe()->setBottom(atoi(qs.right(qs.length()-c2-1)), atoi(qs.mid(c1+1,c2-c1-1)), atoi(qs.left(c1)));
    if (c2 != -1) sonG->setRight(atoi(qs.left(c1)), atoi(qs.mid(c1+1,c2-c1-1)), atoi(qs.right(qs.length()-c2-1)));
    displaySongProperties();
    _timebar->repaint(FALSE);
  }
}

void KdeMainEditor::slotEditMixdown() {
}

void KdeMainEditor::slotEditBack() {
	setCursorPosition( 0 );
    displaySongProperties();
}

void KdeMainEditor::slotEditRewind() {
    Position p = sonG->current();
    p.prevBar();
	setCursorPosition( p.ticks() );
    displaySongProperties();
}

void KdeMainEditor::slotEditForward() {
    Position p = sonG->current();
    p.nextBar();
	setCursorPosition( p.ticks() );
    displaySongProperties();
}

void KdeMainEditor::slotEditCycle() {
	_cycl = !_cycl;
}

void KdeMainEditor::slotEditRecord() {
    sonG->play(0, 0, sonG->current().ticks(), sonG->right().ticks(), _cycl, 0); // Track number
}

void KdeMainEditor::slotEditPlay() {
    sonG->play(0, 0, sonG->current().ticks(), sonG->right().ticks(), _cycl);
}

void KdeMainEditor::slotEditPlayAll() {
    sonG->play(0, 0, sonG->current().ticks(), 0, _cycl);
}

void KdeMainEditor::slotEditPause() {
  timer->stop();
  _play->setEnabled( true );
  _pause->setEnabled( false );
  _playall->setEnabled( true );
  sonG->player()->killAllNotes();
}

void KdeMainEditor::keyPressEvent ( QKeyEvent * key ) {
  switch( key->key() ) {
  case Key_Super_L:
    suprFlag = TRUE;
    break;
  case Key_Shift:
    shftFlag = TRUE;
    break;
  case Key_Control:
    ctrlFlag = TRUE;
    break;
  case Key_Left:
	_rightscroller->scrollBy( -20, 0 );
	break;
  case Key_Right:
	_rightscroller->scrollBy( 20, 0 );
	break;
  case Key_Up:
	_leftscroller->scrollBy( 0, -_track_height );
	break;
  case Key_Down:
	_leftscroller->scrollBy( 0, _track_height );
	break;
  case Key_PageUp:
	_leftscroller->scrollBy( 0, -_leftscroller->height() );
    break;
  case Key_PageDown:
	_leftscroller->scrollBy( 0, _leftscroller->height() );
    break;
  case Key_Enter:
    sonG->play(0, 0, sonG->current().ticks(), sonG->right().ticks(), _cycl);
    break;
  case Key_0:
	if( sonG->player()->playing() )
	  slotStop();
	else
	  key->ignore();
    break;
  default:
    key->ignore();
  }

}

void KdeMainEditor::keyReleaseEvent ( QKeyEvent * key ) {
  switch( key->key() ) {
  case Key_Escape:
    if (selectioN->size()>0) selectArea(NONE);
    break;
  case Key_Shift:
    shftFlag = FALSE;
    break;
  case Key_Control:
    ctrlFlag = FALSE;
    break;
  case Key_Super_L:
    suprFlag = FALSE;
    break;
  default:
    key->ignore();
  }
}

bool KdeMainEditor::shft() { return shftFlag; }

bool KdeMainEditor::ctrl() { return ctrlFlag; }

bool KdeMainEditor::supr() { return suprFlag; }

void KdeMainEditor::initSong() {

  ScoreTrack * tr = new ScoreTrack();
  sonG->doo(new AddElement(tr,sonG));
  sonG->doo(new AddElement(new ScoreTrack(),sonG));
  sonG->doo(new AddElement(new ScoreTrack(),sonG));
  sonG->doo(new AddElement(new ScoreTrack(),sonG));


  Part * pt = new Part(tr);
  sonG->doo(new AddElement(pt,tr));

  sonG->doo(new AddElement(new Note(68,30,192,0,0),pt));
  sonG->doo(new AddElement(new Note(70,100,192,192,0),pt));
  sonG->doo(new AddElement(new Note(72,120,1536,384,0),pt));
  
}

void KdeMainEditor::loadFile( const KURL & url ) {
  if( !url.isEmpty() ) {
    if( url.isMalformed() ) {
      kdWarning() << "KdeMainEditor::loadFile() called with invalid url" << endl;
      return;
    }
    QString fileToOpen;
    if( !KIO::NetAccess::download( url, fileToOpen ) )
      {
	KMessageBox::error( this, i18n( "Could not load\n%1" ).arg( url.prettyURL() ) );
	return;
      }
    QString path = fileToOpen.left(fileToOpen.findRev(QDir::separator()));
    bool ok = QDir::setCurrent(path);
    if (!ok) cout << "warning: could not set path to " << path << endl;

    char * fn = strdup(QFile::encodeName(fileToOpen));
    setFilename( fn );
    if (sonG!=0) delete sonG;
    sonG = Loader::load(fn, new KdeProgress(_progressbar));
    update();
	_recent->addURL( url );
    _progressbar->reset();
    displaySongProperties();
  }
}

void KdeMainEditor::saveFile( const KURL & url ) {
  if( !url.isEmpty() ) {
	if( url.isMalformed() ) {
	  kdWarning() << "KdeMainEditor::saveFile() called with invalid url" << endl;
	  return;
	}
	QString fileToSave;
	if( url.isLocalFile() )
	  fileToSave = url.path();
	else
	{
	  KTempFile ktempf;
	  fileToSave = ktempf.name();
	}
	kdDebug() << "saveFile fileToSave = " << fileToSave << endl;
	char * fn = strdup(QFile::encodeName(fileToSave));
	// cout << "save: " << fn << endl;
	setFilename( fn );
	Loader::save(fn, sonG);
	update();
	// cout << "cur: " << QDir::currentDirPath() << endl;
	if( !KIO::NetAccess::upload( fileToSave, url ) ) {
	  KMessageBox::error( this, i18n( "Could not save\n%1" ).arg( url.prettyURL() ) );
	  return;
	}
	_recent->addURL( url );
	displaySongProperties();
  }
}

QWidget * KdeMainEditor::left() { return _left; }

QWidget * KdeMainEditor::right() { return _right; }

int KdeMainEditor::trackHeight() { return _track_height; }

double KdeMainEditor::pixPerTick() { return _pixPerTick; }

int KdeMainEditor::barOffset() { return _bar_offset; }


#endif
#include "kdeMainEditor.moc"

// vim:sw=2:ts=4
