#ifndef _UNSELECT_H_
#define _UNSELECT_H_

#include "operation.h"

class Element;
class Compound;
class Table;
class Reference;

/** This operation unselects the selection
 */
class Unselect : public Operation
{
 private:
  Table * _oldTable;
  Table * _delete;

 public:
  Unselect();
  Unselect(const Unselect&);
  ~Unselect();

  void undo();
  void redo();

  static bool empty();

  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};



#endif
